/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

/**
 * Application descriptor property description holding
 * a list of strings.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:25 $
 * <br>
 * @author Craig Setera
 */
public class ListDescriptorPropertyDescription
	extends DescriptorPropertyDescription 
{
	// The list of names and values
	private String[][] namesAndValues;
	
	/**
	 * Constructor
	 * 
	 * @param propertyName
	 * @param displayName
	 * @param namesAndValues
	 */
	public ListDescriptorPropertyDescription(
		String propertyName,
		String displayName,
		String[][] namesAndValues)
	{
		super(propertyName, displayName, DATATYPE_LIST);
		this.namesAndValues = namesAndValues;
	}
	
	/**
	 * @return Returns the namesAndValues.
	 */
	public String[][] getNamesAndValues() {
		return namesAndValues;
	}
}
