/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.core.ui.util.MidletSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

/**
 * A simple helper class for creating a Type selection dialog
 * that allows for selection of Midlet subclasses.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:25 $
 * <br>
 * @author Craig Setera
 */
public class MidletSelectionDialogCreator {

	/**
	 * Create a new midlet selection dialog.
	 * 
	 * @param shell
	 * @param context
	 * @param javaProject
	 * @param multipleSelect
	 * @return
	 * @throws JavaModelException
	 */
	public static SelectionDialog createMidletSelectionDialog(
			Shell shell,
			IRunnableContext context,
			IJavaProject javaProject,
			boolean multipleSelect) 
				throws JavaModelException
	{
		IJavaSearchScope searchScope = new MidletSearchScope(javaProject);

		SelectionDialog dialog =
			JavaUI.createTypeDialog(
				shell,
				context,
				searchScope,
				IJavaElementSearchConstants.CONSIDER_CLASSES_AND_INTERFACES,	
				multipleSelect,
				"*"); 

		dialog.setTitle("Choose Midlet");
		dialog.setMessage("Choose midlet to be emulated");
		
		return dialog;
	}
	
	// Private constructor for static access
	private MidletSelectionDialogCreator() {}
}
