/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.dialog;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIPlugin;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeploymentManagementDialog extends TitleAreaDialog {
	private DeploymentManagementDialog dplmDialog = this;
	private String strSelResource = ""; //$NON-NLS-1$
	private Shell shell;
	private Button btnResourceBrowse, btnRefresh, btnDeploy, btnSelectProject, btnCancel;
	private Label lblResource, lblDescription;
	private Text txtResourceFile, txtSelectProject;    
    protected Combo cboProtocol;
	private String[] resourceFilterExt = null; //{ "*.jar; *.sis; *.res; *" };
	private CheckboxTreeViewer deviceViewer;
    private ProvidersContentProvider contentProvider = new ProvidersContentProvider();    
    private ProvidersLabelProvider labelProvider;    
    private Object selectedResource;
	private IJavaProject javaProject;	
	private List<Device> selectedDevices = new Vector<Device>();	
	private IProgressMonitor monitor = null;
	private MidletDeployment midlet = null;
	
	

	/**
	 * The constructor
	 */
	public DeploymentManagementDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE);

		labelProvider = new ProvidersLabelProvider();
		/*
		MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL, null,	null);
		if(list.length > 0) {
			labelProvider = new ProvidersLabelProvider((DeploymentManagement) list[0]);
		}
		*/
	}

	protected Control createDialogArea(Composite parent) {

	    // TODO: replace static strings
        
        shell = this.getShell();
        Image image = DeploymentManagementUIPlugin.getImageDescriptor("icons/phone.gif").createImage(); //$NON-NLS-1$
        shell.setImage(image);
        
		Composite result = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(result, SWT.NONE);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		this.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogTitle);
		setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogDescription);
		this.setTitleImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage()); //$NON-NLS-1$
        
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
		container.setLayout(gridLayout);
        
    	Composite container2 = new Composite(container, SWT.NONE);
    	GridData gd = new GridData(SWT.FILL, SWT.FILL, true, false);
        gd.horizontalSpan = 2;
        container2.setLayoutData(gd);
        
		gridLayout = new GridLayout();
		container2.setLayout(gridLayout);
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        
        Label lblProject = new Label(container2, SWT.NONE);
		lblProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Project);
        
        txtSelectProject = new Text(container2, SWT.BORDER);
		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalSpan = 2;
		txtSelectProject.setLayoutData(gd);
		txtSelectProject.setEditable(false);
		txtSelectProject.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
		//		strSelResource = txtSelectProject.getText();
			}
		});
		
        btnSelectProject = new Button(container2, SWT.NONE);
        initializeDialogUnits(btnSelectProject);
        setButtonLayoutData(btnSelectProject);
        btnSelectProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
        addBtnSelectProjectListeners(btnSelectProject);
		      
        lblResource = new Label(container2, SWT.NONE);
		lblResource.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Resource);

		txtResourceFile = new Text(container2, SWT.BORDER);
		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalSpan = 2;
		txtResourceFile.setLayoutData(gd);
		txtResourceFile.setEditable(false);
		txtResourceFile.setText(""); //$NON-NLS-1$
		txtResourceFile.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				strSelResource = txtResourceFile.getText();
			}
		});
		
		btnResourceBrowse = new Button(container2, SWT.NONE);
		initializeDialogUnits(btnResourceBrowse);
		setButtonLayoutData(btnResourceBrowse);
		btnResourceBrowse.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
		btnResourceBrowse.addSelectionListener(new OpenResource());	  

        Group grpDevices = new Group(container, SWT.NONE);       
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Devices); 
        gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        grpDevices.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        grpDevices.setLayout(gridLayout);
        
        Composite deviceTreeArea = new Composite(grpDevices, SWT.NONE);
        FillLayout layout2 = new FillLayout();
        deviceTreeArea.setLayout(layout2);
        gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        deviceTreeArea.setLayoutData(gd);
        
        deviceViewer = new CheckboxTreeViewer(deviceTreeArea);
        addDeviceViewerListeners(deviceViewer);

        Label label = new Label(grpDevices, SWT.NONE);
        gd = new GridData(SWT.FILL, SWT.FILL, true, false);
        label.setLayoutData(gd);
        
        btnRefresh = new Button(grpDevices, SWT.NONE);
        initializeDialogUnits(btnRefresh);
        setButtonLayoutData(btnRefresh);
        btnRefresh.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Refresh); 
        addBtnRefreshListeners(btnRefresh);

        Group grpDescription = new Group(container, SWT.NONE);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Description); 
        gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        gd.horizontalSpan = 1;
        gd.heightHint = 200;
        grpDescription.setLayoutData(gd);
        gridLayout = new GridLayout();
        grpDescription.setLayout(gridLayout);
     
        lblDescription = new Label(grpDescription, SWT.WRAP);
        gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        gd.widthHint = 200;
        lblDescription.setLayoutData(gd);
        
        Label separator = new Label(result, SWT.SEPARATOR 
                | SWT.HORIZONTAL);
        gd = new GridData(SWT.FILL, SWT.BOTTOM, true, false);
        separator.setLayoutData(gd);  
        
        deviceViewer.setContentProvider(contentProvider);
        deviceViewer.setLabelProvider(labelProvider);
        
        List<DeploymentProvider> providersList = new Vector<DeploymentProvider>();
        MtjExtension[] providers = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
        for(int i=0; i<providers.length; i++){
        	providersList.add((DeploymentProvider) providers[i]);
        }
        
        deviceViewer.setInput(providersList);        
		return result;
	}
	
	private class OpenResource implements SelectionListener {
		public void widgetSelected(SelectionEvent event) {
			FileDialog fileDialog = new FileDialog(shell, SWT.OPEN);
			// TODO replace static strings
			fileDialog
					.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToBeDeployed); 
			fileDialog.setFilterPath(ResourcesPlugin.getWorkspace()
					.getRoot().getLocation().toOSString()+File.separatorChar+txtSelectProject.getText());
			fileDialog.setFilterExtensions(resourceFilterExt);
			if (strSelResource != "") { //$NON-NLS-1$
				fileDialog.setFileName(strSelResource);
			}
			if (fileDialog.open() != null) {
				String separator = ""; //$NON-NLS-1$
				int length = fileDialog.getFilterPath().trim().length();
				if (length > 0
						&& fileDialog.getFilterPath().charAt(length - 1) != File.separatorChar) {
					separator = File.separator;
				}
				strSelResource = new Path(fileDialog.getFilterPath() + separator
						+ fileDialog.getFileName()).toOSString();
				txtResourceFile.setText(strSelResource);
				txtSelectProject.setText(""); //$NON-NLS-1$
				updateDeployButton();
				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysResourceOnDevice, false);
			}
			txtResourceFile.setFocus();
		}

		public void widgetDefaultSelected(SelectionEvent event) {
		}
	}

	private void addBtnSelectProjectListeners(Button btnSelectProject) {
		btnSelectProject.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				javaProject = selectProject();
				if (javaProject!=null) {
					setResourceFields(javaProject);
				}
			}
			public void widgetDefaultSelected(SelectionEvent e) {	
			}
		});        
	}

	private IJavaProject selectProject() {
		IJavaProject[] projects;
		try {
			projects= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
		} 
		catch (JavaModelException e) {
			projects= new IJavaProject[0];
		}
		
		ILabelProvider labelProvider= new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
		ElementListSelectionDialog dialog= new ElementListSelectionDialog(getShell(), labelProvider);
		dialog.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_ProjectSelection); 
		dialog.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_ChooseTheProject); 
		dialog.setElements(projects);
		dialog.setInitialSelections(new Object[] { this.javaProject });
		if (dialog.open() == Window.OK) {			
			return (IJavaProject) dialog.getFirstResult();
		}			
		return null;		
	}

	private void setResourceFields(Object selectedResource) {
		IMtjProject mtjProject = null;
		
		if(selectedResource instanceof IJavaProject){	
			try {
				javaProject = (IJavaProject)selectedResource;
				mtjProject = MtjProject.getMtjProject(javaProject);
			} catch (MtjException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();				
			}
			updatefields(mtjProject);
        }
        else if(selectedResource instanceof IResource){
        	IResource resource = (IResource) selectedResource;
        	IProject container = resource.getProject();
        	javaProject = JavaCore.create(container);

        	if(javaProject != null){
    			try {
    				mtjProject = MtjProject.getMtjProject(javaProject);
    			} catch (MtjException e) {
    				// TODO Auto-generated catch block
    				e.printStackTrace();				
    			}
    			updatefields(mtjProject);
        	}
        	txtSelectProject.setText(container.getFullPath().toString());
        	txtResourceFile.setText(resource.getFullPath().toString());
		}
		else if(selectedResource instanceof IProject){
        	txtSelectProject.setText(((IProject)selectedResource).getFullPath().toString());
        	updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy, true);
        }
        else{
        	updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoProject, true);
		}
	}
	
	private void updatefields(IMtjProject mtjProject){
		
		if(mtjProject != null){
			midlet = null;
			updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysOnDevice, false);			
			try {
				midlet = (MidletDeployment)mtjProject.getDeployment();
			} catch (CoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}		        	
	        txtSelectProject.setText(mtjProject.getProject().getName());
			if(midlet != null){
				txtResourceFile.setText(midlet.getJad().getName());
				updateDeployButton();
			}
			else{
				txtResourceFile.setText(""); //$NON-NLS-1$
				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy, true);
				updateDeployButton();
			}
		}
		else{			
			updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
			txtSelectProject.setText(((IJavaProject)selectedResource).getPath().toString());
		}
        contentProvider.setJavaProject(this.javaProject);
	}
	

    
    
    private void addBtnDeployListeners(Button btnDeploy) {
    	
		btnDeploy.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				//ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
				//monitor = progressMonitorDialog.getProgressMonitor();
				//progressMonitorDialog.open();
				if(selectedResource instanceof IJavaProject){
					if(selectedResource != null){
				        IJavaProject javaProject = ((IJavaProject)selectedResource);
				        try {
				        	Deployment deployment = null;
							IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
							if(mtjProject != null){
								deployment = mtjProject.getDeployment();		
							}else{
								// TODO implement resource deployment
								dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
								return;
								//
								//deployment = new ResourceDeployment();
							}
							
							MtjExtension[] list = MtjServices.getInstance().getImplementations( ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);	              
		                    DeploymentProvider dplp = (DeploymentProvider) list[0];
		                    
		                    // TODO testing	                    
		                    //Device[] devices = dplp.getDevices();
		                    //
		                   Object[] checkedElements = deviceViewer.getCheckedElements();
		                   selectedDevices.clear();
		                   for(int i=0; i<checkedElements.length; i++){
		                	   Object current = checkedElements[i];
		                	   if(current instanceof Device){
		                		   selectedDevices.add((Device)current);		                
		                	   }
		                   }
		                   Device[] toDeploy = new Device[selectedDevices.size()];
		                   Object[] objectDevices = selectedDevices.toArray();
		                   for(int i=0; i<selectedDevices.size(); i++){
		                	   toDeploy[i] = (Device)objectDevices[i];
		                   }
		                    dplp.deploy(deployment, toDeploy, null, monitor);
						} catch (MtjException ex) {
							// TODO Auto-generated catch block
							ex.printStackTrace();
						} catch (CoreException cex) {
							// TODO Auto-generated catch block
							cex.printStackTrace();
						}
					}else{
						dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoResourceSelected, true);
					}
				}else if(selectedResource instanceof IResource){
					IResource resource = (IResource) selectedResource;
					//TODO to change the implementation later on
					if(!resource.getFileExtension().equalsIgnoreCase("jad")){ //$NON-NLS-1$
						updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyMidlets, true);					
					}else{
						
					}
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});        
    }

    private void addBtnRefreshListeners(Button btnRefresh) {
        btnRefresh.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				deviceViewer.refresh();
				updateDeployButton();
            }
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
        });     
    }


    private void addDeviceViewerListeners(final CheckboxTreeViewer deviceViewer) {
        deviceViewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                if(event.getSelection().isEmpty()) {
                    lblDescription.setText(""); //$NON-NLS-1$
                    return;
                }
                if(event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
                        Object domain = iterator.next();
                        String value = labelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", "); //$NON-NLS-1$
                    }
                    // remove the trailing comma space pair
                    if(toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    lblDescription.setText(toShow.toString());
                }
				updateDeployButton();
            }
            
        });

        deviceViewer.addCheckStateListener(new ICheckStateListener() {
            public void checkStateChanged(CheckStateChangedEvent event) {
            	Object selection = event.getElement();
            	if(selection instanceof DeploymentProvider){
            		if(event.getChecked()){
            			deviceViewer.expandToLevel(1);
            			deviceViewer.setSubtreeChecked(selection, true);            			
            		}else{
            			deviceViewer.setSubtreeChecked(selection, false);
            		}
            	}else if(selection instanceof Device){
            		Device checkedDevice = (Device)selection;
            		if(event.getChecked()){
            			deviceViewer.setChecked(selection, true);
            			selectedDevices.add(checkedDevice);
            		}else{
            			deviceViewer.setParentsGrayed(selection, false);
            			selectedDevices.remove(checkedDevice);
            		}
            	}
				updateDeployButton();
            }

        });
        deviceViewer.addTreeListener(new ITreeViewerListener() {
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                //updateTree();
            }
        });     
    }


    protected void createButtonsForButtonBar(Composite parent) {
    	// Add Deploy button
		((GridLayout) parent.getLayout()).numColumns++;     	
		btnDeploy = new Button(parent, SWT.NONE);
		initializeDialogUnits(btnDeploy);
		setButtonLayoutData(btnDeploy);
		updateDeployButton();
        btnDeploy.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Deploy); 
        addBtnDeployListeners(btnDeploy); 
    	
    	// Add Cancel button
		btnCancel = createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		btnCancel.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				dplmDialog.close();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
	}

	public boolean close() {
		return super.close();
	}

	protected void buttonPressed(int buttonId) {
		super.buttonPressed(buttonId);
	}

	/**
	 * Updates error messages in the banner area
	 */
	private void updateStatus(String message, boolean error) {
		if(error){
			setErrorMessage(message);
		}else{
			setErrorMessage(null);
			setMessage(message);
		}
	}
	
	private void updateDeployButton() {
		btnDeploy.setEnabled(true);
		if(midlet==null) {
			btnDeploy.setEnabled(false);
		}
		else if (deviceViewer.getSelection().isEmpty()) {
			btnDeploy.setEnabled(false);
		}
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployResource); 
		newShell.setImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage()); //$NON-NLS-1$
	}
	
	protected Object getSelectedResource(){
		Object res = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        
        if (selection != null){
        	if (selection instanceof IStructuredSelection){
        		IStructuredSelection structuredSelection = (IStructuredSelection) selection;
        
        		if (structuredSelection != null){
        			res = structuredSelection.getFirstElement();
        		}
        	}
        }
        return res;
	}
	
	protected void cancelPressed() {
		close();
	}
 
}
