/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * Build Management calls the appropriate build provider to build a project. 
 */
public interface BuildManagement extends MtjExtension {

	/**
	 * Call the appropriate build provider based on the Project structure.  The builder will
	 * perform the project build.
	 * 
	 * @param project
	 * @param projectNatureId
	 * @param buildType
	 * @param targetPlatform
	 * @param monitor
	 */
	public void build(IMtjProject project, String projectNatureId, BuildType buildType,
			RuntimePlatformDefinition targetPlatform,
			IProgressMonitor monitor) throws MtjException;

}
