/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
 *******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.exception.MtjException;

/**
 * Target environments are seen as DevicePlatforms by the MTJ environment.
 * The Device Platforms type can be an emulator platform or a real device platform.
 * A Device Platform should implement binary code, preverification and application launching.
 */
public interface DevicePlatformProvider extends MtjExtension {

	/**
	 * Method returns DevicePlatform objects.
	 * 
	 * @return
	 */
	public DevicePlatform[] getDevicePlatforms() throws MtjException;

	/**
	 * Verifies code in the source folder.
	 * 
	 * @param sourceFolder
	 * @param monitor
	 */
	public void verify(IFolder sourceFolder, IProgressMonitor monitor)
			throws MtjException;

	/**
	 * Method launches the application, that is in the deployment, to the target
	 * device. Launched application could be run inside the SWT composite that
	 * is given as parameter.
	 * 
	 * @param device
	 * @param deployment
	 * @param vmRunnerConfig
	 * @param launchConfig
	 * @param launch
	 * @param runMode
	 * @param monitor
	 * @throws MtjException
	 */
	public void launch(DevicePlatform dp, Device device, Deployment deployment,
			VMRunnerConfiguration vmRunnerConfig,
			ILaunchConfiguration launchConfig, ILaunch launch, String runMode,
			String projectNatureId,
			IProgressMonitor monitor) throws MtjException;
	
	/**
	 * Method returns installed DevicePlatform's root directory.
	 * 
	 * @param dp
	 * @return root directory or null.
	 * @throws MtjException
	 */
	public String getRootDirectory(DevicePlatform dp) throws MtjException;
	
	/**
	 * Method returns Device's status.
	 * 
	 * @param device
	 * @return
	 * @throws MtjException
	 */
	public DeviceStatus getStatus(Device device) throws MtjException;
}
