/*******************************************************************************
* Copyright  2005 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*******************************************************************************/

package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

public interface ProjectExtensionProvider {

	/**
	 * Return ProjectType that this extension is extending.
	 *
	 * @return
	 */
	public ProjectType getProjectType();
	
	/**
	 * Return Project's Deployment object. Returns null if the project does not have Deployment components.
	 * 
	 * @param project
	 * @throws MtjException
	 * @return Deployment object or null.
	 */
	public Deployment getDeployment(IMtjProject project) throws MtjException;
	
	/**
	 * Return Project's Deployment object that is targeted to the launchableApplication.
	 * 
	 * @param project
	 * @param launchableApplication
	 * @return
	 * @throws MtjException
	 */
	public Deployment getDeployment(IMtjProject project, String launchableApplication) throws MtjException;
	
	/**
	 * Returns deployment output folder.
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getDeploymentFolder(IProgressMonitor monitor) throws CoreException;
	
	/**
	 * Returns launchable classes output folder.
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getLaunchableClassesFolder(IProgressMonitor monitor) throws CoreException;

	/**
	 * Returns launchable libraries output folder.
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getLaunchableLibsFolder(IProgressMonitor monitor) throws CoreException;

	/**
	 * Return the DeploymentType  the ProjectExtensionProvider supports.
	 * 
	 * @return 
	 * @throws MtjException
	 */
	public DeploymentType getDeploymentType() throws MtjException;

	/**
	 * Returns object for searching classes that support the project's scope.
	 * 
	 * @param javaProject
	 * @return IJavaSearchScope
	 * @throws MtjException
	 */
	public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws MtjException;

	/**
	 * Returns the PreverificationPolicy that the project supports.
	 * 
	 * @param targetPlatform
	 * @return
	 */
	public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws MtjException;
	
	/**
	 * This can be used during project creation to set project specific behavior.
	 * 
	 * @param javaProject
	 * @throws MtjException
	 */
	public void initializeNewProject(IJavaProject javaProject, IProgressMonitor monitor) throws MtjException;
}
