/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.devices.DevicesFactory
 * @model kind="package"
 * @generated
 */
public interface DevicesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "devices";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/devices.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.devices";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DevicesPackage eINSTANCE = org.eclipse.mtj.api.devices.impl.DevicesPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl <em>Device Platform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DevicePlatformImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDevicePlatform()
	 * @generated
	 */
	int DEVICE_PLATFORM = 0;

	/**
	 * The feature id for the '<em><b>Devices</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__DEVICES = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__CONFIGURATION = 2;

	/**
	 * The feature id for the '<em><b>Runtime Platform Definitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__NAME = 4;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__VENDOR = 5;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__VERSION = 6;

	/**
	 * The feature id for the '<em><b>Debug Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__DEBUG_ENABLED = 7;

	/**
	 * The feature id for the '<em><b>Predeployment Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED = 8;

	/**
	 * The feature id for the '<em><b>Executable Target Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED = 9;

	/**
	 * The feature id for the '<em><b>Keep Alive Port Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED = 10;

	/**
	 * The feature id for the '<em><b>Preferences Dialog Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE = 11;

	/**
	 * The feature id for the '<em><b>Utilites Dialog Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE = 12;

	/**
	 * The feature id for the '<em><b>Device Platform Provider</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER = 13;

	/**
	 * The number of structural features of the the '<em>Device Platform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PLATFORM_FEATURE_COUNT = 14;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DeviceImpl <em>Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DeviceImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDevice()
	 * @generated
	 */
	int DEVICE = 1;

	/**
	 * The feature id for the '<em><b>Protection Domains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__PROTECTION_DOMAINS = 0;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__CONFIGURATION = 1;

	/**
	 * The feature id for the '<em><b>Communication Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__COMMUNICATION_PROTOCOL = 2;

	/**
	 * The feature id for the '<em><b>Device Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__DEVICE_DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>Runtime Platform Definitions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__RUNTIME_PLATFORM_DEFINITIONS = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__NAME = 5;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__VERSION = 6;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__VENDOR = 7;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__DESCRIPTION = 8;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__IDENTIFIER = 9;

	/**
	 * The number of structural features of the the '<em>Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.ConfigurationImpl <em>Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.ConfigurationImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getConfiguration()
	 * @generated
	 */
	int CONFIGURATION = 2;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__ITEMS = 0;

	/**
	 * The feature id for the '<em><b>Errors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__ERRORS = 1;

	/**
	 * The number of structural features of the the '<em>Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.ConfigurationItemImpl <em>Configuration Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.ConfigurationItemImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getConfigurationItem()
	 * @generated
	 */
	int CONFIGURATION_ITEM = 3;

	/**
	 * The feature id for the '<em><b>Valid Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM__VALID_VALUES = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM__NAME = 1;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM__LABEL = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM__DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM__VALUE = 4;

	/**
	 * The number of structural features of the the '<em>Configuration Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ITEM_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.ConfigurationErrorImpl <em>Configuration Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.ConfigurationErrorImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getConfigurationError()
	 * @generated
	 */
	int CONFIGURATION_ERROR = 4;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ERROR__ITEM = 0;

	/**
	 * The feature id for the '<em><b>Error Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ERROR__ERROR_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ERROR__DESCRIPTION = 2;

	/**
	 * The number of structural features of the the '<em>Configuration Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_ERROR_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.ProtectionDomainImpl <em>Protection Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.ProtectionDomainImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getProtectionDomain()
	 * @generated
	 */
	int PROTECTION_DOMAIN = 5;

	/**
	 * The feature id for the '<em><b>Permissions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTECTION_DOMAIN__PERMISSIONS = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTECTION_DOMAIN__NAME = 1;

	/**
	 * The number of structural features of the the '<em>Protection Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTECTION_DOMAIN_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.PermissionImpl <em>Permission</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.PermissionImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getPermission()
	 * @generated
	 */
	int PERMISSION = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERMISSION__NAME = 0;

	/**
	 * The number of structural features of the the '<em>Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERMISSION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DeviceDescriptionImpl <em>Device Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DeviceDescriptionImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDeviceDescription()
	 * @generated
	 */
	int DEVICE_DESCRIPTION = 7;

	/**
	 * The feature id for the '<em><b>Capabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_DESCRIPTION__CAPABILITIES = 0;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_DESCRIPTION__FEATURES = 1;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_DESCRIPTION__IDENTIFIER = 2;

	/**
	 * The number of structural features of the the '<em>Device Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_DESCRIPTION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DeviceCapabilityImpl <em>Device Capability</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DeviceCapabilityImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDeviceCapability()
	 * @generated
	 */
	int DEVICE_CAPABILITY = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CAPABILITY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CAPABILITY__VALUE = 1;

	/**
	 * The number of structural features of the the '<em>Device Capability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CAPABILITY_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DeviceFeatureImpl <em>Device Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DeviceFeatureImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDeviceFeature()
	 * @generated
	 */
	int DEVICE_FEATURE = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_FEATURE__NAME = 0;

	/**
	 * The number of structural features of the the '<em>Device Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_FEATURE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.DeviceGroupImpl <em>Device Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.DeviceGroupImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getDeviceGroup()
	 * @generated
	 */
	int DEVICE_GROUP = 10;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_GROUP__FEATURES = 0;

	/**
	 * The feature id for the '<em><b>Capabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_GROUP__CAPABILITIES = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_GROUP__NAME = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_GROUP__DESCRIPTION = 3;

	/**
	 * The number of structural features of the the '<em>Device Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_GROUP_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.devices.impl.ConfigurationValueImpl <em>Configuration Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.devices.impl.ConfigurationValueImpl
	 * @see org.eclipse.mtj.api.devices.impl.DevicesPackageImpl#getConfigurationValue()
	 * @generated
	 */
	int CONFIGURATION_VALUE = 11;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_VALUE__VALUE = 0;

	/**
	 * The number of structural features of the the '<em>Configuration Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_VALUE_FEATURE_COUNT = 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.DevicePlatform <em>Device Platform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Platform</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform
	 * @generated
	 */
	EClass getDevicePlatform();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DevicePlatform#getDevices <em>Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Devices</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getDevices()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EReference getDevicePlatform_Devices();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getType()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_Type();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.devices.DevicePlatform#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Configuration</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getConfiguration()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EReference getDevicePlatform_Configuration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DevicePlatform#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Runtime Platform Definitions</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getRuntimePlatformDefinitions()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EReference getDevicePlatform_RuntimePlatformDefinitions();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getName()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#getVendor <em>Vendor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vendor</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getVendor()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_Vendor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getVersion()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isDebugEnabled <em>Debug Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Debug Enabled</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isDebugEnabled()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_DebugEnabled();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isPredeploymentRequired <em>Predeployment Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Predeployment Required</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isPredeploymentRequired()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_PredeploymentRequired();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isExecutableTargetRequired <em>Executable Target Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Executable Target Required</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isExecutableTargetRequired()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_ExecutableTargetRequired();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isKeepAlivePortRequired <em>Keep Alive Port Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keep Alive Port Required</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isKeepAlivePortRequired()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_KeepAlivePortRequired();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isPreferencesDialogAvailable <em>Preferences Dialog Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Preferences Dialog Available</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isPreferencesDialogAvailable()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_PreferencesDialogAvailable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DevicePlatform#isUtilitesDialogAvailable <em>Utilites Dialog Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Utilites Dialog Available</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isUtilitesDialogAvailable()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EAttribute getDevicePlatform_UtilitesDialogAvailable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.mtj.api.devices.DevicePlatform#getDevicePlatformProvider <em>Device Platform Provider</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Device Platform Provider</em>'.
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getDevicePlatformProvider()
	 * @see #getDevicePlatform()
	 * @generated
	 */
	EReference getDevicePlatform_DevicePlatformProvider();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.Device <em>Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device</em>'.
	 * @see org.eclipse.mtj.api.devices.Device
	 * @generated
	 */
	EClass getDevice();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.Device#getProtectionDomains <em>Protection Domains</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Protection Domains</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getProtectionDomains()
	 * @see #getDevice()
	 * @generated
	 */
	EReference getDevice_ProtectionDomains();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.devices.Device#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Configuration</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getConfiguration()
	 * @see #getDevice()
	 * @generated
	 */
	EReference getDevice_Configuration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getCommunicationProtocol <em>Communication Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Communication Protocol</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getCommunicationProtocol()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_CommunicationProtocol();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.devices.Device#getDeviceDescription <em>Device Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Device Description</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getDeviceDescription()
	 * @see #getDevice()
	 * @generated
	 */
	EReference getDevice_DeviceDescription();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.mtj.api.devices.Device#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Runtime Platform Definitions</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getRuntimePlatformDefinitions()
	 * @see #getDevice()
	 * @generated
	 */
	EReference getDevice_RuntimePlatformDefinitions();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getName()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getVersion()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getVendor <em>Vendor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vendor</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getVendor()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Vendor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getDescription()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Device#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see org.eclipse.mtj.api.devices.Device#getIdentifier()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Identifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.Configuration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration</em>'.
	 * @see org.eclipse.mtj.api.devices.Configuration
	 * @generated
	 */
	EClass getConfiguration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.Configuration#getItems <em>Items</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Items</em>'.
	 * @see org.eclipse.mtj.api.devices.Configuration#getItems()
	 * @see #getConfiguration()
	 * @generated
	 */
	EReference getConfiguration_Items();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.Configuration#getErrors <em>Errors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Errors</em>'.
	 * @see org.eclipse.mtj.api.devices.Configuration#getErrors()
	 * @see #getConfiguration()
	 * @generated
	 */
	EReference getConfiguration_Errors();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.ConfigurationItem <em>Configuration Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration Item</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem
	 * @generated
	 */
	EClass getConfigurationItem();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.ConfigurationItem#getValidValues <em>Valid Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Valid Values</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem#getValidValues()
	 * @see #getConfigurationItem()
	 * @generated
	 */
	EReference getConfigurationItem_ValidValues();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationItem#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem#getName()
	 * @see #getConfigurationItem()
	 * @generated
	 */
	EAttribute getConfigurationItem_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationItem#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem#getLabel()
	 * @see #getConfigurationItem()
	 * @generated
	 */
	EAttribute getConfigurationItem_Label();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationItem#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem#getDescription()
	 * @see #getConfigurationItem()
	 * @generated
	 */
	EAttribute getConfigurationItem_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationItem#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationItem#getValue()
	 * @see #getConfigurationItem()
	 * @generated
	 */
	EAttribute getConfigurationItem_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.ConfigurationError <em>Configuration Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration Error</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationError
	 * @generated
	 */
	EClass getConfigurationError();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.mtj.api.devices.ConfigurationError#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Item</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationError#getItem()
	 * @see #getConfigurationError()
	 * @generated
	 */
	EReference getConfigurationError_Item();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationError#getErrorType <em>Error Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Error Type</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationError#getErrorType()
	 * @see #getConfigurationError()
	 * @generated
	 */
	EAttribute getConfigurationError_ErrorType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationError#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationError#getDescription()
	 * @see #getConfigurationError()
	 * @generated
	 */
	EAttribute getConfigurationError_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.ProtectionDomain <em>Protection Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Protection Domain</em>'.
	 * @see org.eclipse.mtj.api.devices.ProtectionDomain
	 * @generated
	 */
	EClass getProtectionDomain();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.ProtectionDomain#getPermissions <em>Permissions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Permissions</em>'.
	 * @see org.eclipse.mtj.api.devices.ProtectionDomain#getPermissions()
	 * @see #getProtectionDomain()
	 * @generated
	 */
	EReference getProtectionDomain_Permissions();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ProtectionDomain#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.ProtectionDomain#getName()
	 * @see #getProtectionDomain()
	 * @generated
	 */
	EAttribute getProtectionDomain_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.Permission <em>Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Permission</em>'.
	 * @see org.eclipse.mtj.api.devices.Permission
	 * @generated
	 */
	EClass getPermission();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.Permission#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.Permission#getName()
	 * @see #getPermission()
	 * @generated
	 */
	EAttribute getPermission_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.DeviceDescription <em>Device Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Description</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceDescription
	 * @generated
	 */
	EClass getDeviceDescription();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DeviceDescription#getCapabilities <em>Capabilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Capabilities</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceDescription#getCapabilities()
	 * @see #getDeviceDescription()
	 * @generated
	 */
	EReference getDeviceDescription_Capabilities();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DeviceDescription#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceDescription#getFeatures()
	 * @see #getDeviceDescription()
	 * @generated
	 */
	EReference getDeviceDescription_Features();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceDescription#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceDescription#getIdentifier()
	 * @see #getDeviceDescription()
	 * @generated
	 */
	EAttribute getDeviceDescription_Identifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.DeviceCapability <em>Device Capability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Capability</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceCapability
	 * @generated
	 */
	EClass getDeviceCapability();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceCapability#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceCapability#getName()
	 * @see #getDeviceCapability()
	 * @generated
	 */
	EAttribute getDeviceCapability_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceCapability#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceCapability#getValue()
	 * @see #getDeviceCapability()
	 * @generated
	 */
	EAttribute getDeviceCapability_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.DeviceFeature <em>Device Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Feature</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceFeature
	 * @generated
	 */
	EClass getDeviceFeature();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceFeature#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceFeature#getName()
	 * @see #getDeviceFeature()
	 * @generated
	 */
	EAttribute getDeviceFeature_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.DeviceGroup <em>Device Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Group</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceGroup
	 * @generated
	 */
	EClass getDeviceGroup();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DeviceGroup#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceGroup#getFeatures()
	 * @see #getDeviceGroup()
	 * @generated
	 */
	EReference getDeviceGroup_Features();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.devices.DeviceGroup#getCapabilities <em>Capabilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Capabilities</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceGroup#getCapabilities()
	 * @see #getDeviceGroup()
	 * @generated
	 */
	EReference getDeviceGroup_Capabilities();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceGroup#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceGroup#getName()
	 * @see #getDeviceGroup()
	 * @generated
	 */
	EAttribute getDeviceGroup_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.DeviceGroup#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.devices.DeviceGroup#getDescription()
	 * @see #getDeviceGroup()
	 * @generated
	 */
	EAttribute getDeviceGroup_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.devices.ConfigurationValue <em>Configuration Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration Value</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationValue
	 * @generated
	 */
	EClass getConfigurationValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.devices.ConfigurationValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.mtj.api.devices.ConfigurationValue#getValue()
	 * @see #getConfigurationValue()
	 * @generated
	 */
	EAttribute getConfigurationValue_Value();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DevicesFactory getDevicesFactory();

} //DevicesPackage
