/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Capability</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getCapability()
 * @model
 * @generated
 */
public final class Capability extends AbstractEnumerator {
	/**
	 * The '<em><b>BITS PER PIXEL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BITS PER PIXEL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BITS_PER_PIXEL_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BITS_PER_PIXEL = 0;

	/**
	 * The '<em><b>SCREEN SIZE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SCREEN SIZE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SCREEN_SIZE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCREEN_SIZE = 1;

	/**
	 * The '<em><b>CANVAS SIZE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CANVAS SIZE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CANVAS_SIZE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CANVAS_SIZE = 2;

	/**
	 * The '<em><b>CAMERA RESOLUTION</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CAMERA RESOLUTION</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CAMERA_RESOLUTION_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CAMERA_RESOLUTION = 3;

	/**
	 * The '<em><b>DEVICE PROFILE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE PROFILE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_PROFILE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_PROFILE = 4;

	/**
	 * The '<em><b>DEVICE CONFIGURATION</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE CONFIGURATION</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_CONFIGURATION_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_CONFIGURATION = 5;

	/**
	 * The '<em><b>SERVICE API</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SERVICE API</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SERVICE_API_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SERVICE_API = 6;

	/**
	 * The '<em><b>JAVA PROTOCOL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA PROTOCOL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_PROTOCOL_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_PROTOCOL = 7;

	/**
	 * The '<em><b>HEAP SIZE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HEAP SIZE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HEAP_SIZE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HEAP_SIZE = 8;

	/**
	 * The '<em><b>MAX JAR SIZE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MAX JAR SIZE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MAX_JAR_SIZE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MAX_JAR_SIZE = 9;

	/**
	 * The '<em><b>OS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OS_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OS = 10;

	/**
	 * The '<em><b>VIDEO FORMAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>VIDEO FORMAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VIDEO_FORMAT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VIDEO_FORMAT = 11;

	/**
	 * The '<em><b>SOUND FORMAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SOUND FORMAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SOUND_FORMAT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SOUND_FORMAT = 12;

	/**
	 * The '<em><b>BITS PER PIXEL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BITS_PER_PIXEL
	 * @generated
	 * @ordered
	 */
	public static final Capability BITS_PER_PIXEL_LITERAL = new Capability(BITS_PER_PIXEL, "BITS_PER_PIXEL");

	/**
	 * The '<em><b>SCREEN SIZE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCREEN_SIZE
	 * @generated
	 * @ordered
	 */
	public static final Capability SCREEN_SIZE_LITERAL = new Capability(SCREEN_SIZE, "SCREEN_SIZE");

	/**
	 * The '<em><b>CANVAS SIZE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CANVAS_SIZE
	 * @generated
	 * @ordered
	 */
	public static final Capability CANVAS_SIZE_LITERAL = new Capability(CANVAS_SIZE, "CANVAS_SIZE");

	/**
	 * The '<em><b>CAMERA RESOLUTION</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CAMERA_RESOLUTION
	 * @generated
	 * @ordered
	 */
	public static final Capability CAMERA_RESOLUTION_LITERAL = new Capability(CAMERA_RESOLUTION, "CAMERA_RESOLUTION");

	/**
	 * The '<em><b>DEVICE PROFILE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_PROFILE
	 * @generated
	 * @ordered
	 */
	public static final Capability DEVICE_PROFILE_LITERAL = new Capability(DEVICE_PROFILE, "DEVICE_PROFILE");

	/**
	 * The '<em><b>DEVICE CONFIGURATION</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_CONFIGURATION
	 * @generated
	 * @ordered
	 */
	public static final Capability DEVICE_CONFIGURATION_LITERAL = new Capability(DEVICE_CONFIGURATION, "DEVICE_CONFIGURATION");

	/**
	 * The '<em><b>SERVICE API</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SERVICE_API
	 * @generated
	 * @ordered
	 */
	public static final Capability SERVICE_API_LITERAL = new Capability(SERVICE_API, "SERVICE_API");

	/**
	 * The '<em><b>JAVA PROTOCOL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_PROTOCOL
	 * @generated
	 * @ordered
	 */
	public static final Capability JAVA_PROTOCOL_LITERAL = new Capability(JAVA_PROTOCOL, "JAVA_PROTOCOL");

	/**
	 * The '<em><b>HEAP SIZE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HEAP_SIZE
	 * @generated
	 * @ordered
	 */
	public static final Capability HEAP_SIZE_LITERAL = new Capability(HEAP_SIZE, "HEAP_SIZE");

	/**
	 * The '<em><b>MAX JAR SIZE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MAX_JAR_SIZE
	 * @generated
	 * @ordered
	 */
	public static final Capability MAX_JAR_SIZE_LITERAL = new Capability(MAX_JAR_SIZE, "MAX_JAR_SIZE");

	/**
	 * The '<em><b>OS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OS
	 * @generated
	 * @ordered
	 */
	public static final Capability OS_LITERAL = new Capability(OS, "OS");

	/**
	 * The '<em><b>VIDEO FORMAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VIDEO_FORMAT
	 * @generated
	 * @ordered
	 */
	public static final Capability VIDEO_FORMAT_LITERAL = new Capability(VIDEO_FORMAT, "VIDEO_FORMAT");

	/**
	 * The '<em><b>SOUND FORMAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SOUND_FORMAT
	 * @generated
	 * @ordered
	 */
	public static final Capability SOUND_FORMAT_LITERAL = new Capability(SOUND_FORMAT, "SOUND_FORMAT");

	/**
	 * An array of all the '<em><b>Capability</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final Capability[] VALUES_ARRAY =
		new Capability[] {
			BITS_PER_PIXEL_LITERAL,
			SCREEN_SIZE_LITERAL,
			CANVAS_SIZE_LITERAL,
			CAMERA_RESOLUTION_LITERAL,
			DEVICE_PROFILE_LITERAL,
			DEVICE_CONFIGURATION_LITERAL,
			SERVICE_API_LITERAL,
			JAVA_PROTOCOL_LITERAL,
			HEAP_SIZE_LITERAL,
			MAX_JAR_SIZE_LITERAL,
			OS_LITERAL,
			VIDEO_FORMAT_LITERAL,
			SOUND_FORMAT_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Capability</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Capability</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Capability get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Capability result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Capability</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Capability get(int value) {
		switch (value) {
			case BITS_PER_PIXEL: return BITS_PER_PIXEL_LITERAL;
			case SCREEN_SIZE: return SCREEN_SIZE_LITERAL;
			case CANVAS_SIZE: return CANVAS_SIZE_LITERAL;
			case CAMERA_RESOLUTION: return CAMERA_RESOLUTION_LITERAL;
			case DEVICE_PROFILE: return DEVICE_PROFILE_LITERAL;
			case DEVICE_CONFIGURATION: return DEVICE_CONFIGURATION_LITERAL;
			case SERVICE_API: return SERVICE_API_LITERAL;
			case JAVA_PROTOCOL: return JAVA_PROTOCOL_LITERAL;
			case HEAP_SIZE: return HEAP_SIZE_LITERAL;
			case MAX_JAR_SIZE: return MAX_JAR_SIZE_LITERAL;
			case OS: return OS_LITERAL;
			case VIDEO_FORMAT: return VIDEO_FORMAT_LITERAL;
			case SOUND_FORMAT: return SOUND_FORMAT_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private Capability(int value, String name) {
		super(value, name);
	}

} //Capability
