/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Device Status</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getDeviceStatus()
 * @model
 * @generated
 */
public final class DeviceStatus extends AbstractEnumerator {
	/**
	 * The '<em><b>DEVICE STATUS OK</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE STATUS OK</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_OK_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_STATUS_OK = 0;

	/**
	 * The '<em><b>DEVICE STATUS ERROR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE STATUS ERROR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_ERROR_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_STATUS_ERROR = 1;

	/**
	 * The '<em><b>DEVICE STATUS NOT CONNECTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE STATUS NOT CONNECTED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_NOT_CONNECTED_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_STATUS_NOT_CONNECTED = 2;

	/**
	 * The '<em><b>DEVICE STATUS UNKNOWN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE STATUS UNKNOWN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_UNKNOWN_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_STATUS_UNKNOWN = 3;

	/**
	 * The '<em><b>DEVICE STATUS OK</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_OK
	 * @generated
	 * @ordered
	 */
	public static final DeviceStatus DEVICE_STATUS_OK_LITERAL = new DeviceStatus(DEVICE_STATUS_OK, "DEVICE_STATUS_OK");

	/**
	 * The '<em><b>DEVICE STATUS ERROR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_ERROR
	 * @generated
	 * @ordered
	 */
	public static final DeviceStatus DEVICE_STATUS_ERROR_LITERAL = new DeviceStatus(DEVICE_STATUS_ERROR, "DEVICE_STATUS_ERROR");

	/**
	 * The '<em><b>DEVICE STATUS NOT CONNECTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_NOT_CONNECTED
	 * @generated
	 * @ordered
	 */
	public static final DeviceStatus DEVICE_STATUS_NOT_CONNECTED_LITERAL = new DeviceStatus(DEVICE_STATUS_NOT_CONNECTED, "DEVICE_STATUS_NOT_CONNECTED");

	/**
	 * The '<em><b>DEVICE STATUS UNKNOWN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_STATUS_UNKNOWN
	 * @generated
	 * @ordered
	 */
	public static final DeviceStatus DEVICE_STATUS_UNKNOWN_LITERAL = new DeviceStatus(DEVICE_STATUS_UNKNOWN, "DEVICE_STATUS_UNKNOWN");

	/**
	 * An array of all the '<em><b>Device Status</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final DeviceStatus[] VALUES_ARRAY =
		new DeviceStatus[] {
			DEVICE_STATUS_OK_LITERAL,
			DEVICE_STATUS_ERROR_LITERAL,
			DEVICE_STATUS_NOT_CONNECTED_LITERAL,
			DEVICE_STATUS_UNKNOWN_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Device Status</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Device Status</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeviceStatus get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DeviceStatus result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Device Status</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeviceStatus get(int value) {
		switch (value) {
			case DEVICE_STATUS_OK: return DEVICE_STATUS_OK_LITERAL;
			case DEVICE_STATUS_ERROR: return DEVICE_STATUS_ERROR_LITERAL;
			case DEVICE_STATUS_NOT_CONNECTED: return DEVICE_STATUS_NOT_CONNECTED_LITERAL;
			case DEVICE_STATUS_UNKNOWN: return DEVICE_STATUS_UNKNOWN_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private DeviceStatus(int value, String name) {
		super(value, name);
	}

} //DeviceStatus
