/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mtj.api.project.ObfuscationDetail;
import org.eclipse.mtj.api.project.ProjectPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Obfuscation Detail</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ObfuscationDetailImpl#getLevel <em>Level</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ObfuscationDetailImpl#getAdditionalSettings <em>Additional Settings</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ObfuscationDetailImpl extends EObjectImpl implements ObfuscationDetail {
	/**
	 * The default value of the '{@link #getLevel() <em>Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLevel() <em>Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLevel()
	 * @generated
	 * @ordered
	 */
	protected int level = LEVEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getAdditionalSettings() <em>Additional Settings</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAdditionalSettings()
	 * @generated
	 * @ordered
	 */
	protected static final String ADDITIONAL_SETTINGS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAdditionalSettings() <em>Additional Settings</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAdditionalSettings()
	 * @generated
	 * @ordered
	 */
	protected String additionalSettings = ADDITIONAL_SETTINGS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ObfuscationDetailImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.eINSTANCE.getObfuscationDetail();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLevel() {
		return level;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLevel(int newLevel) {
		int oldLevel = level;
		level = newLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.OBFUSCATION_DETAIL__LEVEL, oldLevel, level));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAdditionalSettings() {
		return additionalSettings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAdditionalSettings(String newAdditionalSettings) {
		String oldAdditionalSettings = additionalSettings;
		additionalSettings = newAdditionalSettings;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS, oldAdditionalSettings, additionalSettings));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.OBFUSCATION_DETAIL__LEVEL:
				return new Integer(getLevel());
			case ProjectPackage.OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS:
				return getAdditionalSettings();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.OBFUSCATION_DETAIL__LEVEL:
				setLevel(((Integer)newValue).intValue());
				return;
			case ProjectPackage.OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS:
				setAdditionalSettings((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.OBFUSCATION_DETAIL__LEVEL:
				setLevel(LEVEL_EDEFAULT);
				return;
			case ProjectPackage.OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS:
				setAdditionalSettings(ADDITIONAL_SETTINGS_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.OBFUSCATION_DETAIL__LEVEL:
				return level != LEVEL_EDEFAULT;
			case ProjectPackage.OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS:
				return ADDITIONAL_SETTINGS_EDEFAULT == null ? additionalSettings != null : !ADDITIONAL_SETTINGS_EDEFAULT.equals(additionalSettings);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (level: ");
		result.append(level);
		result.append(", additionalSettings: ");
		result.append(additionalSettings);
		result.append(')');
		return result.toString();
	}

} //ObfuscationDetailImpl
