/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Runtime Platform Definition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices <em>Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceProfiles <em>Device Profiles</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getServiceApis <em>Service Apis</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceConfigurations <em>Device Configurations</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition()
 * @model
 * @generated
 */
public interface RuntimePlatformDefinition extends EObject {
	/**
	 * Returns the value of the '<em><b>Devices</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.devices.Device}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.mtj.api.devices.Device#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Devices</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Devices</em>' reference list.
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition_Devices()
	 * @see org.eclipse.mtj.api.devices.Device#getRuntimePlatformDefinitions
	 * @model type="org.eclipse.mtj.api.devices.Device" opposite="runtimePlatformDefinitions" required="true"
	 * @generated
	 */
	EList getDevices();

	/**
	 * Returns the value of the '<em><b>Device Profiles</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.DeviceProfile}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Profiles</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Profiles</em>' containment reference list.
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition_DeviceProfiles()
	 * @model type="org.eclipse.mtj.api.runtimes.DeviceProfile" containment="true" required="true"
	 * @generated
	 */
	EList getDeviceProfiles();

	/**
	 * Returns the value of the '<em><b>Service Apis</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.ServiceApi}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Service Apis</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Service Apis</em>' containment reference list.
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition_ServiceApis()
	 * @model type="org.eclipse.mtj.api.runtimes.ServiceApi" containment="true" required="true"
	 * @generated
	 */
	EList getServiceApis();

	/**
	 * Returns the value of the '<em><b>Device Configurations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.DeviceConfiguration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Configurations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Configurations</em>' containment reference list.
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition_DeviceConfigurations()
	 * @model type="org.eclipse.mtj.api.runtimes.DeviceConfiguration" containment="true" required="true"
	 * @generated
	 */
	EList getDeviceConfigurations();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getRuntimePlatformDefinition_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

} // RuntimePlatformDefinition
