/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.mtj.api.deployment.DeploymentPackage;

import org.eclipse.mtj.api.deployment.impl.DeploymentPackageImpl;

import org.eclipse.mtj.api.devices.DevicesPackage;

import org.eclipse.mtj.api.devices.impl.DevicesPackageImpl;

import org.eclipse.mtj.api.enumerations.EnumerationsPackage;

import org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl;

import org.eclipse.mtj.api.extension.ExtensionPackage;

import org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl;

import org.eclipse.mtj.api.preprocessing.PreprocessingPackage;

import org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl;

import org.eclipse.mtj.api.project.ProjectPackage;

import org.eclipse.mtj.api.project.impl.ProjectPackageImpl;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.JvmImplementation;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;
import org.eclipse.mtj.api.runtimes.ServiceApi;

import org.eclipse.mtj.api.signings.SigningsPackage;

import org.eclipse.mtj.api.signings.impl.SigningsPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RuntimesPackageImpl extends EPackageImpl implements RuntimesPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass runtimePlatformDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass deviceProfileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceApiEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass deviceConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass implementationRefEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass jvmImplementationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass runtimePlatformEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private RuntimesPackageImpl() {
		super(eNS_URI, RuntimesFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static RuntimesPackage init() {
		if (isInited) return (RuntimesPackage)EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI);

		// Obtain or create and register package
		RuntimesPackageImpl theRuntimesPackage = (RuntimesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof RuntimesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new RuntimesPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		DevicesPackageImpl theDevicesPackage = (DevicesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) instanceof DevicesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) : DevicesPackage.eINSTANCE);
		ExtensionPackageImpl theExtensionPackage = (ExtensionPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) instanceof ExtensionPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) : ExtensionPackage.eINSTANCE);
		ProjectPackageImpl theProjectPackage = (ProjectPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI) instanceof ProjectPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI) : ProjectPackage.eINSTANCE);
		EnumerationsPackageImpl theEnumerationsPackage = (EnumerationsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI) instanceof EnumerationsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI) : EnumerationsPackage.eINSTANCE);
		PreprocessingPackageImpl thePreprocessingPackage = (PreprocessingPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) instanceof PreprocessingPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) : PreprocessingPackage.eINSTANCE);
		DeploymentPackageImpl theDeploymentPackage = (DeploymentPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) instanceof DeploymentPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) : DeploymentPackage.eINSTANCE);
		SigningsPackageImpl theSigningsPackage = (SigningsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) instanceof SigningsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) : SigningsPackage.eINSTANCE);

		// Create package meta-data objects
		theRuntimesPackage.createPackageContents();
		theDevicesPackage.createPackageContents();
		theExtensionPackage.createPackageContents();
		theProjectPackage.createPackageContents();
		theEnumerationsPackage.createPackageContents();
		thePreprocessingPackage.createPackageContents();
		theDeploymentPackage.createPackageContents();
		theSigningsPackage.createPackageContents();

		// Initialize created meta-data
		theRuntimesPackage.initializePackageContents();
		theDevicesPackage.initializePackageContents();
		theExtensionPackage.initializePackageContents();
		theProjectPackage.initializePackageContents();
		theEnumerationsPackage.initializePackageContents();
		thePreprocessingPackage.initializePackageContents();
		theDeploymentPackage.initializePackageContents();
		theSigningsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theRuntimesPackage.freeze();

		return theRuntimesPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRuntimePlatformDefinition() {
		return runtimePlatformDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRuntimePlatformDefinition_Devices() {
		return (EReference)runtimePlatformDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRuntimePlatformDefinition_DeviceProfiles() {
		return (EReference)runtimePlatformDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRuntimePlatformDefinition_ServiceApis() {
		return (EReference)runtimePlatformDefinitionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRuntimePlatformDefinition_DeviceConfigurations() {
		return (EReference)runtimePlatformDefinitionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRuntimePlatformDefinition_Name() {
		return (EAttribute)runtimePlatformDefinitionEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDeviceProfile() {
		return deviceProfileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDeviceProfile_ServiceApis() {
		return (EReference)deviceProfileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDeviceProfile_Name() {
		return (EAttribute)deviceProfileEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDeviceProfile_Version() {
		return (EAttribute)deviceProfileEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceApi() {
		return serviceApiEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceApi_Implementation() {
		return (EReference)serviceApiEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceApi_Name() {
		return (EAttribute)serviceApiEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceApi_Version() {
		return (EAttribute)serviceApiEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServiceApi_Description() {
		return (EAttribute)serviceApiEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDeviceConfiguration() {
		return deviceConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDeviceConfiguration_Implementation() {
		return (EReference)deviceConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDeviceConfiguration_JvmRef() {
		return (EReference)deviceConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDeviceConfiguration_Name() {
		return (EAttribute)deviceConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDeviceConfiguration_Version() {
		return (EAttribute)deviceConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getImplementationRef() {
		return implementationRefEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getImplementationRef_FileRef() {
		return (EAttribute)implementationRefEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getImplementationRef_SourceRef() {
		return (EAttribute)implementationRefEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getImplementationRef_JavadocRef() {
		return (EAttribute)implementationRefEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getJvmImplementation() {
		return jvmImplementationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJvmImplementation_Name() {
		return (EAttribute)jvmImplementationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJvmImplementation_Version() {
		return (EAttribute)jvmImplementationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJvmImplementation_Vendor() {
		return (EAttribute)jvmImplementationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJvmImplementation_FileRef() {
		return (EAttribute)jvmImplementationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRuntimePlatform() {
		return runtimePlatformEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRuntimePlatform_TargetDevices() {
		return (EReference)runtimePlatformEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRuntimePlatform_Name() {
		return (EAttribute)runtimePlatformEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRuntimePlatform_Description() {
		return (EAttribute)runtimePlatformEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimesFactory getRuntimesFactory() {
		return (RuntimesFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		runtimePlatformDefinitionEClass = createEClass(RUNTIME_PLATFORM_DEFINITION);
		createEReference(runtimePlatformDefinitionEClass, RUNTIME_PLATFORM_DEFINITION__DEVICES);
		createEReference(runtimePlatformDefinitionEClass, RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES);
		createEReference(runtimePlatformDefinitionEClass, RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS);
		createEReference(runtimePlatformDefinitionEClass, RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS);
		createEAttribute(runtimePlatformDefinitionEClass, RUNTIME_PLATFORM_DEFINITION__NAME);

		deviceProfileEClass = createEClass(DEVICE_PROFILE);
		createEReference(deviceProfileEClass, DEVICE_PROFILE__SERVICE_APIS);
		createEAttribute(deviceProfileEClass, DEVICE_PROFILE__NAME);
		createEAttribute(deviceProfileEClass, DEVICE_PROFILE__VERSION);

		serviceApiEClass = createEClass(SERVICE_API);
		createEReference(serviceApiEClass, SERVICE_API__IMPLEMENTATION);
		createEAttribute(serviceApiEClass, SERVICE_API__NAME);
		createEAttribute(serviceApiEClass, SERVICE_API__VERSION);
		createEAttribute(serviceApiEClass, SERVICE_API__DESCRIPTION);

		deviceConfigurationEClass = createEClass(DEVICE_CONFIGURATION);
		createEReference(deviceConfigurationEClass, DEVICE_CONFIGURATION__IMPLEMENTATION);
		createEReference(deviceConfigurationEClass, DEVICE_CONFIGURATION__JVM_REF);
		createEAttribute(deviceConfigurationEClass, DEVICE_CONFIGURATION__NAME);
		createEAttribute(deviceConfigurationEClass, DEVICE_CONFIGURATION__VERSION);

		implementationRefEClass = createEClass(IMPLEMENTATION_REF);
		createEAttribute(implementationRefEClass, IMPLEMENTATION_REF__FILE_REF);
		createEAttribute(implementationRefEClass, IMPLEMENTATION_REF__SOURCE_REF);
		createEAttribute(implementationRefEClass, IMPLEMENTATION_REF__JAVADOC_REF);

		jvmImplementationEClass = createEClass(JVM_IMPLEMENTATION);
		createEAttribute(jvmImplementationEClass, JVM_IMPLEMENTATION__NAME);
		createEAttribute(jvmImplementationEClass, JVM_IMPLEMENTATION__VERSION);
		createEAttribute(jvmImplementationEClass, JVM_IMPLEMENTATION__VENDOR);
		createEAttribute(jvmImplementationEClass, JVM_IMPLEMENTATION__FILE_REF);

		runtimePlatformEClass = createEClass(RUNTIME_PLATFORM);
		createEReference(runtimePlatformEClass, RUNTIME_PLATFORM__TARGET_DEVICES);
		createEAttribute(runtimePlatformEClass, RUNTIME_PLATFORM__NAME);
		createEAttribute(runtimePlatformEClass, RUNTIME_PLATFORM__DESCRIPTION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		DevicesPackage theDevicesPackage = (DevicesPackage)EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI);
		ProjectPackage theProjectPackage = (ProjectPackage)EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(runtimePlatformDefinitionEClass, RuntimePlatformDefinition.class, "RuntimePlatformDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRuntimePlatformDefinition_Devices(), theDevicesPackage.getDevice(), theDevicesPackage.getDevice_RuntimePlatformDefinitions(), "devices", null, 1, -1, RuntimePlatformDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRuntimePlatformDefinition_DeviceProfiles(), this.getDeviceProfile(), null, "deviceProfiles", null, 1, -1, RuntimePlatformDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRuntimePlatformDefinition_ServiceApis(), this.getServiceApi(), null, "serviceApis", null, 1, -1, RuntimePlatformDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRuntimePlatformDefinition_DeviceConfigurations(), this.getDeviceConfiguration(), null, "deviceConfigurations", null, 1, -1, RuntimePlatformDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRuntimePlatformDefinition_Name(), ecorePackage.getEString(), "name", null, 0, 1, RuntimePlatformDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(deviceProfileEClass, DeviceProfile.class, "DeviceProfile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDeviceProfile_ServiceApis(), this.getServiceApi(), null, "serviceApis", null, 1, -1, DeviceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDeviceProfile_Name(), ecorePackage.getEString(), "name", null, 0, 1, DeviceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDeviceProfile_Version(), ecorePackage.getEString(), "version", null, 0, 1, DeviceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(serviceApiEClass, ServiceApi.class, "ServiceApi", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceApi_Implementation(), this.getImplementationRef(), null, "implementation", null, 0, 1, ServiceApi.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServiceApi_Name(), ecorePackage.getEString(), "name", null, 0, 1, ServiceApi.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServiceApi_Version(), ecorePackage.getEString(), "version", null, 0, 1, ServiceApi.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServiceApi_Description(), ecorePackage.getEString(), "description", null, 0, 1, ServiceApi.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(deviceConfigurationEClass, DeviceConfiguration.class, "DeviceConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDeviceConfiguration_Implementation(), this.getImplementationRef(), null, "implementation", null, 1, 1, DeviceConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDeviceConfiguration_JvmRef(), this.getJvmImplementation(), null, "jvmRef", null, 0, 1, DeviceConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDeviceConfiguration_Name(), ecorePackage.getEString(), "name", null, 0, 1, DeviceConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDeviceConfiguration_Version(), ecorePackage.getEString(), "version", null, 0, 1, DeviceConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(implementationRefEClass, ImplementationRef.class, "ImplementationRef", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getImplementationRef_FileRef(), ecorePackage.getEString(), "fileRef", null, 0, 1, ImplementationRef.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getImplementationRef_SourceRef(), ecorePackage.getEString(), "sourceRef", null, 0, 1, ImplementationRef.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getImplementationRef_JavadocRef(), ecorePackage.getEString(), "javadocRef", null, 0, 1, ImplementationRef.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(jvmImplementationEClass, JvmImplementation.class, "JvmImplementation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getJvmImplementation_Name(), ecorePackage.getEString(), "name", null, 0, 1, JvmImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJvmImplementation_Version(), ecorePackage.getEString(), "version", null, 0, 1, JvmImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJvmImplementation_Vendor(), ecorePackage.getEString(), "vendor", null, 0, 1, JvmImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJvmImplementation_FileRef(), ecorePackage.getEString(), "fileRef", null, 0, 1, JvmImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(runtimePlatformEClass, RuntimePlatform.class, "RuntimePlatform", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRuntimePlatform_TargetDevices(), theProjectPackage.getTargetDevice(), null, "targetDevices", null, 1, -1, RuntimePlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRuntimePlatform_Name(), ecorePackage.getEString(), "name", null, 0, 1, RuntimePlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRuntimePlatform_Description(), ecorePackage.getEString(), "description", null, 0, 1, RuntimePlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //RuntimesPackageImpl
