/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.library.LibrarySpecification;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.core.model.preverifier.impl.StandardPreverifier;
import org.eclipse.mtj.ui.internal.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PreverificationPreferencePage
extends PreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String[] BUTTON_TEXTS = new String[]{"Use JAD file setting", "Use project device configuration", "Use specific configuration"};
    private static final String[] CONFIG_FILE_LOCATIONS = new String[]{"jad", "platform", "specified"};
    private boolean embeddedInProperties;
    private Button[] preverificationRadios;
    private LibrarySpecification[] configSpecs;
    private Combo configCombo;
    private FileFieldEditor defaultPreverifierField;

    public PreverificationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public PreverificationPreferencePage(boolean bl, IPreferenceStore iPreferenceStore) {
        this.embeddedInProperties = bl;
        this.setPreferenceStore(iPreferenceStore);
        try {
            this.configSpecs = MTJCorePlugin.getConfigurationSpecifications();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)coreException.getMessage(), (Throwable)coreException);
            this.configSpecs = new LibrarySpecification[0];
        }
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.addConfigurationControls(composite2);
        if (!this.embeddedInProperties) {
            this.addDefaultPreverifierControls(composite2);
        } else {
            this.noDefaultAndApplyButton();
        }
        this.setControlsFromPreferences();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performDefaults() {
        this.setControlsFromDefaults();
        super.performDefaults();
    }

    private void setDefaultPreverifier() {
        if (!this.defaultPreverifierField.getStringValue().equals(this.getPreferenceStore().getString("default_preverifier"))) {
            File file = new File(this.defaultPreverifierField.getStringValue());
            StandardPreverifier standardPreverifier = null;
            try {
                standardPreverifier = StandardPreverifierFactory.createPreverifier((File)file);
            }
            catch (CoreException coreException) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, "Invalid Preverifier", "The specified file does not seem to be a valid MTJ preverifier", coreException);
                MTJCorePlugin.log((int)4, (String)("Devices Store Error " + ((Object)((Object)coreException)).getClass().getName() + ": " + coreException.getMessage()), (Throwable)coreException);
            }
            DeviceRegistry.singleton.setDefaultPreverifer((IPreverifier)standardPreverifier);
            try {
                DeviceRegistry.singleton.store();
            }
            catch (Exception exception) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, "Error storing preverifier", "Error storing preverifier.\nConsult the error log for more information", exception);
                MTJCorePlugin.log((int)4, (String)("Devices Store Error " + exception.getClass().getName() + ": " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void performApply() {
        super.performApply();
    }

    public boolean performOk() {
        this.setPreferencesFromControls();
        if (!this.embeddedInProperties) {
            this.buildSuites();
        }
        return super.performOk();
    }

    private void addConfigurationControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Java ME Configuration for Preverification");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.preverificationRadios = new Button[BUTTON_TEXTS.length];
        int n = 0;
        while (n < BUTTON_TEXTS.length) {
            this.preverificationRadios[n] = new Button((Composite)group, 16);
            this.preverificationRadios[n].setText(BUTTON_TEXTS[n]);
            if (CONFIG_FILE_LOCATIONS[n].equals("specified")) {
                this.addSpecificConfigurationControls(group);
            }
            ++n;
        }
    }

    private void addDefaultPreverifierControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Default Preverifier");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText("Specify the preverifier to be used by emulators which do not have an associated preverifier.");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.defaultPreverifierField = new FileFieldEditor("default_preverifier", "Preverifier:", (Composite)group);
        String[] stringArray = null;
        if (Platform.getOS().equals("win32")) {
            stringArray = new String[]{"*.exe"};
        }
        this.defaultPreverifierField.setFileExtensions(stringArray);
        this.defaultPreverifierField.setPreferenceStore(this.getPreferenceStore());
    }

    private void addSpecificConfigurationControls(Group group) {
        this.configCombo = new Combo((Composite)group, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        this.configCombo.setLayoutData((Object)gridData);
        String[] stringArray = new String[this.configSpecs.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.configSpecs[n].getName();
            ++n;
        }
        this.configCombo.setItems(stringArray);
    }

    private void buildSuites() {
        IWorkspaceRoot iWorkspaceRoot = MTJCorePlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            try {
                if (iProject.isOpen() && iProject.hasNature("org.eclipse.mtj.core.nature") && !this.usesProjectSpecificPreverification(iProject)) {
                    arrayList.add(iProject);
                }
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (String)"Error building midlet suites", (Throwable)coreException);
            }
            ++n;
        }
        IProject[] iProjectArray2 = arrayList.toArray(new IProject[arrayList.size()]);
        if (iProjectArray2.length > 0) {
            this.doBuild(iProjectArray2);
        }
    }

    public void doBuild(final IProject[] iProjectArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    int n = 0;
                    while (n < iProjectArray.length) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, -1);
                        iProjectArray[n].build(6, (IProgressMonitor)subProgressMonitor);
                        subProgressMonitor.done();
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCorePlugin.log((int)2, (String)"Error building suites", (Throwable)invocationTargetException.getCause());
        }
    }

    private void setControlsFromPreferences() {
        if (this.preverificationRadios != null) {
            String string;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            String string2 = iPreferenceStore.getString("preverify_config_location");
            int n = 0;
            while (n < this.preverificationRadios.length) {
                string = CONFIG_FILE_LOCATIONS[n];
                this.preverificationRadios[n].setSelection(string.equals(string2));
                ++n;
            }
            n = 0;
            string = iPreferenceStore.getString("preverify_config_value");
            int n2 = 0;
            while (n2 < this.configSpecs.length) {
                LibrarySpecification librarySpecification = this.configSpecs[n2];
                if (librarySpecification.getIdentifier().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.configCombo.select(n);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.load();
        }
    }

    private void setPreferencesFromControls() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = 0;
        while (n < this.preverificationRadios.length) {
            if (this.preverificationRadios[n].getSelection()) {
                iPreferenceStore.setValue("preverify_config_location", CONFIG_FILE_LOCATIONS[n]);
                break;
            }
            ++n;
        }
        n = this.configCombo.getSelectionIndex();
        iPreferenceStore.setValue("preverify_config_value", this.configSpecs[n].getIdentifier());
        if (this.defaultPreverifierField != null) {
            this.setDefaultPreverifier();
            this.defaultPreverifierField.store();
        }
    }

    private void setControlsFromDefaults() {
        if (this.preverificationRadios != null) {
            String string;
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            String string2 = iPreferenceStore.getDefaultString("preverify_config_location");
            int n = 0;
            while (n < this.preverificationRadios.length) {
                string = CONFIG_FILE_LOCATIONS[n];
                this.preverificationRadios[n].setSelection(string.equals(string2));
                ++n;
            }
            n = 0;
            string = iPreferenceStore.getDefaultString("preverify_config_value");
            int n2 = 0;
            while (n2 < this.configSpecs.length) {
                LibrarySpecification librarySpecification = this.configSpecs[n2];
                if (librarySpecification.getIdentifier().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.configCombo.select(n);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.loadDefault();
        }
    }

    private boolean usesProjectSpecificPreverification(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
        return iEclipsePreferences.getBoolean("pkg_use_project", false);
    }
}

