/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.properties;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.signing.SignatureUtils;
import org.eclipse.mtj.core.model.jad.IJadSignature;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.model.sign.ISignatureProperties;
import org.eclipse.mtj.core.nature.J2MENature;
import org.eclipse.mtj.core.signing.SignatureProperties;
import org.eclipse.mtj.ui.MTJUIErrors;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class J2MESigningPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String SIGNING_GROUP_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.SigningProperties");
    private static final String SIGN_PROJECT_CHECK_BUTTON_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.SignProject");
    private static final String KEYSTORE_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeystoreFile");
    private static final String EXTERNAL_BROWSE_BUTTON_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.BrowseExternal");
    private static final String INTERNAL_BROWSE_BUTTON_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.BrowseInternal");
    private static final String ALIAS_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeyAlias");
    private static final String PROMPT_FOR_PWD_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.PromptForPasswords");
    private static final String STORE_PWD_KEYRING_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.SavePasswordsInKeyring");
    private static final String STORE_PWD_PROJECT_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.SavePasswordsInProject");
    private static final String KEYSTORE_PWD_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeystorePassword");
    private static final String KEY_PWD_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeyPassword");
    private static final String TEST_BUTTON_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.VerifySettings");
    private static final String ADVANCED_GROUP_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.AdvancedSettings");
    private static final String ADVANCED_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.LeaveEmptyForDefaults");
    private static final String PROVIDER_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.CryptoProvider");
    private static final String KEYSTORE_TYPE_LABEL_TEXT = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeystoreType");
    private static final String ERROR_MISSING_KEYSTORE = MTJUIStrings.getString("J2MEProjectPropertiesPage.ErrKeystoreFileRequired");
    private static final String ERROR_NOSUCH_KEYSTORE = MTJUIStrings.getString("J2MEProjectPropertiesPage.ErrKeystoreDoesntExist");
    private static final String ERROR_INVALID_KEYSTORE = MTJUIStrings.getString("J2MEProjectPropertiesPage.ErrInvalidKeystore");
    private static final String ERROR_MISSING_ALIAS = MTJUIStrings.getString("J2MEProjectPropertiesPage.ErrAliasRequired");
    private static final String ERROR_MISSING_STOREPASS = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeystorePassRequired");
    private static final String ERROR_MISSING_KEYPASS = MTJUIStrings.getString("J2MEProjectPropertiesPage.KeyPassRequired");
    private static final String TEST_SUCCESS = MTJUIStrings.getString("J2MEProjectPropertiesPage.SettingsVerified");
    private static final String BROWSE_DIALOG_TITLE = MTJUIStrings.getString("J2MEProjectPropertiesPage.BrowseForKeystore");
    private static final String BROWSE_DIALOG_MESSAGE = MTJUIStrings.getString("J2MEProjectPropertiesPage.BrowseForKeystoreMsg");
    private static final String BROWSE_NEED_FILE = MTJUIStrings.getString("J2MEProjectPropertiesPage.BrowseForKeystoreNeedFile");
    private static final String[] BROWSE_FILTER_NAMES = new String[]{MTJUIStrings.getString("J2MEProjectPropertiesPage.FilterNameKeystores"), MTJUIStrings.getString("J2MEProjectPropertiesPage.FilterNameAllFiles")};
    private static final String[] BROWSE_FILTER_EXTENSIONS = new String[]{"*.ks", "*.*"};
    private Button signProjectCheckButton;
    private Label keyfilePathLabel;
    private Label keyfilePath;
    private Button keyfileExternalBrowseButton;
    private Button keyfileInternalBrowseButton;
    private boolean isKeyfileExternal;
    private Label aliasLabel;
    private Text aliasText;
    private Button promptForPasswordRadio;
    private Button savePasswordsInKeyringRadio;
    private Button savePasswordsInProjectRadio;
    private Label keystorePassLabel;
    private Text keystorePassText;
    private Label keyPassLabel;
    private Text keyPassText;
    private Group advancedGroup;
    private Label advancedInstructions;
    private Label providerLabel;
    private Text providerText;
    private Label keystoreTypeLabel;
    private Text keystoreTypeText;
    private Button testButton;
    private SignatureProperties sigProps;
    private boolean bLoading = false;
    private boolean bSigningDataValid = false;

    public String convertEmptyToNull(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public boolean isValid() {
        return this.bSigningDataValid;
    }

    public boolean performOk() {
        IProject iProject = this.getProject();
        boolean bl = false;
        try {
            bl = J2MENature.hasMtjCoreNature((IProject)iProject);
        }
        catch (CoreException coreException) {}
        if (!bl) {
            return true;
        }
        boolean bl2 = false;
        try {
            IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject();
            iMidletSuiteProject.setSignatureProperties((ISignatureProperties)this.sigProps);
            iMidletSuiteProject.saveMetaData();
            bl2 = true;
        }
        catch (Exception exception) {
            MTJUIErrors.displayError(this.getShell(), "MTJUiError.Exception", "MTJUiError.SetPlatformFailed", exception);
        }
        return bl2;
    }

    private void browseExternalForKeystore() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(BROWSE_DIALOG_TITLE);
        fileDialog.setFilterNames(BROWSE_FILTER_NAMES);
        fileDialog.setFilterExtensions(BROWSE_FILTER_EXTENSIONS);
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        this.keyfilePath.setText(string);
        this.isKeyfileExternal = true;
    }

    private void browseProjectForKeystore() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setTitle(BROWSE_DIALOG_TITLE);
        elementTreeSelectionDialog.setMessage(BROWSE_DIALOG_MESSAGE);
        elementTreeSelectionDialog.setInput((Object)this.getProject());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setEmptyListMessage(BROWSE_NEED_FILE);
        elementTreeSelectionDialog.setStatusLineAboveButtons(true);
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, BROWSE_NEED_FILE, null);
                }
                if (!(objectArray[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.mtj.ui", 1, BROWSE_NEED_FILE, null);
                }
                return new Status(0, "org.eclipse.mtj.ui", 0, ((IFile)objectArray[0]).getName(), null);
            }
        });
        if (elementTreeSelectionDialog.open() != 0) {
            return;
        }
        Object[] objectArray = elementTreeSelectionDialog.getResult();
        if (objectArray.length == 0 || !(objectArray[0] instanceof IFile)) {
            return;
        }
        IFile iFile = (IFile)objectArray[0];
        IPath iPath = iFile.getFullPath();
        IPath iPath2 = iPath.removeFirstSegments(1);
        String string = iPath2.toString();
        String string2 = SignatureProperties.toRelative((String)string);
        this.keyfilePath.setText(string2);
        this.isKeyfileExternal = false;
    }

    private GridData buildGridData(int n, boolean bl, int n2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.horizontalSpan = n2;
        return gridData;
    }

    private String convertNullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private IMidletSuiteProject getMidletSuiteProject() {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        return iMidletSuiteProject;
    }

    private IProject getProject() {
        IProject iProject = null;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        } else if (iAdaptable instanceof IJavaProject) {
            iProject = ((IJavaProject)iAdaptable).getProject();
        }
        return iProject;
    }

    private Label insertLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        return label;
    }

    private boolean isJ2MEProject(IProject iProject) {
        boolean bl = false;
        if (iProject != null) {
            try {
                IProjectNature iProjectNature = iProject.getNature("org.eclipse.mtj.core.nature");
                bl = iProjectNature != null;
            }
            catch (CoreException coreException) {}
        }
        return bl;
    }

    private boolean isKeystorePathValid() {
        File file;
        String string = this.convertEmptyToNull(this.keyfilePath.getText());
        if (string == null) {
            this.setErrorMessage(ERROR_MISSING_KEYSTORE);
            return false;
        }
        if (!this.isKeyfileExternal) {
            try {
                string = SignatureProperties.toAbsolute((String)string, (IProject)this.getProject());
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (Throwable)coreException);
                return false;
            }
        }
        if (!(file = new File(string)).exists()) {
            this.setErrorMessage(ERROR_NOSUCH_KEYSTORE);
            return false;
        }
        if (!file.isFile()) {
            this.setErrorMessage(ERROR_INVALID_KEYSTORE);
            return false;
        }
        return true;
    }

    private boolean isReadOnly(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.hasNature("org.eclipse.mtj.core.preprocessedNature");
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (Throwable)coreException);
        }
        return bl;
    }

    private void loadPageData() {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject();
        ISignatureProperties iSignatureProperties = null;
        try {
            iSignatureProperties = iMidletSuiteProject.getSignatureProperties();
        }
        catch (CoreException coreException) {}
        if (iSignatureProperties != null) {
            this.sigProps.copy(iSignatureProperties);
        } else {
            this.sigProps.clear();
        }
        this.loadSigningData();
    }

    private void loadSigningData() {
        this.bLoading = true;
        this.signProjectCheckButton.setSelection(this.sigProps.getSignProject());
        this.keyfilePath.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreDisplayPath()));
        this.isKeyfileExternal = this.sigProps.isKeyStorePathExternal();
        this.aliasText.setText(this.convertNullToEmpty(this.sigProps.getKeyAlias()));
        switch (this.sigProps.getPasswordStorageMethod()) {
            case 2: {
                this.promptForPasswordRadio.setSelection(false);
                this.savePasswordsInKeyringRadio.setSelection(false);
                this.savePasswordsInProjectRadio.setSelection(true);
                this.keystorePassText.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
                this.keyPassText.setText(this.convertNullToEmpty(this.sigProps.getKeyPassword()));
                break;
            }
            case 1: {
                this.promptForPasswordRadio.setSelection(false);
                this.savePasswordsInKeyringRadio.setSelection(true);
                this.savePasswordsInProjectRadio.setSelection(false);
                this.keystorePassText.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
                this.keyPassText.setText(this.convertNullToEmpty(this.sigProps.getKeyPassword()));
                break;
            }
            default: {
                this.promptForPasswordRadio.setSelection(true);
                this.savePasswordsInKeyringRadio.setSelection(false);
                this.savePasswordsInProjectRadio.setSelection(false);
            }
        }
        this.providerText.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreProvider()));
        this.keystoreTypeText.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreType()));
        this.bLoading = false;
        this.validatePage();
    }

    private void populateSigningGroup(Group group) {
        group.setLayout((Layout)new GridLayout(4, false));
        this.signProjectCheckButton = new Button((Composite)group, 32);
        this.signProjectCheckButton.setText(SIGN_PROJECT_CHECK_BUTTON_TEXT);
        this.signProjectCheckButton.setLayoutData((Object)this.buildGridData(1, false, 4));
        this.signProjectCheckButton.setEnabled(!this.isReadOnly(this.getProject()));
        this.keyfilePathLabel = this.insertLabel((Composite)group, KEYSTORE_LABEL_TEXT);
        this.keyfilePath = new Label((Composite)group, 18432);
        this.keyfilePath.setLayoutData((Object)this.buildGridData(4, true, 1));
        this.keyfileInternalBrowseButton = new Button((Composite)group, 8);
        this.keyfileInternalBrowseButton.setText(INTERNAL_BROWSE_BUTTON_TEXT);
        this.keyfileInternalBrowseButton.setLayoutData((Object)this.buildGridData(0x1000008, false, 1));
        this.keyfileExternalBrowseButton = new Button((Composite)group, 8);
        this.keyfileExternalBrowseButton.setText(EXTERNAL_BROWSE_BUTTON_TEXT);
        this.keyfileExternalBrowseButton.setLayoutData((Object)this.buildGridData(0x1000008, false, 1));
        this.aliasLabel = this.insertLabel((Composite)group, ALIAS_LABEL_TEXT);
        this.aliasText = new Text((Composite)group, 2052);
        this.aliasText.setLayoutData((Object)this.buildGridData(4, false, 3));
        new Label((Composite)group, 258).setLayoutData((Object)this.buildGridData(4, false, 4));
        this.promptForPasswordRadio = new Button((Composite)group, 16);
        this.promptForPasswordRadio.setText(PROMPT_FOR_PWD_LABEL_TEXT);
        this.promptForPasswordRadio.setLayoutData((Object)this.buildGridData(1, false, 4));
        this.savePasswordsInKeyringRadio = new Button((Composite)group, 16);
        this.savePasswordsInKeyringRadio.setText(STORE_PWD_KEYRING_LABEL_TEXT);
        this.savePasswordsInKeyringRadio.setLayoutData((Object)this.buildGridData(1, false, 4));
        this.savePasswordsInProjectRadio = new Button((Composite)group, 16);
        this.savePasswordsInProjectRadio.setText(STORE_PWD_PROJECT_LABEL_TEXT);
        this.savePasswordsInProjectRadio.setLayoutData((Object)this.buildGridData(1, false, 4));
        this.keystorePassLabel = this.insertLabel((Composite)group, KEYSTORE_PWD_LABEL_TEXT);
        this.keystorePassText = new Text((Composite)group, 0x400804);
        this.keystorePassText.setLayoutData((Object)this.buildGridData(4, false, 3));
        this.keyPassLabel = this.insertLabel((Composite)group, KEY_PWD_LABEL_TEXT);
        this.keyPassText = new Text((Composite)group, 0x400804);
        this.keyPassText.setLayoutData((Object)this.buildGridData(4, false, 3));
        this.advancedGroup = new Group((Composite)group, 0);
        this.advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.advancedGroup.setText(ADVANCED_GROUP_TEXT);
        this.advancedGroup.setLayoutData((Object)this.buildGridData(4, false, 4));
        this.advancedInstructions = new Label((Composite)this.advancedGroup, 16384);
        this.advancedInstructions.setText(ADVANCED_TEXT);
        this.advancedInstructions.setLayoutData((Object)this.buildGridData(1, false, 3));
        this.providerLabel = this.insertLabel((Composite)this.advancedGroup, PROVIDER_LABEL_TEXT);
        this.providerText = new Text((Composite)this.advancedGroup, 2052);
        this.providerText.setLayoutData((Object)this.buildGridData(4, true, 2));
        this.keystoreTypeLabel = this.insertLabel((Composite)this.advancedGroup, KEYSTORE_TYPE_LABEL_TEXT);
        this.keystoreTypeText = new Text((Composite)this.advancedGroup, 2052);
        this.keystoreTypeText.setLayoutData((Object)this.buildGridData(4, true, 2));
        this.testButton = new Button((Composite)group, 8);
        this.testButton.setText(TEST_BUTTON_TEXT);
        this.testButton.setLayoutData((Object)this.buildGridData(1, false, 1));
        this.signProjectCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.promptForPasswordRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    J2MESigningPropertiesPage.this.validatePage();
                }
            }
        });
        this.savePasswordsInKeyringRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    J2MESigningPropertiesPage.this.validatePage();
                }
            }
        });
        this.savePasswordsInProjectRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    J2MESigningPropertiesPage.this.validatePage();
                }
            }
        });
        this.keyfileInternalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                J2MESigningPropertiesPage.this.browseProjectForKeystore();
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.keyfileExternalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                J2MESigningPropertiesPage.this.browseExternalForKeystore();
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.aliasText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.keystorePassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.keyPassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                J2MESigningPropertiesPage.this.validatePage();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                J2MESigningPropertiesPage.this.testSettings();
            }
        });
    }

    private void testSettings() {
        if (!this.updateSigningFields()) {
            return;
        }
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject();
        try {
            IJadSignature iJadSignature = SignatureUtils.getSignatureObject((IMidletSuiteProject)iMidletSuiteProject, (ISignatureProperties)this.sigProps);
            if (iJadSignature != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)MTJUIStrings.getString("common.success"), (String)TEST_SUCCESS);
            }
        }
        catch (CoreException coreException) {
            MTJUIErrors.displayError(this.getShell(), null, "J2MEProjectPropertiesPage.VerificationFailed", coreException.getStatus());
        }
    }

    private boolean updateSigningFields() {
        if (this.bLoading) {
            return true;
        }
        boolean bl = this.signProjectCheckButton.getSelection();
        this.keyfilePathLabel.setEnabled(bl);
        this.keyfilePath.setEnabled(bl);
        this.keyfileExternalBrowseButton.setEnabled(bl);
        this.keyfileInternalBrowseButton.setEnabled(bl);
        this.aliasLabel.setEnabled(bl);
        this.aliasText.setEnabled(bl);
        this.promptForPasswordRadio.setEnabled(bl);
        this.savePasswordsInProjectRadio.setEnabled(bl);
        this.savePasswordsInKeyringRadio.setEnabled(bl);
        this.advancedGroup.setEnabled(bl);
        this.advancedInstructions.setEnabled(bl);
        this.providerLabel.setEnabled(bl);
        this.providerText.setEnabled(bl);
        this.keystoreTypeLabel.setEnabled(bl);
        this.keystoreTypeText.setEnabled(bl);
        if (!bl) {
            this.keystorePassLabel.setEnabled(false);
            this.keystorePassText.setEnabled(false);
            this.keyPassLabel.setEnabled(false);
            this.keyPassText.setEnabled(false);
            this.sigProps.clear();
            this.testButton.setEnabled(false);
            this.setErrorMessage(null);
            return true;
        }
        this.testButton.setEnabled(false);
        boolean bl2 = !this.promptForPasswordRadio.getSelection();
        this.keystorePassLabel.setEnabled(bl2);
        this.keystorePassText.setEnabled(bl2);
        this.keyPassLabel.setEnabled(bl2);
        this.keyPassText.setEnabled(bl2);
        this.sigProps.setSignProject(true);
        if (!this.isKeystorePathValid()) {
            return false;
        }
        this.sigProps.setKeyStoreDisplayPath(this.convertEmptyToNull(this.keyfilePath.getText()));
        String string = this.convertEmptyToNull(this.aliasText.getText());
        if (string == null) {
            this.setErrorMessage(ERROR_MISSING_ALIAS);
            return false;
        }
        this.sigProps.setKeyAlias(string);
        if (this.savePasswordsInKeyringRadio.getSelection()) {
            this.sigProps.setPasswordStorageMethod(1);
            string = this.convertEmptyToNull(this.keystorePassText.getText());
            if (string == null) {
                this.setErrorMessage(ERROR_MISSING_STOREPASS);
                return false;
            }
            this.sigProps.setKeyStorePassword(string);
            string = this.convertEmptyToNull(this.keyPassText.getText());
            if (string == null) {
                this.setErrorMessage(ERROR_MISSING_KEYPASS);
                return false;
            }
            this.sigProps.setKeyPassword(string);
        } else if (this.savePasswordsInProjectRadio.getSelection()) {
            this.sigProps.setPasswordStorageMethod(2);
            string = this.convertEmptyToNull(this.keystorePassText.getText());
            if (string == null) {
                this.setErrorMessage(ERROR_MISSING_STOREPASS);
                return false;
            }
            this.sigProps.setKeyStorePassword(string);
            string = this.convertEmptyToNull(this.keyPassText.getText());
            if (string == null) {
                this.setErrorMessage(ERROR_MISSING_KEYPASS);
                return false;
            }
            this.sigProps.setKeyPassword(string);
        } else {
            this.sigProps.setPasswordStorageMethod(0);
            this.sigProps.setKeyStorePassword(null);
            this.sigProps.setKeyPassword(null);
        }
        this.sigProps.setKeyStoreProvider(this.convertEmptyToNull(this.providerText.getText()));
        this.sigProps.setKeyStoreType(this.convertEmptyToNull(this.keystoreTypeText.getText()));
        this.setErrorMessage(null);
        this.testButton.setEnabled(true);
        return true;
    }

    private void validatePage() {
        this.bSigningDataValid = this.updateSigningFields();
        this.updateApplyButton();
        this.getContainer().updateButtons();
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_J2MEProjectPropertiesPage");
        IProject iProject = this.getProject();
        if (!this.isJ2MEProject(iProject)) {
            Label label = new Label(composite, 0);
            label.setText(MTJUIStrings.getString("J2MEProjectPropertiesPage.NotMidletSuiteProject"));
            return label;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group(composite2, 0);
        group.setText(SIGNING_GROUP_TEXT);
        group.setLayoutData((Object)new GridData(768));
        this.populateSigningGroup(group);
        this.sigProps = new SignatureProperties();
        this.loadPageData();
        return composite2;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setErrorMessage(null);
        this.sigProps.clear();
        this.loadSigningData();
    }
}

