/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.IReconcilingParticipant;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJOutlinePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;

public class SourceOutlinePage
extends MTJOutlinePage
implements IReconcilingParticipant,
ISortableContentOutlinePage {
    private IContentProvider contentProvider;
    private ViewerComparator defaultComparator;
    private IBaseLabelProvider labelProvider;
    private ArrayList<ISelectionChangedListener> listenerList;
    private IEditingModel model;
    private boolean sorted;
    private ViewerComparator viewerComparator;
    TreeViewer viewer;

    public SourceOutlinePage(MTJFormEditor mTJFormEditor, IEditingModel iEditingModel, IBaseLabelProvider iBaseLabelProvider, IContentProvider iContentProvider, ViewerComparator viewerComparator, ViewerComparator viewerComparator2) {
        super(mTJFormEditor);
        this.model = iEditingModel;
        this.labelProvider = iBaseLabelProvider;
        this.contentProvider = iContentProvider;
        this.defaultComparator = viewerComparator;
        this.viewerComparator = viewerComparator2;
        this.listenerList = new ArrayList();
    }

    public void addAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        int n = 0;
        while (n < this.listenerList.size()) {
            super.addSelectionChangedListener(this.listenerList.get(n));
            ++n;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listenerList.add(iSelectionChangedListener);
        super.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setLabelProvider(this.labelProvider);
        if (this.sorted) {
            this.viewer.setComparator(this.viewerComparator);
        } else {
            this.viewer.setComparator(this.defaultComparator);
        }
        this.viewer.setInput((Object)this.model);
        this.viewer.expandAll();
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
    }

    public void reconciled(IDocument iDocument) {
        final Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                control.setRedraw(false);
                SourceOutlinePage.this.removeAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().refresh();
                SourceOutlinePage.this.addAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().expandAll();
                control.setRedraw(true);
            }
        });
    }

    public void removeAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        int n = 0;
        while (n < this.listenerList.size()) {
            super.removeSelectionChangedListener(this.listenerList.get(n));
            ++n;
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listenerList.remove(iSelectionChangedListener);
        super.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void sort(boolean bl) {
        this.sorted = bl;
        if (this.isViewerDefined()) {
            if (bl) {
                this.viewer.setComparator(this.viewerComparator);
            } else {
                this.viewer.setComparator(this.defaultComparator);
            }
        }
    }

    private boolean isViewerDefined() {
        if (this.viewer == null) {
            return false;
        }
        return !this.viewer.getTree().isDisposed();
    }
}

