/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.overtheair.OTAServer;
import org.eclipse.mtj.internal.ui.MTJLabelProvider;
import org.eclipse.mtj.ui.internal.utils.PluginPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class MTJUIPlugin
extends AbstractUIPlugin {
    private static MTJUIPlugin plugin;
    private Map<ColorCacheKey, Resource> colorCache;
    private IPreferenceStore corePreferenceStore;
    private FormToolkit dialogsFormToolkit;
    private Map<FontCacheKey, Resource> fontCache;
    private IDocumentProvider fTextFileDocumentProvider;
    private FormColors fFormColors;
    private MTJLabelProvider fLabelProvider;

    public static void displayError(Shell shell, int n, int n2, String string, String string2, Throwable throwable) {
        String string3 = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        Status status = new Status(n, string3, n2, string2, throwable);
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)status);
    }

    public static IWorkbenchPage getActivePage() {
        return MTJUIPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWindowShell() {
        MTJUIPlugin mTJUIPlugin = MTJUIPlugin.getDefault();
        IWorkbenchWindow iWorkbenchWindow = mTJUIPlugin.getWorkbench().getActiveWorkbenchWindow();
        return iWorkbenchWindow.getShell();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = MTJUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Color getColor(Display display, int n, int n2, int n3) {
        Map<ColorCacheKey, Resource> map = MTJUIPlugin.getDefault().colorCache;
        ColorCacheKey colorCacheKey = new ColorCacheKey(display, n, n2, n3);
        Color color = (Color)map.get(colorCacheKey);
        if (color == null) {
            color = new Color((Device)display, n, n2, n3);
            map.put(colorCacheKey, (Resource)color);
        }
        return color;
    }

    public static IPersistentPreferenceStore getCoreProjectPreferenceStore(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        return new ScopedPreferenceStore((IScopeContext)projectScope, "org.eclipse.mtj.core");
    }

    public static MTJUIPlugin getDefault() {
        return plugin;
    }

    public static IDialogSettings getDialogSettings(IDialogSettings iDialogSettings, String string) {
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    public static IDialogSettings getDialogSettings(String string) {
        return MTJUIPlugin.getDialogSettings(MTJUIPlugin.getDefault().getDialogSettings(), string);
    }

    public static Font getFont(Display display, String string, int n, int n2) {
        Map<FontCacheKey, Resource> map = MTJUIPlugin.getDefault().fontCache;
        FontCacheKey fontCacheKey = new FontCacheKey(display, string, n, n2);
        Font font = (Font)map.get(fontCacheKey);
        if (font == null) {
            font = new Font((Device)display, string, n, n2);
            map.put(fontCacheKey, (Resource)font);
        }
        return font;
    }

    public static ImageDescriptor getIconImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = null;
        try {
            URL uRL = MTJUIPlugin.getDefault().getBundle().getEntry("/");
            URL uRL2 = new URL(uRL, "icons/" + string);
            imageDescriptor = ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            MTJCorePlugin.log((int)1, (String)"getIconImage", (Throwable)malformedURLException);
        }
        return imageDescriptor;
    }

    public static Image getImageFromCache(String string) {
        ImageRegistry imageRegistry = MTJUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(string);
        if (image == null) {
            ImageDescriptor imageDescriptor = MTJUIPlugin.getIconImageDescriptor(string);
            imageRegistry.put(string, imageDescriptor);
            image = imageRegistry.get(string);
        }
        return image;
    }

    public static String getPluginId() {
        return MTJUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public MTJUIPlugin() {
        if (plugin == null) {
            plugin = this;
        }
        this.colorCache = new HashMap<ColorCacheKey, Resource>();
        this.fontCache = new HashMap<FontCacheKey, Resource>();
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            MTJCorePlugin mTJCorePlugin = MTJCorePlugin.getDefault();
            this.corePreferenceStore = new PluginPreferenceStore((Plugin)mTJCorePlugin, mTJCorePlugin.getPluginPreferences());
        }
        return this.corePreferenceStore;
    }

    public FormToolkit getDialogsFormToolkit() {
        if (this.dialogsFormToolkit == null) {
            FormColors formColors = new FormColors(Display.getCurrent());
            formColors.setBackground(null);
            formColors.setForeground(null);
            this.dialogsFormToolkit = new FormToolkit(formColors);
        }
        return this.dialogsFormToolkit;
    }

    public synchronized IDocumentProvider getTextFileDocumentProvider() {
        if (this.fTextFileDocumentProvider == null) {
            this.fTextFileDocumentProvider = new TextFileDocumentProvider();
        }
        return this.fTextFileDocumentProvider;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        for (Color color2 : this.colorCache.values()) {
            color2.dispose();
        }
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("ota_start_at_start");
        if (bl) {
            this.startupOTAServer();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.dialogsFormToolkit != null) {
                this.dialogsFormToolkit.dispose();
                this.dialogsFormToolkit = null;
            }
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    private void startupOTAServer() {
        try {
            OTAServer.instance.start();
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)4, (String)"startupOTAServer", (Throwable)exception);
        }
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public MTJLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new MTJLabelProvider();
        }
        return this.fLabelProvider;
    }

    public static boolean isFullNameModeEnabled() {
        return false;
    }

    private static class ColorCacheKey {
        private int blue;
        private Display display;
        private int green;
        private int red;

        private ColorCacheKey(Display display, int n, int n2, int n3) {
            this.display = display;
            this.red = n;
            this.green = n2;
            this.blue = n3;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof ColorCacheKey) {
                ColorCacheKey colorCacheKey = (ColorCacheKey)object;
                bl = this.display.equals(colorCacheKey.display) && this.red == colorCacheKey.red && this.green == colorCacheKey.green && this.blue == colorCacheKey.blue;
            }
            return bl;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.red << 24 ^ this.green << 16 ^ this.blue;
        }
    }

    private static class FontCacheKey {
        private Display display;
        private int height;
        private String name;
        private int style;

        private FontCacheKey(Display display, String string, int n, int n2) {
            this.display = display;
            this.name = string;
            this.height = n;
            this.style = n2;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof FontCacheKey) {
                FontCacheKey fontCacheKey = (FontCacheKey)object;
                bl = this.display.equals(fontCacheKey.display) && this.name.equals(fontCacheKey.name) && this.height == fontCacheKey.height && this.style == fontCacheKey.style;
            }
            return bl;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.name.hashCode() ^ this.height << 16 ^ this.style;
        }
    }
}

