/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.core.model.IBaseModel;
import org.eclipse.mtj.core.model.IModelChangeProvider;
import org.eclipse.mtj.core.model.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJOutlinePage;
import org.eclipse.mtj.internal.ui.editor.elements.DefaultContentProvider;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.editor.IFormPage;

public class FormOutlinePage
extends MTJOutlinePage
implements IModelChangedListener,
ISortableContentOutlinePage {
    private boolean sorted;
    private boolean stale;
    private ViewerComparator viewerComparator;
    protected boolean editorSelection = false;
    protected boolean outlineSelection = false;
    protected TreeViewer treeViewer;

    public FormOutlinePage(MTJFormEditor mTJFormEditor) {
        super(mTJFormEditor);
    }

    public ITreeContentProvider createContentProvider() {
        return new BasicContentProvider();
    }

    public void createControl(Composite composite) {
        Tree tree = new Tree(composite, 770);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewerComparator = this.createOutlineSorter();
        if (this.sorted) {
            this.treeViewer.setComparator(this.viewerComparator);
        } else {
            this.treeViewer.setComparator(null);
        }
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.fEditor);
        IBaseModel iBaseModel = this.fEditor.getAggregateModel();
        if (iBaseModel instanceof IModelChangeProvider) {
            ((IModelChangeProvider)iBaseModel).addModelChangedListener((IModelChangedListener)this);
        }
    }

    public ILabelProvider createLabelProvider() {
        return new BasicLabelProvider();
    }

    public ViewerComparator createOutlineSorter() {
        return new BasicComparator();
    }

    public void dispose() {
        IBaseModel iBaseModel = this.fEditor.getAggregateModel();
        if (iBaseModel instanceof IModelChangeProvider) {
            ((IModelChangeProvider)iBaseModel).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public Control getControl() {
        return this.treeViewer != null ? this.treeViewer.getControl() : null;
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        IFormPage iFormPage = this.fEditor.getActivePageInstance();
        this.stale = true;
        if (!iFormPage.isEditor()) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.stale) {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!FormOutlinePage.this.treeViewer.getControl().isDisposed()) {
                        FormOutlinePage.this.treeViewer.refresh();
                        FormOutlinePage.this.treeViewer.expandAll();
                        FormOutlinePage.this.stale = false;
                    }
                }
            });
        }
    }

    public void selectionChanged(Object object) {
        IFormPage iFormPage;
        IFormPage iFormPage2 = this.fEditor.getActivePageInstance();
        String string = this.getParentPageId(object);
        IFormPage iFormPage3 = null;
        if (!(string == null || iFormPage2 != null && iFormPage2.getId().equals(string))) {
            iFormPage3 = this.fEditor.setActivePage(string);
        }
        IFormPage iFormPage4 = iFormPage = iFormPage3 != null ? iFormPage3 : iFormPage2;
        if (iFormPage != null && !(object instanceof IFormPage)) {
            iFormPage.selectReveal(object);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.editorSelection) {
            return;
        }
        this.outlineSelection = true;
        try {
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                Object object = iStructuredSelection.getFirstElement();
                this.selectionChanged(object);
            }
            this.fireSelectionChanged(iSelection);
        }
        finally {
            this.outlineSelection = false;
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelection(ISelection iSelection) {
        if (this.outlineSelection) {
            return;
        }
        this.editorSelection = true;
        try {
            Object object;
            if (this.treeViewer == null) {
                return;
            }
            if (iSelection != null && !iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IDocumentElementNode) {
                while (this.treeViewer.testFindItem(object) == null) {
                    if ((object = ((IDocumentElementNode)object).getParentNode()) == null) break;
                    iSelection = new StructuredSelection(object);
                }
            }
            this.treeViewer.setSelection(iSelection);
        }
        finally {
            this.editorSelection = false;
        }
    }

    public void sort(boolean bl) {
        this.sorted = bl;
        if (this.treeViewer != null) {
            if (bl) {
                this.treeViewer.setComparator(this.viewerComparator);
            } else {
                this.treeViewer.setComparator(null);
            }
        }
    }

    private Object[] getPages() {
        IFormPage[] iFormPageArray;
        ArrayList<IFormPage> arrayList = new ArrayList<IFormPage>();
        IFormPage[] iFormPageArray2 = iFormPageArray = this.fEditor.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage iFormPage = iFormPageArray2[n2];
            if (!iFormPage.isEditor()) {
                arrayList.add(iFormPage);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    protected Object[] getChildren(Object object) {
        return new Object[0];
    }

    protected String getParentPageId(Object object) {
        if (object instanceof IFormPage) {
            return ((IFormPage)object).getId();
        }
        return null;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public class BasicComparator
    extends ViewerComparator {
        public int category(Object object) {
            Object[] objectArray = FormOutlinePage.this.getPages();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == object) {
                    return n;
                }
                ++n;
            }
            return Integer.MAX_VALUE;
        }
    }

    public class BasicContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object object) {
            return FormOutlinePage.this.getChildren(object);
        }

        public Object[] getElements(Object object) {
            return FormOutlinePage.this.getPages();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }
    }

    public class BasicLabelProvider
    extends LabelProvider {
        public Image getImage(Object object) {
            if (object instanceof IFormPage) {
                return MTJUIPlugin.getDefault().getLabelProvider().get(MTJUIPluginImages.DESC_PAGE_OBJ);
            }
            return MTJUIPlugin.getDefault().getLabelProvider().getImage(object);
        }

        public String getText(Object object) {
            if (object instanceof IFormPage) {
                return ((IFormPage)object).getTitle();
            }
            return MTJUIPlugin.getDefault().getLabelProvider().getText(object);
        }
    }
}

