/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.source.contentassist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.library.LibrarySpecification;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.ui.internal.editors.jad.source.JADSourceEditor;
import org.eclipse.mtj.ui.internal.editors.jad.source.contentassist.JADAttributeCompletionProposal;
import org.eclipse.mtj.ui.internal.editors.jad.source.contentassist.JADAttributeHeadersProvider;

public class CompletionProcessor
implements IContentAssistProcessor {
    private static final String MIDLET_PREFIX = "MIDlet-";
    private static final Pattern MIDLET_PATTERN = Pattern.compile("(MIDlet-\\d+:).*");
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'M', 'm', ' ', ','};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private String midletHeader;
    private ColonDelimitedProperties existedPropertis;
    private JADSourceEditor sourcePage;

    public CompletionProcessor(JADSourceEditor jADSourceEditor) {
        this.sourcePage = jADSourceEditor;
    }

    protected ICompletionProposal[] computeCompletionProposals(IDocument iDocument, int n, int n2) {
        try {
            String string = iDocument.get(n, n2 - n);
            if (!this.isHeader(string)) {
                return this.computeValue(string, n, n2);
            }
            return this.computeHeader(string, n, n2);
        }
        catch (BadLocationException badLocationException) {
            return new ICompletionProposal[0];
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        try {
            IDocument iDocument = iTextViewer.getDocument();
            this.parseDocument(iDocument);
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = iDocument.getLineOffset(n2);
            return this.computeCompletionProposals(iDocument, n3, n);
        }
        catch (BadLocationException badLocationException) {
            return this.NO_COMPLETIONS;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return this.NO_CONTEXTS;
    }

    protected ICompletionProposal[] computeHeader(String string, int n, int n2) {
        Object object;
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray2 = stringArray = JADAttributeHeadersProvider.getSupportJADAttrHeaders();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = stringArray2[n4];
            if (((String)object).regionMatches(true, 0, string, 0, string.length()) && this.emptyString(this.existedPropertis.getProperty((String)object))) {
                JADAttributeCompletionProposal jADAttributeCompletionProposal = new JADAttributeCompletionProposal(String.valueOf(object) + ":", null, (String)object, n, string.length());
                arrayList.add(jADAttributeCompletionProposal);
            }
            ++n4;
        }
        if (MIDLET_PREFIX.regionMatches(true, 0, string, 0, string.length())) {
            object = new JADAttributeCompletionProposal(String.valueOf(this.midletHeader) + ":", null, this.midletHeader, n, string.length());
            arrayList.add(object);
        }
        return this.sortProposals(arrayList.toArray(new ICompletionProposal[arrayList.size()]));
    }

    protected ICompletionProposal[] computeValue(String string, int n, int n2) throws BadLocationException {
        Matcher matcher = MIDLET_PATTERN.matcher(string);
        if (matcher.matches()) {
            return this.handleMIDletCompletion(string.substring(matcher.group(1).length() + 1), n2);
        }
        if (string.regionMatches(true, 0, "MicroEdition-Configuration", 0, Math.min(string.length(), "MicroEdition-Configuration".length()))) {
            return this.handleConfigurationCompletion(string.substring("MicroEdition-Configuration".length() + 1), n2);
        }
        if (string.regionMatches(true, 0, "MicroEdition-Profile", 0, Math.min(string.length(), "MicroEdition-Profile".length()))) {
            return this.handleProfileCompletion(string.substring("MicroEdition-Profile".length() + 1), n2);
        }
        return this.NO_COMPLETIONS;
    }

    private boolean emptyString(Object object) {
        return object == null || "".equals(object);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private IJavaProject getJavaProject() {
        return this.sourcePage.getJavaProject();
    }

    private ICompletionProposal[] handleConfigurationCompletion(String string, int n) {
        ArrayList<JADAttributeCompletionProposal> arrayList = new ArrayList<JADAttributeCompletionProposal>();
        try {
            LibrarySpecification[] librarySpecificationArray = MTJCorePlugin.getConfigurationSpecifications();
            string = string.trim();
            LibrarySpecification[] librarySpecificationArray2 = librarySpecificationArray;
            int n2 = librarySpecificationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                LibrarySpecification librarySpecification = librarySpecificationArray2[n3];
                String string2 = librarySpecification.getIdentifier();
                if (string2.regionMatches(true, 0, string, 0, string.length())) {
                    JADAttributeCompletionProposal jADAttributeCompletionProposal = new JADAttributeCompletionProposal(string2, null, string2, n - string.length(), string.length());
                    arrayList.add(jADAttributeCompletionProposal);
                }
                ++n3;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (Throwable)coreException);
        }
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    private ICompletionProposal[] handleMIDletCompletion(String string, int n) {
        String[] stringArray = string.split(",", -1);
        ArrayList<JADAttributeCompletionProposal> arrayList = new ArrayList<JADAttributeCompletionProposal>();
        if (stringArray != null && stringArray.length == 3) {
            IJavaProject iJavaProject = this.getJavaProject();
            List list = Utils.getMidletTypesInProject((IProgressMonitor)new NullProgressMonitor(), (IJavaProject)iJavaProject);
            for (IType iType : list) {
                String string2 = iType.getElementName();
                String string3 = iType.getFullyQualifiedName();
                if (!string2.regionMatches(true, 0, stringArray[2], 0, stringArray[2].length())) continue;
                JADAttributeCompletionProposal jADAttributeCompletionProposal = new JADAttributeCompletionProposal(string3, MTJUIPluginImages.DESC_MIDLET_ICON.createImage(), String.valueOf(string2) + " - " + string3, n - stringArray[2].length(), stringArray[2].length());
                arrayList.add(jADAttributeCompletionProposal);
            }
            return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
        }
        return this.NO_COMPLETIONS;
    }

    private ICompletionProposal[] handleProfileCompletion(String string, int n) {
        ArrayList<JADAttributeCompletionProposal> arrayList = new ArrayList<JADAttributeCompletionProposal>();
        try {
            LibrarySpecification[] librarySpecificationArray = MTJCorePlugin.getProfileSpecifications();
            string = string.trim();
            LibrarySpecification[] librarySpecificationArray2 = librarySpecificationArray;
            int n2 = librarySpecificationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                LibrarySpecification librarySpecification = librarySpecificationArray2[n3];
                String string2 = librarySpecification.getIdentifier();
                if (string2.regionMatches(true, 0, string, 0, string.length())) {
                    JADAttributeCompletionProposal jADAttributeCompletionProposal = new JADAttributeCompletionProposal(string2, null, string2, n - string.length(), string.length());
                    arrayList.add(jADAttributeCompletionProposal);
                }
                ++n3;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (Throwable)coreException);
        }
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    private boolean isHeader(String string) {
        return string.indexOf(58) == -1;
    }

    private void parseDocument(IDocument iDocument) {
        this.existedPropertis = new ColonDelimitedProperties();
        try {
            this.existedPropertis.load((Reader)new StringReader(iDocument.get()));
        }
        catch (IOException iOException) {}
        Iterator iterator = this.existedPropertis.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(MIDLET_PREFIX)) continue;
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string.substring(MIDLET_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {}
            if (n2 == -1 || n2 <= n) continue;
            n = n2;
        }
        this.midletHeader = MIDLET_PREFIX + (n + 1);
    }

    private ICompletionProposal[] sortProposals(ICompletionProposal[] iCompletionProposalArray) {
        Arrays.sort(iCompletionProposalArray, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal iCompletionProposal, ICompletionProposal iCompletionProposal2) {
                return iCompletionProposal.getDisplayString().compareTo(iCompletionProposal2.getDisplayString());
            }
        });
        return iCompletionProposalArray;
    }
}

