/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.PersistableUtilities;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.devices.DeviceEditorConfigElement;
import org.eclipse.mtj.ui.internal.devices.DeviceEditorRegistry;
import org.eclipse.mtj.ui.internal.devices.DeviceImportWizard;
import org.eclipse.mtj.ui.internal.devices.DeviceTableLabelProvider;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DeviceManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.deviceManagementPreferencePage";
    private static final String ALL_SDKS = MTJUIMessages.DeviceManagementPreferencePage_all_sdks;
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceManagementPreferencePage_default_columnInfo, 10.0f, null), new TableColumnInfo(MTJUIMessages.DeviceManagementPreferencePage_group_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceManagementPreferencePage_name_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceManagementPreferencePage_configuration_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceManagementPreferencePage_profile_columnInfo, 22.5f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 550;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final Pattern UNIQUE_NAME_PATTERN = Pattern.compile("^.+\\((\\d+)\\)$");
    private Button deleteButton;
    private CheckboxTableViewer deviceViewer;
    private Button duplicateButton;
    private IAction editAction;
    private Button editButton;
    private IActionDelegate editDelegate;
    private ComboViewer sdkViewer;
    private boolean updatingCheckState;
    private IWorkbench workbench;

    public DeviceManagementPreferencePage() {
        super(MTJUIMessages.DeviceManagementPreferencePage_title);
        this.setDescription(MTJUIMessages.DeviceManagementPreferencePage_description);
        this.noDefaultAndApplyButton();
        this.editAction = new Action(){};
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
    }

    public boolean performCancel() {
        this.performDefaults();
        return true;
    }

    public boolean performOk() {
        boolean bl = false;
        try {
            DeviceRegistry.singleton.store();
            bl = true;
        }
        catch (Exception exception) {
            MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_title, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_message, exception);
            MTJCorePlugin.log((int)4, (String)NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_log_msg, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()}), (Throwable)exception);
        }
        return bl;
    }

    private Control createDeviceContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 550;
        gridData.heightHint = 400;
        this.deviceViewer = this.createTableViewer(composite2);
        this.deviceViewer.getTable().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, true));
        composite3.setLayoutData((Object)new GridData(1040));
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText(MTJUIMessages.DeviceManagementPreferencePage_importButton_label_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.importDevices();
            }
        });
        this.editButton = new Button(composite3, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(MTJUIMessages.DeviceManagementPreferencePage_editButton_lable_text);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleEditButton();
            }
        });
        this.duplicateButton = new Button(composite3, 8);
        this.duplicateButton.setLayoutData((Object)new GridData(768));
        this.duplicateButton.setText(MTJUIMessages.DeviceManagementPreferencePage_duplicateButton_label_text);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleDuplicateButton();
            }
        });
        this.deleteButton = new Button(composite3, 8);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setText(MTJUIMessages.DeviceManagementPreferencePage_deleteButton_label_text);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceManagementPreferencePage.this.handleDeleteButton();
            }
        });
        this.updateButtonEnablement(this.deviceViewer.getSelection());
        this.updateCheckboxState();
        this.deviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DeviceManagementPreferencePage.this.updateButtonEnablement(selectionChangedEvent.getSelection());
            }
        });
        return composite2;
    }

    private Control createErrorContents(Composite composite, Exception exception) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        String string = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_reading_device_registry, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()});
        Text text = new Text(composite2, 2122);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(string);
        return composite2;
    }

    private void createSDKContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setFont(composite.getFont());
        label.setText(MTJUIMessages.DeviceManagementPreferencePage_instaled_sdks_label);
        this.sdkViewer = this.createSDKViewer(composite2);
    }

    private ComboViewer createSDKViewer(Composite composite) {
        ComboViewer comboViewer = new ComboViewer(composite);
        comboViewer.setContentProvider((IContentProvider)new SDKContentProvider());
        comboViewer.setInput(new Object());
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                String string = (String)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                DeviceManagementPreferencePage.this.deviceViewer.setInput((Object)string);
                DeviceManagementPreferencePage.this.updateCheckboxState();
            }
        });
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 300;
        comboViewer.getCombo().setLayoutData((Object)gridData);
        return comboViewer;
    }

    private CheckboxTableViewer createTableViewer(Composite composite) {
        int n = 68130;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        checkboxTableViewer.setContentProvider((IContentProvider)new DeviceTableContentProvider());
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new DeviceTableLabelProvider());
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                DeviceManagementPreferencePage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        checkboxTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                IDevice iDevice = (IDevice)iStructuredSelection.getFirstElement();
                DeviceManagementPreferencePage.this.editDevice(iDevice);
            }
        });
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("deviceManagementViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 550, COLUMN_INFO, 1);
        tableViewerConfiguration.configure((TableViewer)checkboxTableViewer);
        return checkboxTableViewer;
    }

    private void editDevice(IDevice iDevice) {
        if (this.editDelegate != null) {
            this.editDelegate.run(this.editAction);
            this.deviceViewer.refresh((Object)this.getSelectedDevice(), true);
        }
    }

    private IActionDelegate findActionDelegate(IDevice iDevice) {
        IActionDelegate iActionDelegate = null;
        DeviceEditorConfigElement deviceEditorConfigElement = DeviceEditorRegistry.findEditorElement(iDevice);
        if (deviceEditorConfigElement != null) {
            try {
                iActionDelegate = deviceEditorConfigElement.getActionDelegate();
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_findActionDelegate, (Throwable)coreException);
            }
        }
        return iActionDelegate;
    }

    private String findUniqueName(IDevice iDevice) {
        String string = null;
        String string2 = iDevice.getGroupName();
        String string3 = iDevice.getName();
        int n = 1;
        while (n <= 100) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            Matcher matcher = UNIQUE_NAME_PATTERN.matcher(stringBuffer);
            if (matcher.find()) {
                int n2 = matcher.start(1);
                int n3 = matcher.end(1);
                stringBuffer.replace(n2, n3, Integer.toString(n));
            } else {
                stringBuffer.append(" (").append(n).append(")");
            }
            string = stringBuffer.toString();
            try {
                IDevice iDevice2 = DeviceRegistry.singleton.getDevice(string2, string);
                if (iDevice2 == null) {
                    break;
                }
            }
            catch (PersistenceException persistenceException) {
                MTJCorePlugin.log((int)4, (String)MTJUIMessages.DeviceManagementPreferencePage_error_find_device, (Throwable)persistenceException);
            }
            ++n;
        }
        return string;
    }

    private IDevice getSelectedDevice() {
        return (IDevice)((IStructuredSelection)this.deviceViewer.getSelection()).getFirstElement();
    }

    private void handleCheckStateChange(CheckStateChangedEvent checkStateChangedEvent) {
        if (!this.updatingCheckState && checkStateChangedEvent.getChecked()) {
            IDevice iDevice = (IDevice)checkStateChangedEvent.getElement();
            DeviceRegistry.singleton.setDefaultDevice(iDevice);
            this.updateCheckboxState();
        }
    }

    private void handleDeleteButton() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.deviceViewer.getSelection();
        int n = iStructuredSelection.size();
        String string = MTJUIMessages.DeviceManagementPreferencePage_confirm_delete_dialog_title;
        String string2 = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_confirm_delet_dialog_message, (Object)n);
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)string, (String)string2)) {
            for (IDevice iDevice : iStructuredSelection) {
                try {
                    DeviceRegistry.singleton.removeDevice(iDevice);
                }
                catch (PersistenceException persistenceException) {
                    this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_remove_device, persistenceException);
                }
            }
            this.deviceViewer.refresh();
        }
    }

    private void handleDuplicateButton() {
        IDevice iDevice = this.getSelectedDevice();
        try {
            IDevice iDevice2 = (IDevice)PersistableUtilities.clonePersistable((IPersistable)iDevice);
            String string = this.findUniqueName(iDevice2);
            iDevice2.setName(string);
            DeviceRegistry.singleton.addDevice(iDevice2, true);
            this.deviceViewer.refresh();
            this.deviceViewer.setSelection((ISelection)new StructuredSelection((Object)iDevice2));
        }
        catch (Exception exception) {
            this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_duplicated_device, exception);
        }
    }

    private void handleEditButton() {
        IDevice iDevice = this.getSelectedDevice();
        this.editDevice(iDevice);
    }

    private void handleException(String string, Throwable throwable) {
        MTJCorePlugin.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_exception, (Throwable)throwable);
        MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_error, string, throwable);
    }

    private void importDevices() {
        DeviceImportWizard deviceImportWizard = new DeviceImportWizard();
        WizardDialog wizardDialog = new WizardDialog(this.workbench.getActiveWorkbenchWindow().getShell(), (IWizard)deviceImportWizard);
        if (wizardDialog.open() == 0) {
            IDevice iDevice;
            this.sdkViewer.refresh();
            this.deviceViewer.refresh();
            if (this.sdkViewer.getSelection().isEmpty()) {
                this.selectFirstSDK();
            }
            if ((iDevice = DeviceRegistry.singleton.getDefaultDevice()) == null) {
                this.selectStartingDefaultDevice();
                this.updateCheckboxState();
            }
        }
    }

    private void selectFirstSDK() {
        if (this.sdkViewer.getCombo().getItemCount() > 0) {
            this.sdkViewer.getCombo().select(0);
            this.deviceViewer.setInput((Object)this.sdkViewer.getCombo().getText());
            this.updateCheckboxState();
        }
    }

    private void selectStartingDefaultDevice() {
        DeviceTableContentProvider deviceTableContentProvider = (DeviceTableContentProvider)this.deviceViewer.getContentProvider();
        Object[] objectArray = deviceTableContentProvider.getElements(this.deviceViewer.getInput());
        if (objectArray != null && objectArray.length > 0) {
            DeviceRegistry.singleton.setDefaultDevice((IDevice)objectArray[0]);
        }
    }

    private void updateButtonEnablement(ISelection iSelection) {
        int n;
        IDevice iDevice = this.getSelectedDevice();
        IActionDelegate iActionDelegate = this.editDelegate = iDevice == null ? null : this.findActionDelegate(iDevice);
        if (this.editDelegate != null) {
            this.editDelegate.selectionChanged(this.editAction, iSelection);
        }
        this.duplicateButton.setEnabled((n = ((IStructuredSelection)this.deviceViewer.getSelection()).size()) == 1);
        this.editButton.setEnabled(this.editDelegate != null && this.editAction.isEnabled());
        this.deleteButton.setEnabled(n > 0);
    }

    private void updateCheckboxState() {
        this.updatingCheckState = true;
        this.deviceViewer.setAllChecked(false);
        IDevice iDevice = DeviceRegistry.singleton.getDefaultDevice();
        if (iDevice != null) {
            this.deviceViewer.setChecked((Object)iDevice, true);
        }
        this.updatingCheckState = false;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        try {
            DeviceRegistry.singleton.load();
            this.createSDKContents(composite2);
            this.createDeviceContents(composite2);
            this.selectFirstSDK();
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)4, (Throwable)exception);
            this.createErrorContents(composite2, exception);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.mtj.ui.help_DeviceManagementPage");
        return composite2;
    }

    protected void performDefaults() {
        try {
            DeviceRegistry.singleton.clear();
            DeviceRegistry.singleton.load();
        }
        catch (Exception exception) {
            MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceManagementPreferencePage_error_reloding_devices_dialog_title, MTJUIMessages.DeviceManagementPreferencePage_error_reloding_devices_dialog_message, exception);
            MTJCorePlugin.log((int)4, (String)MTJUIMessages.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_loading_devices, (Object[])new String[]{exception.getClass().getName(), exception.getMessage()}), (Throwable)exception);
        }
    }

    private class DeviceTableContentProvider
    implements IStructuredContentProvider {
        private DeviceTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            String string = (String)object;
            try {
                List list = ALL_SDKS.equalsIgnoreCase(string) ? DeviceRegistry.singleton.getAllDevices() : DeviceRegistry.singleton.getDevices(string);
                if (list != null) {
                    objectArray = list.toArray(new IDevice[list.size()]);
                }
            }
            catch (PersistenceException persistenceException) {
                DeviceManagementPreferencePage.this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_retrieving_devices, persistenceException);
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class SDKContentProvider
    implements IStructuredContentProvider {
        private SDKContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            try {
                List list = DeviceRegistry.singleton.getDeviceGroups();
                if (list != null && list.size() > 1) {
                    list.add(ALL_SDKS);
                }
                objectArray = list.toArray(new String[list.size()]);
            }
            catch (PersistenceException persistenceException) {
                DeviceManagementPreferencePage.this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_retrieving_groups, persistenceException);
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

