/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.refactoring;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.mtj.core.internal.refactoring.RefactoringMessages;
import org.eclipse.osgi.util.NLS;

public class JadLaunchConfigProjectRenameChange
extends Change {
    private ILaunchConfiguration launchConfiguration;
    private String newProjectName;

    public JadLaunchConfigProjectRenameChange(ILaunchConfiguration iLaunchConfiguration, String string) {
        this.launchConfiguration = iLaunchConfiguration;
        this.newProjectName = string;
    }

    public Object getModifiedElement() {
        return this.launchConfiguration;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.JadLaunchConfigProjectRenameChange_name, (Object)this.launchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor iProgressMonitor) {
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (!this.launchConfiguration.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringMessages.JadLaunchConfig_doNotExist, (Object)this.launchConfiguration.getName()));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = this.launchConfiguration.getWorkingCopy();
        String string = iLaunchConfigurationWorkingCopy.getAttribute("mtj.specified_jad_url", "");
        String string2 = this.getNewJadFileLocation(string, this.newProjectName);
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.specified_jad_url", string2);
        if (iLaunchConfigurationWorkingCopy.isDirty()) {
            iLaunchConfigurationWorkingCopy.doSave();
        }
        return null;
    }

    private String getNewJadFileLocation(String string, String string2) {
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getProject(string2).getLocation();
        Path path = new Path(string);
        IPath iPath2 = path.removeFirstSegments(iPath.segmentCount());
        IPath iPath3 = iPath.append(iPath2);
        return iPath3.toPortableString();
    }
}

