/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPrintHandler {
    public static final String XML_BEGIN_TAG = "<";
    public static final String XML_COMMENT_BEGIN_TAG = "<!--";
    public static final String XML_COMMENT_END_TAG = "-->";
    public static final String XML_DBL_QUOTES = "\"";
    public static final String XML_END_TAG = ">";
    public static final String XML_EQUAL = "=";
    public static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"";
    public static final String XML_HEAD_END_TAG = "?>";
    public static final String XML_INDENT = "   ";
    public static final String XML_SLASH = "/";
    public static final String XML_SPACE = " ";

    public static StringBuffer encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    public static String generateIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(XML_INDENT);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void printBeginElement(Writer writer, String string, String string2, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(XML_BEGIN_TAG);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(XML_SLASH);
        }
        stringBuffer.append(XML_END_TAG);
        stringBuffer.append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printComment(Writer writer, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(string2);
        stringBuffer.append(XML_COMMENT_BEGIN_TAG);
        stringBuffer.append(XMLPrintHandler.encode(string).toString()).append(XML_COMMENT_END_TAG).append("\n\n");
        writer.write(stringBuffer.toString());
    }

    public static void printEndElement(Writer writer, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(XML_BEGIN_TAG);
        stringBuffer.append(XML_SLASH).append(string).append(XML_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printHead(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_HEAD);
        stringBuffer.append(string).append(XML_DBL_QUOTES).append(XML_HEAD_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printNode(Writer writer, Node node, String string, String string2) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                XMLPrintHandler.printHead(writer, string);
                XMLPrintHandler.printNode(writer, ((Document)node).getDocumentElement(), string, string2);
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        Node node2 = namedNodeMap.item(n);
                        stringBuffer.append(XMLPrintHandler.wrapAttributeForPrint(node2.getNodeName(), node2.getNodeValue()));
                        ++n;
                    }
                }
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                XMLPrintHandler.printBeginElement(writer, stringBuffer.toString(), string2, n == 0);
                int n2 = 0;
                while (n2 < n) {
                    XMLPrintHandler.printNode(writer, nodeList.item(n2), string, String.valueOf(string2) + "\t");
                    ++n2;
                }
                if (n <= 0) break;
                XMLPrintHandler.printEndElement(writer, node.getNodeName(), string2);
                break;
            }
            case 3: {
                writer.write(XMLPrintHandler.encode(node.getNodeValue()).toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported XML Node Type.");
            }
        }
    }

    public static void printText(Writer writer, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(XMLPrintHandler.encode(string).toString());
        stringBuffer.append("\n");
        writer.write(stringBuffer.toString());
    }

    public static String wrapAttribute(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(XML_SPACE);
        stringBuffer.append(string);
        stringBuffer.append(XML_EQUAL);
        stringBuffer.append(XML_DBL_QUOTES);
        stringBuffer.append(string2);
        stringBuffer.append(XML_DBL_QUOTES);
        return stringBuffer.toString();
    }

    public static String wrapAttributeForPrint(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_SPACE);
        stringBuffer.append(string).append(XML_EQUAL).append(XML_DBL_QUOTES).append(XMLPrintHandler.encode(string2).toString()).append(XML_DBL_QUOTES);
        return stringBuffer.toString();
    }

    public static void writeFile(Document document, File file) throws IOException {
        Writer writer = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            XMLPrintHandler.printNode(writer, document, "UTF-8", "");
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {}
    }
}

