/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.IBaseModel;
import org.eclipse.mtj.core.model.IWritable;
import org.eclipse.mtj.internal.core.IWritableDelimiter;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormOutlinePage;
import org.eclipse.mtj.internal.ui.editor.IModelUndoManager;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJMultiPageContentOutline;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.MissingResourcePage;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.IInputContextListener;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.context.InputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nSourceOutlinePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class MTJFormEditor
extends FormEditor
implements IInputContextListener,
IGotoMarker,
ISearchEditorAccess {
    private static final String F_DIALOG_EDITOR_SECTION_KEY = "mtj-form-editor";
    private Clipboard clipboard;
    private MTJMultiPageContentOutline contentOutline;
    private Menu contextMenu;
    private MTJFormEditorChangeListener editorSelectionChangedListener;
    private boolean error;
    private ISortableContentOutlinePage formOutline;
    private String lastActivePageId;
    private boolean lastDirtyState;
    protected InputContextManager inputContextManager;

    public MTJFormEditor() {
        MTJUIPlugin.getDefault().getLabelProvider().connect(this);
        this.inputContextManager = this.createInputContextManager();
    }

    public boolean canCopy(ISelection iSelection) {
        if (iSelection == null) {
            return false;
        }
        if (iSelection instanceof IStructuredSelection) {
            return !iSelection.isEmpty();
        }
        if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getLength() > 0;
        }
        return false;
    }

    public boolean canCut(ISelection iSelection) {
        return this.canCopy(iSelection);
    }

    public boolean canPasteFromClipboard() {
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof MTJFormPage) {
            return ((MTJFormPage)iFormPage).canPaste(this.getClipboard());
        }
        return false;
    }

    public final void contextAdded(InputContext inputContext) {
        if (this.error) {
            this.removePage(0);
            this.addPages();
        } else {
            this.editorContextAdded(inputContext);
        }
    }

    public void contributeToToolbar(IToolBarManager iToolBarManager) {
    }

    public void dispose() {
        this.storeDefaultPage();
        if (this.editorSelectionChangedListener != null) {
            this.editorSelectionChangedListener.uninstall(this.getSite().getSelectionProvider());
            this.editorSelectionChangedListener = null;
        }
        this.setSelection((ISelection)new StructuredSelection());
        MTJUIPlugin.getDefault().getLabelProvider().disconnect(this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
        this.inputContextManager.dispose();
        this.inputContextManager = null;
    }

    public void doRevert() {
        boolean bl;
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage != null && iFormPage instanceof MTJFormPage) {
            iFormPage.getManagedForm().commit(true);
        }
        if (!(bl = this.doRevertSourcePages())) {
            bl = this.doRevertFormPage();
        }
        if (bl) {
            this.editorDirtyStateChanged();
        }
    }

    public void doRevert(IEditorInput iEditorInput) {
        InputContext inputContext;
        IFormPage iFormPage;
        IFormPage iFormPage2 = this.getActivePageInstance();
        if (iFormPage2 != null && iFormPage2 instanceof MTJFormPage) {
            ((MTJFormPage)iFormPage2).cancelEdit();
        }
        if ((iFormPage = this.findPage((inputContext = this.inputContextManager.getContext(iEditorInput)).getId())) != null && iFormPage instanceof MTJSourcePage) {
            MTJSourcePage mTJSourcePage = (MTJSourcePage)iFormPage;
            mTJSourcePage.doRevertToSaved();
        }
        this.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.commitPages(true);
        this.inputContextManager.save(iProgressMonitor);
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        try {
            String string = this.getContextIDForSaveAs();
            this.getContextManager().saveAs(this.getProgressMonitor(), string);
            IEditorInput iEditorInput = this.getContextManager().findContext(string).getInput();
            this.setInputWithNotify(iEditorInput);
            this.setPartName(iEditorInput.getName());
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            String string = MTJUIMessages.MTJFormEditor_doSaveAs_failed;
            if (exception.getMessage() != null) {
                string = String.valueOf(string) + ' ' + exception.getMessage();
            }
            MTJCorePlugin.log((int)4, (String)string, (Throwable)exception);
        }
    }

    public abstract void editorContextAdded(InputContext var1);

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        MTJFormEditorContributor mTJFormEditorContributor = this.getContributor();
        if (mTJFormEditorContributor != null) {
            mTJFormEditorContributor.updateActions();
        }
    }

    public void fireSaveNeeded(IEditorInput iEditorInput, boolean bl) {
        if (bl) {
            this.editorDirtyStateChanged();
        }
        if (this.isDirty()) {
            this.validateEdit(iEditorInput);
        }
    }

    public void fireSaveNeeded(String string, boolean bl) {
        if (string == null) {
            return;
        }
        InputContext inputContext = this.inputContextManager.findContext(string);
        if (inputContext != null) {
            this.fireSaveNeeded(inputContext.getInput(), bl);
        }
    }

    public void flushEdits() {
        IFormPage[] iFormPageArray = this.getPages();
        IManagedForm iManagedForm = iFormPageArray[this.getActivePage()].getManagedForm();
        if (iManagedForm != null) {
            iManagedForm.commit(false);
        }
        IFormPage[] iFormPageArray2 = iFormPageArray;
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage iFormPage = iFormPageArray2[n2];
            if (iFormPage instanceof MTJSourcePage) {
                MTJSourcePage mTJSourcePage = (MTJSourcePage)iFormPage;
                mTJSourcePage.getInputContext().flushEditorInput();
            }
            ++n2;
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        if (clazz.equals(IGotoMarker.class)) {
            return this;
        }
        if (clazz.equals(ISearchEditorAccess.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public IBaseModel getAggregateModel() {
        if (this.inputContextManager != null) {
            return this.inputContextManager.getAggregateModel();
        }
        return null;
    }

    public IAnnotationModel getAnnotationModel(Match match) {
        InputContext inputContext = this.getInputContext(match.getElement());
        return inputContext == null ? null : inputContext.getDocumentProvider().getAnnotationModel((Object)inputContext.getInput());
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public IProject getCommonProject() {
        return this.inputContextManager.getCommonProject();
    }

    public MTJMultiPageContentOutline getContentOutline() {
        if (this.contentOutline == null || this.contentOutline.isDisposed()) {
            this.contentOutline = new MTJMultiPageContentOutline(this);
            this.updateContentOutline(this.getActivePageInstance());
        }
        return this.contentOutline;
    }

    public String getContextIDForSaveAs() {
        return null;
    }

    public InputContextManager getContextManager() {
        return this.inputContextManager;
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public MTJFormEditorContributor getContributor() {
        return (MTJFormEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    public IDocument getDocument(Match match) {
        InputContext inputContext = this.getInputContext(match.getElement());
        return inputContext == null ? null : inputContext.getDocumentProvider().getDocument((Object)inputContext.getInput());
    }

    public boolean getLastDirtyState() {
        return this.lastDirtyState;
    }

    public ISelection getSelection() {
        return this.getSite().getSelectionProvider().getSelection();
    }

    public String getTitle() {
        if (this.inputContextManager == null) {
            return super.getTitle();
        }
        InputContext inputContext = this.inputContextManager.getPrimaryContext();
        if (inputContext == null) {
            return super.getTitle();
        }
        return inputContext.getInput().getName();
    }

    public String getTitleProperty() {
        return "";
    }

    public void gotoMarker(IMarker iMarker) {
        IResource iResource = iMarker.getResource();
        InputContext inputContext = this.inputContextManager.findContext(iResource);
        if (inputContext == null) {
            return;
        }
        IFormPage iFormPage = this.getActivePageInstance();
        if (!inputContext.getId().equals(iFormPage.getId())) {
            iFormPage = this.setActivePage(inputContext.getId());
        }
        IDE.gotoMarker((IEditorPart)iFormPage, (IMarker)iMarker);
    }

    public boolean hasInputContext(String string) {
        return this.inputContextManager.hasContext(string);
    }

    public boolean isDirty() {
        this.lastDirtyState = this.computeDirtyState();
        return this.lastDirtyState;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void openToSourcePage(Object object, int n, int n2) {
        MTJSourcePage mTJSourcePage;
        InputContext inputContext = null;
        inputContext = object instanceof InputContext ? (InputContext)object : this.getInputContext(object);
        if (inputContext != null && (mTJSourcePage = (MTJSourcePage)this.setActivePage(inputContext.getId())) != null) {
            mTJSourcePage.selectAndReveal(n, n2);
        }
    }

    public IFormPage setActivePage(String string) {
        IFormPage iFormPage = super.setActivePage(string);
        if (iFormPage != null) {
            this.updateContentOutline(iFormPage);
        }
        return iFormPage;
    }

    public void setFocus() {
        super.setFocus();
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage != null && iFormPage instanceof MTJFormPage) {
            ((MTJFormPage)iFormPage).updateFormSelection();
        }
    }

    public void setSelection(ISelection iSelection) {
        this.getSite().getSelectionProvider().setSelection(iSelection);
        this.getContributor().updateSelectableActions(iSelection);
    }

    public void synchronizeOutlinePage() {
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof MTJSourcePage) {
            ((MTJSourcePage)iFormPage).synchronizeOutlinePage();
        } else if (this.getFormOutline() != null) {
            this.getFormOutline().setSelection(this.getSelection());
        }
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    private boolean computeDirtyState() {
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage != null && iFormPage.isDirty() || this.inputContextManager != null && this.inputContextManager.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    private void copyToClipboard(ISelection iSelection) {
        Object object;
        Object[] objectArray;
        Object[] objectArray2 = null;
        String string = null;
        if (iSelection instanceof IStructuredSelection) {
            objectArray = (Object[])iSelection;
            if (objectArray == null || objectArray.size() == 0) {
                return;
            }
            objectArray2 = objectArray.toArray();
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            Class<?> clazz = null;
            int n = 0;
            while (n < objectArray2.length) {
                Object object2 = objectArray2[n];
                if (clazz == null) {
                    clazz = object2.getClass();
                } else if (!clazz.equals(object2.getClass())) {
                    return;
                }
                if (object2 instanceof IWritable) {
                    if (n != 0 && object2 instanceof IWritableDelimiter) {
                        ((IWritableDelimiter)object2).writeDelimeter(printWriter);
                    }
                    ((IWritable)object2).write("", printWriter);
                } else if (object2 instanceof String) {
                    printWriter.println((String)object2);
                }
                ++n;
            }
            printWriter.flush();
            string = ((StringWriter)object).toString();
            try {
                printWriter.close();
                ((StringWriter)object).close();
            }
            catch (IOException iOException) {}
        } else if (iSelection instanceof ITextSelection) {
            string = ((ITextSelection)iSelection).getText();
        }
        if ((string == null || string.length() == 0) && objectArray2 == null) {
            return;
        }
        objectArray = null;
        object = null;
        if (objectArray2 == null) {
            objectArray = new Object[]{string};
            object = new Transfer[]{TextTransfer.getInstance()};
        } else if (string == null || string.length() == 0) {
            objectArray = new Object[]{objectArray2};
            object = new Transfer[]{ModelDataTransfer.getInstance()};
        } else {
            objectArray = new Object[]{objectArray2, string};
            object = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        }
        this.clipboard.setContents(objectArray, (Transfer[])object);
    }

    private boolean doRevertFormPage() {
        return false;
    }

    private boolean doRevertSourcePages() {
        IFormPage[] iFormPageArray;
        boolean bl = false;
        IFormPage[] iFormPageArray2 = iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage iFormPage = iFormPageArray2[n2];
            if (iFormPage instanceof MTJSourcePage) {
                MTJSourcePage mTJSourcePage = (MTJSourcePage)iFormPage;
                mTJSourcePage.getInputContext().flushEditorInput();
                mTJSourcePage.doRevertToSaved();
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    private String getFirstInvalidContextId() {
        InputContext[] inputContextArray = this.inputContextManager.getInvalidContexts();
        if (inputContextArray.length == 0) {
            return null;
        }
        InputContext[] inputContextArray2 = inputContextArray;
        int n = inputContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputContext inputContext = inputContextArray2[n2];
            if (inputContext.isPrimary()) {
                return inputContext.getId();
            }
            ++n2;
        }
        return inputContextArray[0].getId();
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings iDialogSettings = MTJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(F_DIALOG_EDITOR_SECTION_KEY);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(F_DIALOG_EDITOR_SECTION_KEY);
        }
        return iDialogSettings2;
    }

    private String loadDefaultPage() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            return this.getPropertyEditorPageKey((IFileEditorInput)iEditorInput);
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            return this.getDialogEditorPageKey();
        }
        return null;
    }

    private void storeDefaultPage() {
        IEditorInput iEditorInput = this.getEditorInput();
        String string = this.lastActivePageId;
        if (string == null) {
            return;
        }
        if (iEditorInput instanceof IFileEditorInput) {
            this.setPropertyEditorPageKey((IFileEditorInput)iEditorInput, string);
        } else if (iEditorInput instanceof IStorageEditorInput) {
            this.setDialogEditorPageKey(string);
        }
    }

    private void updateContentOutline(IFormPage iFormPage) {
        if (this.contentOutline == null) {
            return;
        }
        ISortableContentOutlinePage iSortableContentOutlinePage = null;
        if (iFormPage instanceof MTJSourcePage) {
            iSortableContentOutlinePage = ((MTJSourcePage)iFormPage).getContentOutline();
            if (iSortableContentOutlinePage != null && iSortableContentOutlinePage instanceof L10nSourceOutlinePage) {
                ((L10nSourceOutlinePage)iSortableContentOutlinePage).refresh();
            }
        } else {
            iSortableContentOutlinePage = this.getFormOutline();
            if (iSortableContentOutlinePage != null && iSortableContentOutlinePage instanceof FormOutlinePage) {
                ((FormOutlinePage)iSortableContentOutlinePage).refresh();
            }
        }
        this.contentOutline.setPageActive(iSortableContentOutlinePage);
    }

    private void validateEdit(IEditorInput iEditorInput) {
        final InputContext inputContext = this.inputContextManager.getContext(iEditorInput);
        if (!inputContext.validateEdit()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MTJFormEditor.this.doRevert(inputContext.getInput());
                    inputContext.setValidated(false);
                }
            });
        }
    }

    protected abstract void addEditorPages();

    protected final void addPages() {
        boolean bl = this.error = this.getAggregateModel() == null;
        if (this.error) {
            try {
                this.addPage((IFormPage)new MissingResourcePage(this));
            }
            catch (PartInitException partInitException) {
                MTJCorePlugin.log((int)4, (Throwable)partInitException);
            }
        } else {
            this.addEditorPages();
        }
    }

    protected String computeInitialPageId() {
        String string;
        String string2 = null;
        String string3 = this.loadDefaultPage();
        if (string3 != null) {
            string2 = string3;
        }
        if ((string = this.getFirstInvalidContextId()) != null) {
            return string;
        }
        return string2;
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        MTJFormEditorContributor mTJFormEditorContributor = this.getContributor();
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof MTJFormPage) {
            ((MTJFormPage)iFormPage).contextMenuAboutToShow(iMenuManager);
        }
        if (mTJFormEditorContributor != null) {
            mTJFormEditorContributor.contextMenuAboutToShow(iMenuManager);
        }
    }

    protected abstract ISortableContentOutlinePage createContentOutline();

    protected abstract InputContextManager createInputContextManager();

    protected void createInputContexts(InputContextManager inputContextManager) {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            this.createResourceContexts(inputContextManager, (IFileEditorInput)iEditorInput);
        } else if (iEditorInput instanceof SystemFileEditorInput) {
            this.createSystemFileContexts(inputContextManager, (SystemFileEditorInput)iEditorInput);
        } else if (iEditorInput instanceof IStorageEditorInput) {
            this.createStorageContexts(inputContextManager, (IStorageEditorInput)iEditorInput);
        } else if (iEditorInput instanceof IURIEditorInput) {
            Object object;
            IURIEditorInput iURIEditorInput = (IURIEditorInput)iEditorInput;
            try {
                object = EFS.getStore((URI)iURIEditorInput.getURI());
                if (!"file".equals(object.getFileSystem().getScheme())) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            object = new File(iURIEditorInput.getURI());
            SystemFileEditorInput systemFileEditorInput = new SystemFileEditorInput((File)object);
            this.createSystemFileContexts(inputContextManager, systemFileEditorInput);
        }
    }

    protected void createPages() {
        this.clipboard = new Clipboard(this.getContainer().getDisplay());
        MenuManager menuManager = new MenuManager();
        IMenuListener iMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MTJFormEditor.this.contextMenuAboutToShow(iMenuManager);
            }
        };
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        this.contextMenu = menuManager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(this.contextMenu);
        this.createInputContexts(this.inputContextManager);
        super.createPages();
        this.inputContextManager.addInputContextListener(this);
        String string = this.computeInitialPageId();
        if (string != null) {
            this.setActivePage(string);
        }
        this.updateTitle();
    }

    protected abstract void createResourceContexts(InputContextManager var1, IFileEditorInput var2);

    protected IEditorSite createSite(IEditorPart iEditorPart) {
        return new MTJMultiPageEditorSite((MultiPageEditorPart)this, iEditorPart);
    }

    protected abstract void createStorageContexts(InputContextManager var1, IStorageEditorInput var2);

    protected abstract void createSystemFileContexts(InputContextManager var1, SystemFileEditorInput var2);

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(MTJUIPlugin.getDefault().getFormColors(display));
    }

    protected String getDialogEditorPageKey() {
        IDialogSettings iDialogSettings = this.getSettingsSection();
        return iDialogSettings.get(this.getEditorID());
    }

    protected abstract String getEditorID();

    protected ISortableContentOutlinePage getFormOutline() {
        if (this.formOutline == null) {
            this.formOutline = this.createContentOutline();
            if (this.formOutline != null) {
                this.editorSelectionChangedListener = new MTJFormEditorChangeListener();
                this.editorSelectionChangedListener.install(this.getSite().getSelectionProvider());
            }
        }
        return this.formOutline;
    }

    protected abstract InputContext getInputContext(Object var1);

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor iProgressMonitor = null;
        IStatusLineManager iStatusLineManager = this.getStatusLineManager();
        if (iStatusLineManager != null) {
            iProgressMonitor = iStatusLineManager.getProgressMonitor();
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        return iProgressMonitor;
    }

    protected String getPropertyEditorPageKey(IFileEditorInput iFileEditorInput) {
        IFile iFile = iFileEditorInput.getFile();
        try {
            return iFile.getPersistentProperty(IMTJUIConstants.PROPERTY_EDITOR_PAGE_KEY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        IFormPage iFormPage = this.getActivePageInstance();
        this.updateContentOutline(iFormPage);
        if (iFormPage != null) {
            this.lastActivePageId = iFormPage.getId();
        }
    }

    protected void performGlobalAction(String string) {
        IFormPage iFormPage;
        ISelection iSelection = this.getSelection();
        boolean bl = ((MTJFormPage)this.getActivePageInstance()).performGlobalAction(string);
        if (!bl && (iFormPage = this.getActivePageInstance()) instanceof MTJFormPage) {
            if (string.equals(ActionFactory.UNDO.getId())) {
                this.inputContextManager.undo();
                return;
            }
            if (string.equals(ActionFactory.REDO.getId())) {
                this.inputContextManager.redo();
                return;
            }
            if (string.equals(ActionFactory.CUT.getId()) || string.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(iSelection);
                return;
            }
        }
    }

    protected void setDialogEditorPageKey(String string) {
        IDialogSettings iDialogSettings = this.getSettingsSection();
        iDialogSettings.put(this.getEditorID(), string);
    }

    protected void setPropertyEditorPageKey(IFileEditorInput iFileEditorInput, String string) {
        IFile iFile = iFileEditorInput.getFile();
        try {
            iFile.setPersistentProperty(IMTJUIConstants.PROPERTY_EDITOR_PAGE_KEY, string);
        }
        catch (CoreException coreException) {}
    }

    IFormPage[] getPages() {
        ArrayList<IFormPage> arrayList = new ArrayList<IFormPage>();
        int n = 0;
        while (n < this.pages.size()) {
            Object e = this.pages.get(n);
            if (e instanceof IFormPage) {
                arrayList.add((IFormPage)e);
            }
            ++n;
        }
        return arrayList.toArray(new IFormPage[arrayList.size()]);
    }

    void updateUndo(IAction iAction, IAction iAction2) {
        IModelUndoManager iModelUndoManager = this.inputContextManager.getUndoManager();
        if (iModelUndoManager != null) {
            iModelUndoManager.setActions(iAction, iAction2);
        }
    }

    public class MTJFormEditorChangeListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider == null) {
                return;
            }
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                iPostSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked") && MTJFormEditor.this.getFormOutline() != null) {
                MTJFormEditor.this.getFormOutline().setSelection(selectionChangedEvent.getSelection());
            }
        }

        public void uninstall(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider == null) {
                return;
            }
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                iPostSelectionProvider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private static class MTJMultiPageEditorSite
    extends MultiPageEditorSite {
        public MTJMultiPageEditorSite(MultiPageEditorPart multiPageEditorPart, IEditorPart iEditorPart) {
            super(multiPageEditorPart, iEditorPart);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            MTJFormEditor mTJFormEditor = (MTJFormEditor)this.getMultiPageEditor();
            MTJFormEditorContributor mTJFormEditorContributor = mTJFormEditor.getContributor();
            return mTJFormEditorContributor.getSourceContributor();
        }

        public IWorkbenchPart getPart() {
            return this.getMultiPageEditor();
        }
    }
}

