/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.IMTJColorConstants;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager,
IMTJColorConstants {
    private static int counter = 0;
    private static ColorManager fColorManager;
    private Map<String, Color> fColorTable = new HashMap<String, Color>(5);

    public static IColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new ColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(IPreferenceStore iPreferenceStore) {
        boolean bl = false;
        try {
            bl = Display.getDefault().getHighContrast();
        }
        catch (SWTException sWTException) {}
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"editor.color.default", (RGB)(bl ? DEFAULT_HIGH_CONTRAST : DEFAULT));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"editor.color.instr", (RGB)PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"editor.color.string", (RGB)STRING);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"editor.color.tag", (RGB)TAG);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"editor.color.xml_comment", (RGB)XML_COMMENT);
    }

    public ColorManager() {
        this.initialize();
    }

    public void dispose() {
        if (--counter == 0) {
            this.disposeColors(true);
        }
    }

    public void disposeColors(boolean bl) {
        Iterator<Color> iterator = this.fColorTable.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        if (bl) {
            fColorManager = null;
        }
    }

    public Color getColor(String string) {
        Color color = this.fColorTable.get(string);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            this.putColor(propertyChangeEvent.getProperty(), (RGB)object);
        } else {
            this.putColor(propertyChangeEvent.getProperty(), StringConverter.asRGB((String)object.toString()));
        }
    }

    private void initialize() {
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        this.putColor(iPreferenceStore, "editor.color.default");
        this.putColor(iPreferenceStore, "editor.color.instr");
        this.putColor(iPreferenceStore, "editor.color.string");
        this.putColor(iPreferenceStore, "editor.color.tag");
        this.putColor(iPreferenceStore, "editor.color.xml_comment");
        iPreferenceStore = PreferenceConstants.getPreferenceStore();
        String[] stringArray = IColorManager.PROPERTIES_COLORS;
        int n = IColorManager.PROPERTIES_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.putColor(iPreferenceStore, string);
            ++n2;
        }
    }

    private void putColor(IPreferenceStore iPreferenceStore, String string) {
        this.putColor(string, PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string));
    }

    private void putColor(String string, RGB rGB) {
        Color color = this.fColorTable.get(string);
        if (color != null) {
            if (color.getRGB().equals((Object)rGB)) {
                return;
            }
            color.dispose();
        }
        this.fColorTable.put(string, new Color((Device)Display.getCurrent(), rGB));
    }
}

