/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.devices;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.devices.DeviceImportWizardPage;

public class DeviceImportWizard
extends Wizard {
    private DeviceImportWizardPage wizardPage;

    public DeviceImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MTJUIMessages.DeviceImportWizard_title);
        this.setDialogSettings(MTJUIPlugin.getDialogSettings(((Object)((Object)this)).getClass().getName()));
    }

    public void addPages() {
        this.wizardPage = new DeviceImportWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        boolean bl = false;
        IDevice[] iDeviceArray = this.wizardPage.getSelectedDevices();
        int n = 0;
        while (n < iDeviceArray.length) {
            IDevice iDevice = iDeviceArray[n];
            try {
                DeviceRegistry.singleton.addDevice(iDevice, true);
                bl = true;
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)2, (String)MTJUIMessages.DeviceImportWizard_error_adding_new_device, (Throwable)exception);
                MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceImportWizard_erro_dialog_title, MTJUIMessages.DeviceImportWizard_error_dialog_message, exception);
            }
            ++n;
        }
        return bl;
    }
}

