/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.signing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.MTJCoreErrors;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.signing.Base64EncDec;
import org.eclipse.mtj.core.internal.signing.KeyChainSet;
import org.eclipse.mtj.core.model.jad.IJadSignature;

public class JadSignature
implements IJadSignature {
    private KeyChainSet m_keyChainSet;
    private byte[] m_buffer;
    private String m_strJarSignature;
    private String[] m_strCertificates;
    private static final int BUFFER_SIZE = 4096;

    public JadSignature() {
    }

    public JadSignature(KeyChainSet keyChainSet) {
        this.setKeyChainSet(keyChainSet);
    }

    public void setKeyChainSet(KeyChainSet keyChainSet) {
        this.m_keyChainSet = keyChainSet;
    }

    public KeyChainSet getKeyChainSet() {
        return this.m_keyChainSet;
    }

    public String getJarSignatureString() {
        return this.m_strJarSignature;
    }

    public String[] getCertificateStrings() {
        return this.m_strCertificates;
    }

    public void computeSignature(File file) throws CoreException {
        block23: {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    this.computeSignature(bufferedInputStream);
                }
                catch (Exception exception) {
                    MTJCorePlugin.throwCoreException(4, 9999, exception);
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void computeSignature(InputStream inputStream) throws CoreException, IOException {
        this.checkKeyChainSet();
        X509Certificate[] x509CertificateArray = this.m_keyChainSet.getCertificateChain();
        PrivateKey privateKey = this.m_keyChainSet.getKey();
        if (this.m_buffer == null) {
            this.m_buffer = new byte[4096];
        }
        try {
            int n;
            this.m_strCertificates = new String[x509CertificateArray.length];
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                byte[] byArray = x509CertificateArray[n2].getEncoded();
                this.m_strCertificates[n2] = Base64EncDec.encode(byArray);
                ++n2;
            }
            Signature signature = this.m_keyChainSet.getProvider() == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", this.m_keyChainSet.getProvider());
            signature.initSign(privateKey);
            while ((n = inputStream.read(this.m_buffer)) >= 0) {
                signature.update(this.m_buffer, 0, n);
            }
            byte[] byArray = signature.sign();
            this.m_strJarSignature = Base64EncDec.encode(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MTJCoreErrors.throwCoreExceptionError(10012, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            MTJCoreErrors.throwCoreExceptionError(10003, noSuchProviderException);
        }
        catch (InvalidKeyException invalidKeyException) {
            MTJCoreErrors.throwCoreExceptionError(10011, invalidKeyException);
        }
        catch (SignatureException signatureException) {
            MTJCoreErrors.throwCoreExceptionError(10013, signatureException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            MTJCoreErrors.throwCoreExceptionError(10014, certificateEncodingException);
        }
    }

    public void checkKeyChainSet() throws CoreException {
        PrivateKey privateKey;
        String string;
        X509Certificate[] x509CertificateArray;
        if (this.m_keyChainSet == null) {
            MTJCoreErrors.throwCoreExceptionError(90001);
        }
        if ((x509CertificateArray = this.m_keyChainSet.getCertificateChain()) == null) {
            MTJCoreErrors.throwCoreExceptionError(10010);
        }
        if (!"RSA".equals(string = (privateKey = this.m_keyChainSet.getKey()).getAlgorithm())) {
            MTJCoreErrors.throwCoreExceptionError(10008);
        }
    }
}

