/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.importer;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.mtj.core.model.library.ILibrary;

public class JavadocDetector {
    ArrayList<IJavadocSearchStrategy> searchStrategies = new ArrayList();

    public JavadocDetector addJavadocSearchStrategy(IJavadocSearchStrategy iJavadocSearchStrategy) {
        this.searchStrategies.add(iJavadocSearchStrategy);
        return this;
    }

    public URL detectJavadoc(ILibrary iLibrary) {
        URL uRL = null;
        for (IJavadocSearchStrategy iJavadocSearchStrategy : this.searchStrategies) {
            uRL = iJavadocSearchStrategy.searchForJavaDoc(iLibrary);
            if (uRL != null) break;
        }
        return uRL;
    }

    public static class GenericLocalFSSearch
    implements IJavadocSearchStrategy {
        public static final String[] PROFILEJAVADOCDIRECTORIES = new String[]{"midp", "jsr118"};
        public static final int DEFAULTSEARCHDEPTH = 5;
        private File[] docRootDirectories = null;

        public GenericLocalFSSearch() {
        }

        public GenericLocalFSSearch(String string) {
            this(new String[]{string});
        }

        public GenericLocalFSSearch(String[] stringArray) {
            if (stringArray != null) {
                this.docRootDirectories = new File[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    this.docRootDirectories[n] = new File(stringArray[n]);
                    ++n;
                }
            }
        }

        public URL searchForJavaDoc(ILibrary iLibrary) {
            URL uRL = null;
            File[] fileArray = this.getDocRootDirectories(iLibrary);
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    uRL = this.searchForLibraryDoc(file, iLibrary);
                    if (uRL != null) break;
                    ++n2;
                }
            }
            return uRL;
        }

        private URL searchForLibraryDoc(File file, final ILibrary iLibrary) {
            String string = iLibrary.toFile().getName();
            int n = string.lastIndexOf(46);
            final String string2 = n > -1 ? string.substring(0, n) : string;
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    boolean bl = false;
                    boolean bl2 = bl = file.getName().startsWith(string2) || string2.startsWith(file.getName());
                    if (!bl && (iLibrary.hasConfiguration() || iLibrary.hasProfile())) {
                        int n = 0;
                        while (n < PROFILEJAVADOCDIRECTORIES.length) {
                            if (file.getName().startsWith(PROFILEJAVADOCDIRECTORIES[n])) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                    }
                    return bl;
                }
            });
            if (fileArray != null && fileArray.length > 0) {
                try {
                    return fileArray[0].toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else {
                int n2 = 0;
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                });
                if (n2 < fileArray2.length) {
                    return this.searchForLibraryDoc(fileArray2[n2], iLibrary);
                }
            }
            return null;
        }

        public File[] getDocRootDirectories(ILibrary iLibrary) {
            if (this.docRootDirectories == null) {
                this.docRootDirectories = this.getDefaultDocRootDirectories(iLibrary);
            }
            return this.docRootDirectories;
        }

        public File[] getDefaultDocRootDirectories(ILibrary iLibrary) {
            if (iLibrary == null) {
                return null;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            File file = iLibrary.toFile().getParentFile();
            int n = 0;
            while (n < 5 && file != null) {
                File[] fileArray;
                File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().indexOf("doc") != -1;
                    }
                });
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file2 = fileArray2[n3];
                    arrayList.add(file2);
                    ++n3;
                }
                file = file.getParentFile();
                ++n;
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new File[0]);
            }
            return null;
        }
    }

    public static interface IJavadocSearchStrategy {
        public URL searchForJavaDoc(ILibrary var1);
    }
}

