/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class Classpath
implements IPersistable {
    private ArrayList<IPersistable> entries = new ArrayList();

    public void addEntry(ILibrary iLibrary) {
        this.entries.add(iLibrary);
    }

    public IClasspathEntry[] asClasspathEntries() {
        ILibrary[] iLibraryArray = this.getEntries();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[iLibraryArray.length];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            iClasspathEntryArray[n] = iLibraryArray[n].toClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    public File[] asFileArray() {
        ILibrary[] iLibraryArray = this.getEntries();
        File[] fileArray = new File[iLibraryArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = iLibraryArray[n].toFile();
            ++n;
        }
        return fileArray;
    }

    public File[] asSkeletonFileArray() {
        URL[] uRLArray = this.asSkeletonURLArray();
        ArrayList<File> arrayList = new ArrayList<File>(uRLArray.length);
        int n = 0;
        while (n < uRLArray.length) {
            try {
                URL uRL = FileLocator.toFileURL((URL)uRLArray[n]);
                arrayList.add(new File(uRL.getPath()));
            }
            catch (IOException iOException) {
                MTJCorePlugin.log(2, iOException);
            }
            ++n;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public URL[] asSkeletonURLArray() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ILibrary[] iLibraryArray = this.getEntries();
        int n = 0;
        while (n < iLibraryArray.length) {
            ILibrary iLibrary = iLibraryArray[n];
            API[] aPIArray = iLibrary.getAPIs();
            int n2 = 0;
            while (n2 < aPIArray.length) {
                API aPI = aPIArray[n2];
                URL[] uRLArray = aPI.getSkeletonReplacements();
                if (uRLArray == null) {
                    arrayList.add(iLibrary.toFile());
                } else {
                    int n3 = 0;
                    while (n3 < uRLArray.length) {
                        arrayList.add(uRLArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public URL[] asURLArray() {
        ILibrary[] iLibraryArray = this.getEntries();
        URL[] uRLArray = new URL[iLibraryArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            uRLArray[n] = iLibraryArray[n].toURL();
            ++n;
        }
        return uRLArray;
    }

    public boolean equals(Classpath classpath) {
        ILibrary[] iLibraryArray;
        ILibrary[] iLibraryArray2 = this.getEntries();
        boolean bl = iLibraryArray2.length == (iLibraryArray = classpath.getEntries()).length;
        int n = 0;
        while (bl && n < iLibraryArray2.length) {
            bl = iLibraryArray2[n].equals(iLibraryArray[n]);
            ++n;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Classpath) {
            bl = this.equals((Classpath)object);
        }
        return bl;
    }

    public ILibrary[] getEntries() {
        return this.entries.toArray(new ILibrary[this.entries.size()]);
    }

    public int hashCode() {
        ILibrary[] iLibraryArray = this.getEntries();
        int n = iLibraryArray.length << 24;
        int n2 = 0;
        while (n2 < iLibraryArray.length) {
            n ^= iLibraryArray[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.entries.clear();
        int n = iPersistenceProvider.loadInteger("entryCount");
        int n2 = 0;
        while (n2 < n) {
            this.entries.add(iPersistenceProvider.loadPersistable("entry" + n2));
            ++n2;
        }
    }

    public void removeEntry(ILibrary iLibrary) {
        this.entries.remove(iLibrary);
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeInteger("entryCount", this.entries.size());
        int n = 0;
        for (ILibrary iLibrary : this.entries) {
            iPersistenceProvider.storePersistable("entry" + n++, iLibrary);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ILibrary[] iLibraryArray = this.getEntries();
        int n = 0;
        while (n < iLibraryArray.length) {
            if (n != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iLibraryArray[n].toFile());
            ++n;
        }
        return stringBuffer.toString();
    }
}

