/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.IMidletSuiteProjectListener;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.devices.DeviceSelector;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.actions.exporting.AntennaBuildExportAction;
import org.eclipse.mtj.ui.internal.actions.packaging.CreateObfuscatedPackageAction;
import org.eclipse.mtj.ui.internal.actions.packaging.CreatePackageAction;
import org.eclipse.mtj.ui.internal.editors.EditorsUIContent;
import org.eclipse.mtj.ui.internal.editors.FormLayoutFactory;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.preferences.ExtendedStringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class OverviewEditorPage
extends JADPropertiesEditorPage
implements IPropertyChangeListener {
    private static final String OVERVIEW_PAGEID = "overview";
    private DeviceSelector deviceSelector;
    private Display display = null;
    private IJavaProject project = JavaCore.create((IProject)((JADFormEditor)this.getEditor()).getJadFile().getProject());
    private String loadedJarUrl;
    private IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.project);

    public OverviewEditorPage(JADFormEditor jADFormEditor) {
        super(jADFormEditor, OVERVIEW_PAGEID, MTJUIStrings.getString("editor.jad.tab.overview"));
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        String string = this.getPreferenceStore().getString("MIDlet-Jar-URL");
        if (!string.equals(this.loadedJarUrl)) {
            ((JADFormEditor)this.getEditor()).setCleanRequired(true);
        }
        if (this.midletProject != null && this.deviceSelector.getSelectedDevice() != null) {
            try {
                this.midletProject.setDevice(this.deviceSelector.getSelectedDevice(), iProgressMonitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    public String getTitle() {
        return MTJUIStrings.getString("editor.jad.tab.overview");
    }

    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        String string = (String)hyperlinkEvent.getHref();
        IWorkbenchPart iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (string.equals("package")) {
            new CreatePackageAction().run(this.project, iWorkbenchPart);
        } else if (string.equals("obfuscate")) {
            new CreateObfuscatedPackageAction().run(this.project, iWorkbenchPart);
        } else if (string.equals("antenna")) {
            new AntennaBuildExportAction().run(this.project, iWorkbenchPart);
        } else if (string.startsWith("launchShortcut.")) {
            this.handleLaunchShortcut(string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
            if (propertyChangeEvent.getSource() instanceof ExtendedStringFieldEditor) {
                String string = ((FieldEditor)propertyChangeEvent.getSource()).getLabelText();
                Text text = ((ExtendedStringFieldEditor)((Object)propertyChangeEvent.getSource())).getFieldEditorTextControl();
                if (propertyChangeEvent.getNewValue().equals("")) {
                    this.getErrorMessageManager().addMessage((Object)("textLength_" + string), " field must not be empty.", null, 3, (Control)text);
                } else {
                    this.getErrorMessageManager().removeMessage((Object)("textLength_" + string), (Control)text);
                }
            }
            this.setDirty(true);
        }
    }

    private void addMidletProjectChangeListener() {
        this.midletProject.addMidletSuiteProjectListener(new IMidletSuiteProjectListener(){

            public void deployedJarFileUpToDateFlagChanged() {
            }

            public void deviceChanded() {
                if (OverviewEditorPage.this.display != null) {
                    OverviewEditorPage.this.display.asyncExec(new Runnable(){

                        public void run() {
                            if (OverviewEditorPage.this.deviceSelector != null) {
                                OverviewEditorPage.this.deviceSelector.enableFireSelectionChanged(false);
                                OverviewEditorPage.this.deviceSelector.setSelectedDevice(OverviewEditorPage.this.midletProject.getDevice());
                                OverviewEditorPage.this.deviceSelector.enableFireSelectionChanged(true);
                            }
                        }
                    });
                }
            }

            public void enabledSymbolDefinitionSetChanged() {
            }

            public void jadFileNameChanged() {
            }

            public void signaturePropertiesChanged() {
            }

            public void tempKeyPasswordChanged() {
            }

            public void tempKeystorePasswordChanged() {
            }
        });
    }

    private void createDebuginSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, "Debugging");
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, EditorsUIContent.overviewPage_launchsection_debuglinks, formToolkit, this);
        formText.setImage("debugMidlet", MTJUIPlugin.getImageFromCache("debug_exc.gif"));
        formText.setImage("debugjad", MTJUIPlugin.getImageFromCache("debug_exc.gif"));
        formText.setImage("debugOta", MTJUIPlugin.getImageFromCache("debug_exc.gif"));
        section.setClient((Control)composite2);
    }

    private void createExportingSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, "Exporting");
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, EditorsUIContent.overviewPage_exporting, formToolkit, this);
        formText.setImage("antenna", MTJUIPlugin.getImageFromCache("ant.gif"));
        section.setClient((Control)composite2);
    }

    private void createOverviewSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticBasicSection(formToolkit, composite, EditorsUIContent.overviewPage_requiredsection_title, EditorsUIContent.overviewPage_requiredsection_description);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(iManagedForm, composite2, this);
        section.setClient((Control)composite2);
    }

    private void createPackagingSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, "Packaging");
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, EditorsUIContent.overviewPage_deploying, formToolkit, this);
        formText.setImage("package", MTJUIPlugin.getImageFromCache("library.gif"));
        formText.setImage("obfuscate", MTJUIPlugin.getImageFromCache("library.gif"));
        section.setClient((Control)composite2);
    }

    private void createRunningSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, "Running");
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, EditorsUIContent.overviewPage_launchsection_runlinks, formToolkit, this);
        formText.setImage("runMidlet", MTJUIPlugin.getImageFromCache("run_exc.gif"));
        formText.setImage("runjad", MTJUIPlugin.getImageFromCache("run_exc.gif"));
        formText.setImage("runOta", MTJUIPlugin.getImageFromCache("run_exc.gif"));
        section.setClient((Control)composite2);
    }

    private void createRuntimeSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticBasicSection(formToolkit, composite, EditorsUIContent.overviewPage_runtimesection_title, EditorsUIContent.overviewPage_runtimesection_description);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 1));
        this.createRuntimeSectionContent(iManagedForm, composite2, this);
        section.setClient((Control)composite2);
    }

    private void createRuntimeSectionContent(IManagedForm iManagedForm, Composite composite, OverviewEditorPage overviewEditorPage) {
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents(composite, false, false);
        this.deviceSelector.enableFireSelectionChanged(false);
        if (this.midletProject != null && this.midletProject.getDevice() != null) {
            this.deviceSelector.setSelectedDevice(this.midletProject.getDevice());
        }
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                OverviewEditorPage.this.setDirty(true);
            }
        });
        this.deviceSelector.enableFireSelectionChanged(true);
        this.addMidletProjectChangeListener();
    }

    private void fillEditorPageBody(IManagedForm iManagedForm) {
        this.display = Display.getCurrent();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        composite2.setLayoutData((Object)new TableWrapData(256));
        this.createOverviewSection(iManagedForm, composite2, formToolkit);
        this.createPackagingSection(iManagedForm, composite2, formToolkit);
        this.createExportingSection(iManagedForm, composite2, formToolkit);
        Composite composite3 = formToolkit.createComposite(composite);
        composite3.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        composite3.setLayoutData((Object)new TableWrapData(256));
        this.createRunningSection(iManagedForm, composite3, formToolkit);
        this.createDebuginSection(iManagedForm, composite3, formToolkit);
        this.createRuntimeSection(iManagedForm, composite3, formToolkit);
    }

    private void handleLaunchShortcut(String string) {
        IConfigurationElement[] iConfigurationElementArray;
        int n = (string = string.substring(15)).indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n2 = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
            if (string3.equals(iConfigurationElement.getAttribute("id"))) {
                try {
                    ILaunchShortcut iLaunchShortcut = (ILaunchShortcut)iConfigurationElement.createExecutableExtension("class");
                    iLaunchShortcut.launch((ISelection)new StructuredSelection((Object)this.project), string2);
                }
                catch (CoreException coreException) {}
            }
            ++n3;
        }
    }

    protected void addContextHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADRequiredPropertiesEditorPage");
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getTitle());
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                }
            };
            action.setImageDescriptor(MTJUIPlugin.getIconImageDescriptor("linkto_help.gif"));
            iToolBarManager.add((IAction)action);
        }
        scrolledForm.updateToolBar();
        this.fillEditorPageBody(iManagedForm);
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.docs/docs/jadeditor.html";
    }

    protected String getSectionDescription() {
        return "";
    }

    protected String getSectionTitle() {
        return "";
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.loadedJarUrl = this.getPreferenceStore().getString("MIDlet-Jar-URL");
    }
}

