/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.IDeviceImporter;
import org.eclipse.mtj.core.importer.JavadocDetector;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.core.model.preverifier.impl.StandardPreverifier;
import org.eclipse.mtj.toolkit.uei.UEIDevice;
import org.eclipse.mtj.toolkit.uei.UEIPropertiesReader;
import org.eclipse.mtj.toolkit.uei.internal.UeiPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEIDeviceImporter
implements IDeviceImporter {
    public static final String PROP_CLASSPATH = "bootclasspath";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_DEVICE_LIST = "device.list";
    public static final String PROP_KNOWN_ARGUMENTS = "uei.arguments";
    public static final String PROP_SECURITY_DOMAINS = "security.domains";
    public static final String PROP_TOOLKIT_NAME = "org.eclipse.mtj.toolkit.name";
    public static final String PROPS_FILE = "uei_device.properties";
    private ArrayList<UEIDeviceDefinition> deviceDefinitions;

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        File file2;
        IDevice[] iDeviceArray = null;
        if (UeiPlugin.DEBUG) {
            UeiPlugin.debugLog("> getMatchingDevices for " + file);
        }
        if ((file2 = this.getEmulatorInDirectory(file)) != null) {
            if (UeiPlugin.DEBUG) {
                UeiPlugin.debugLog("- getMatchingDevices emulator =  " + file2);
            }
            try {
                Properties properties = this.getUEIEmulatorProperties(file2);
                if (this.isValidUEIProperties(properties)) {
                    UeiPlugin.debugLog("- getMatchingDevices UEI properties are valid");
                    UEIDeviceDefinition uEIDeviceDefinition = this.getDeviceDefinition(properties);
                    if (UeiPlugin.DEBUG) {
                        UeiPlugin.debugLog("- getMatchingDevices UEI Device definition = " + uEIDeviceDefinition);
                    }
                    if (uEIDeviceDefinition != null) {
                        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
                        this.addUEIDevices(arrayList, file2, uEIDeviceDefinition, properties);
                        iDeviceArray = arrayList.toArray(new IDevice[arrayList.size()]);
                    }
                }
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (String)"Error retrieving UEI importer extensions", (Throwable)coreException);
            }
            catch (IOException iOException) {
                MTJCorePlugin.log((int)4, (String)"Error retrieving UEI importer extensions", (Throwable)iOException);
            }
        }
        if (UeiPlugin.DEBUG) {
            UeiPlugin.debugLog("< getMatchingDevices for " + file);
        }
        return iDeviceArray;
    }

    private void addUEIDevices(ArrayList<IDevice> arrayList, File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties) throws CoreException {
        UeiPlugin.debugLog("> addUEIDevices");
        String string = properties.getProperty(PROP_DEVICE_LIST);
        if (UeiPlugin.DEBUG) {
            UeiPlugin.debugLog("- addUEIDevices devices = " + string);
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                IDevice iDevice = this.createDevice(file, uEIDeviceDefinition, properties, string2);
                arrayList.add(iDevice);
            }
        }
        UeiPlugin.debugLog("< addUEIDevices");
    }

    private IDevice createDevice(File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties, String string) throws CoreException {
        if (UeiPlugin.DEBUG) {
            UeiPlugin.debugLog("Creating device definition = " + string);
        }
        Properties properties2 = this.filterDeviceProperties(properties, string);
        UEIDevice uEIDevice = new UEIDevice();
        uEIDevice.setBundle(UeiPlugin.getDefault().getBundle().getSymbolicName());
        uEIDevice.setClasspath(this.getDeviceClasspath(properties2));
        uEIDevice.setDebugServer(uEIDeviceDefinition.isDebugServer());
        uEIDevice.setDescription(this.getDeviceDescription(properties2, string));
        uEIDevice.setDeviceProperties(properties2);
        uEIDevice.setExecutable(file);
        uEIDevice.setGroupName(this.getDeviceGroupName(properties));
        uEIDevice.setName(string);
        uEIDevice.setPreverifier((IPreverifier)this.getPreverifier(file));
        uEIDevice.setProtectionDomains(this.getProtectionDomains(properties2));
        uEIDevice.setLaunchCommandTemplate(uEIDeviceDefinition.getLaunchTemplate());
        return uEIDevice;
    }

    private Properties filterDeviceProperties(Properties properties, String string) {
        Properties properties2 = new Properties();
        String string2 = String.valueOf(string) + ".";
        int n = string2.length();
        for (String string3 : properties.keySet()) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(n);
            String string5 = properties.getProperty(string3);
            properties2.setProperty(string4, string5);
        }
        return properties2;
    }

    private Classpath getDeviceClasspath(Properties properties) {
        Classpath classpath = new Classpath();
        String string = properties.getProperty(PROP_CLASSPATH, "");
        String[] stringArray = string.split(",");
        JavadocDetector javadocDetector = new JavadocDetector().addJavadocSearchStrategy((JavadocDetector.IJavadocSearchStrategy)new JavadocDetector.GenericLocalFSSearch());
        LibraryImporter libraryImporter = new LibraryImporter();
        libraryImporter.setJavadocDetector(javadocDetector);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            File file = new File(string2);
            if (file.exists()) {
                classpath.addEntry(libraryImporter.createLibraryFor(file));
            }
            ++n2;
        }
        return classpath;
    }

    private UEIDeviceDefinition getDeviceDefinition(Properties properties) throws IOException {
        UEIDeviceDefinition uEIDeviceDefinition = null;
        String string = properties.getProperty(PROP_TOOLKIT_NAME, "");
        Iterator<UEIDeviceDefinition> iterator = this.getDeviceDefinitions().iterator();
        while (iterator.hasNext() && uEIDeviceDefinition == null) {
            UEIDeviceDefinition uEIDeviceDefinition2 = iterator.next();
            Matcher matcher = uEIDeviceDefinition2.getMatchPattern().matcher(string);
            if (!matcher.find()) continue;
            uEIDeviceDefinition = uEIDeviceDefinition2;
        }
        return uEIDeviceDefinition;
    }

    private ArrayList<UEIDeviceDefinition> getDeviceDefinitions() throws IOException {
        if (this.deviceDefinitions == null) {
            this.deviceDefinitions = this.readDeviceDefinitions();
        }
        return this.deviceDefinitions;
    }

    private String getDeviceDescription(Properties properties, String string) {
        return properties.getProperty(PROP_DESCRIPTION, string).trim();
    }

    private String getDeviceGroupName(Properties properties) {
        return properties.getProperty(PROP_TOOLKIT_NAME, "Unknown");
    }

    private File getEmulatorInDirectory(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().equalsIgnoreCase("emulator.exe") || file.getName().equals("emulator");
            }
        });
        File file2 = null;
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    private UEIDeviceDefinition getNewDeviceDefinition(ArrayList<UEIDeviceDefinition> arrayList, Properties properties, String string) {
        UEIDeviceDefinition uEIDeviceDefinition = null;
        String string2 = properties.getProperty(String.valueOf(string) + ".match.expression");
        if (string2 != null) {
            uEIDeviceDefinition = new UEIDeviceDefinition();
            Pattern pattern = Pattern.compile(string2);
            boolean bl = properties.getProperty(String.valueOf(string) + ".debug.server", "").equalsIgnoreCase("true");
            boolean bl2 = properties.getProperty(String.valueOf(string) + ".predeploy.required", "").equalsIgnoreCase("true");
            uEIDeviceDefinition.setDebugServer(bl);
            uEIDeviceDefinition.setName(string);
            uEIDeviceDefinition.setMatchPattern(pattern);
            uEIDeviceDefinition.setLaunchTemplate(properties.getProperty(String.valueOf(string) + ".launch.template", ""));
            uEIDeviceDefinition.setPredeployRequired(bl2);
        }
        return uEIDeviceDefinition;
    }

    private StandardPreverifier getPreverifier(File file) throws CoreException {
        File file2 = new File(file.getParentFile(), "preverify");
        StandardPreverifier standardPreverifier = StandardPreverifierFactory.createPreverifier((File)file2);
        return standardPreverifier;
    }

    private String[] getProtectionDomains(Properties properties) {
        String string = properties.getProperty(PROP_SECURITY_DOMAINS, "");
        return string.split(",");
    }

    private InputStream getUEIDevicesPropertiesStream() throws IOException {
        Bundle bundle = UeiPlugin.getDefault().getBundle();
        URL uRL = bundle.getEntry(PROPS_FILE);
        return uRL.openStream();
    }

    private Properties getUEIEmulatorProperties(File file) throws CoreException {
        return UEIPropertiesReader.instance.getUEIProperties(file);
    }

    private boolean isValidUEIProperties(Properties properties) {
        return properties != null && properties.containsKey(PROP_DEVICE_LIST);
    }

    private ArrayList<UEIDeviceDefinition> readDeviceDefinitions() throws IOException {
        ArrayList<UEIDeviceDefinition> arrayList = new ArrayList<UEIDeviceDefinition>();
        Properties properties = new Properties();
        InputStream inputStream = this.getUEIDevicesPropertiesStream();
        if (inputStream != null) {
            String[] stringArray;
            try {
                properties.load(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            String string = properties.getProperty("devices", "");
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                arrayList.add(this.getNewDeviceDefinition(arrayList, properties, string2));
                ++n2;
            }
        }
        return arrayList;
    }

    private class UEIDeviceDefinition {
        private String name;
        private boolean debugServer;
        private boolean predeployRequired;
        private String launchTemplate;
        private Pattern matchPattern;

        private UEIDeviceDefinition() {
        }

        public String getLaunchTemplate() {
            return this.launchTemplate;
        }

        public Pattern getMatchPattern() {
            return this.matchPattern;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDebugServer() {
            return this.debugServer;
        }

        public boolean isPredeployRequired() {
            return this.predeployRequired;
        }

        public void setDebugServer(boolean bl) {
            this.debugServer = bl;
        }

        public void setLaunchTemplate(String string) {
            this.launchTemplate = string;
        }

        public void setMatchPattern(Pattern pattern) {
            this.matchPattern = pattern;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setPredeployRequired(boolean bl) {
            this.predeployRequired = bl;
        }
    }
}

