/**
 * Copyright (c) 2008 Motorola.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Diego Sandin (Motorola) - Initial implementation
 */
package org.eclipse.mtj.ui.internal.editors.jad.source.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/**
 * Proposals generated by content assist processors.
 * 
 * @author Diego Madruga Sandin
 */
public class JADAttributeCompletionProposal implements ICompletionProposal {

    protected String replacementString;
    protected Image image;
    protected String displayString;
    protected int startOffset;
    protected int length;

    /**
     * Create a new JADAttributeCompletionProposal
     * 
     * @param replacementString the string that will replace the activation
     *                string
     * @param image the image to be displayed in the list of completion
     *                proposals
     * @param displayString the string to be displayed in the list of completion
     *                proposals.
     */
    public JADAttributeCompletionProposal(String replacementString,
            Image image, String displayString) {
        this(replacementString, image, displayString, 0, 0);
    }

    /**
     * Create a new JADAttributeCompletionProposal
     * 
     * @param replacementString the string that will replace the activation
     *                string
     * @param image the image to be displayed in the list of completion
     *                proposals
     * @param displayString the string to be displayed in the list of completion
     *                proposals.
     * @param startOffset the start position to be replaced
     * @param length the total of characters to be replaced
     */
    public JADAttributeCompletionProposal(String replacementString,
            Image image, String displayString, int startOffset, int length) {

        Assert.isNotNull(replacementString);

        this.replacementString = replacementString;
        this.image = image;
        this.displayString = displayString;
        this.startOffset = startOffset;
        this.length = length;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#apply(org.eclipse.jface.text.IDocument)
     */
    public void apply(IDocument document) {
        if (length == -1) {
            String current = document.get();
            length = current.length();
        }
        try {
            document.replace(startOffset, length, replacementString);
        } catch (BadLocationException e) {
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#getAdditionalProposalInfo()
     */
    public String getAdditionalProposalInfo() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#getContextInformation()
     */
    public IContextInformation getContextInformation() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#getDisplayString()
     */
    public String getDisplayString() {
        return displayString;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#getImage()
     */
    public Image getImage() {
        return image;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.text.contentassist.ICompletionProposal#getSelection(org.eclipse.jface.text.IDocument)
     */
    public Point getSelection(IDocument document) {
        if (replacementString.equals("\"\"")) {
            return new Point(startOffset + 1, 0);
        }
        return new Point(startOffset + replacementString.length(), 0);
    }

}
