/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.internal.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class PropertyAndPreferencePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected PreferencePage preferencePage;
    protected Button projectSpecificSettings;

    public boolean isValid() {
        boolean bl = true;
        if (this.projectSpecificSettings.getSelection()) {
            bl = this.preferencePage.isValid();
        }
        return bl;
    }

    public boolean performCancel() {
        return this.preferencePage.performCancel() && super.performCancel();
    }

    public boolean performOk() {
        this.storeProjectSpecificSettingsValue();
        return this.preferencePage.performOk() && super.performOk();
    }

    private void recursivelySetEnablement(Control control, boolean bl) {
        if (control instanceof Composite) {
            Control[] controlArray;
            Control[] controlArray2 = controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control2 = controlArray2[n2];
                this.recursivelySetEnablement(control2, bl);
                ++n2;
            }
        }
        if (control instanceof Button && ((Button)control).getText().equals("Use Built-in Preverifier")) {
            control.setEnabled(false);
        } else {
            control.setEnabled(bl);
        }
    }

    private void storeProjectSpecificSettingsValue() {
        this.getPreferenceStore().setValue(this.getProjectSpecificSettingsKey(), this.projectSpecificSettings.getSelection());
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_J2MEProjectPropertiesPage");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.createProjectSpecificControls(composite2);
        this.embedPreferencePage(composite2);
        this.initializeState();
        return composite2;
    }

    protected void createProjectSpecificControls(Composite composite) {
        this.projectSpecificSettings = new Button(composite, 32);
        this.projectSpecificSettings.setText("Enable project specific settings");
        this.projectSpecificSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PropertyAndPreferencePage.this.projectSpecificSettings.getSelection();
                if (!bl) {
                    ((IEmbeddableWorkbenchPreferencePage)PropertyAndPreferencePage.this.preferencePage).performDefaults();
                }
                PropertyAndPreferencePage.this.updateEmbeddedEnablement(bl);
            }
        });
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(768));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return MTJUIPlugin.getCoreProjectPreferenceStore(this.getProject());
    }

    protected abstract void embedPreferencePage(Composite var1);

    protected IProject getProject() {
        IProject iProject = null;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        } else if (iAdaptable instanceof IJavaProject) {
            iProject = ((IJavaProject)iAdaptable).getProject();
        }
        return iProject;
    }

    protected abstract String getProjectSpecificSettingsKey();

    protected boolean hasProjectSpecificProperties() {
        String string = this.getProjectSpecificSettingsKey();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore.getBoolean(string);
    }

    protected void initializeState() {
        boolean bl = this.isReadOnly();
        boolean bl2 = this.hasProjectSpecificProperties();
        this.projectSpecificSettings.setSelection(bl2);
        this.projectSpecificSettings.setEnabled(!bl);
        this.updateEmbeddedEnablement(!bl && bl2);
    }

    protected boolean isPreprocessedOutputProject() {
        boolean bl = false;
        try {
            bl = this.getProject().hasNature("org.eclipse.mtj.core.preprocessedNature");
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (Throwable)coreException);
        }
        return bl;
    }

    protected abstract boolean isReadOnly();

    protected void performApply() {
        this.storeProjectSpecificSettingsValue();
        ((IEmbeddableWorkbenchPreferencePage)this.preferencePage).performApply();
    }

    protected void performDefaults() {
        boolean bl = false;
        ((IEmbeddableWorkbenchPreferencePage)this.preferencePage).performDefaults();
        this.projectSpecificSettings.setSelection(bl);
        this.updateEmbeddedEnablement(bl);
    }

    protected void updateEmbeddedEnablement(boolean bl) {
        this.recursivelySetEnablement(this.preferencePage.getControl(), bl);
    }
}

