/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;

public class MidletSuiteFactory {
    public static final String[] JAVA11_OPTIONS = new String[]{"org.eclipse.jdt.core.compiler.compliance", "1.3", "org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1", "org.eclipse.jdt.core.compiler.source", "1.3"};
    private static final Map<IJavaProject, IMidletSuiteProject> midletSuiteMap = new HashMap<IJavaProject, IMidletSuiteProject>();

    public static MidletSuiteCreationRunnable getMidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IDevice iDevice, String string) {
        return new MidletSuiteCreationRunnable(iProject, iJavaProject, iDevice, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject iJavaProject) {
        IMidletSuiteProject iMidletSuiteProject = null;
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            iMidletSuiteProject = midletSuiteMap.get(iJavaProject);
            if (iMidletSuiteProject == null) {
                iMidletSuiteProject = new MidletSuiteProject(iJavaProject);
                midletSuiteMap.put(iJavaProject, iMidletSuiteProject);
            }
        }
        return iMidletSuiteProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidletSuiteProject(IJavaProject iJavaProject) {
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            midletSuiteMap.remove(iJavaProject);
        }
    }

    private MidletSuiteFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MidletSuiteCreationRunnable {
        private IDevice device;
        private String jadFileName;
        private IJavaProject javaProject;
        private IProject project;
        private boolean preprocessingEnable;

        private MidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IDevice iDevice, String string) {
            this.project = iProject;
            this.javaProject = iJavaProject;
            this.device = iDevice;
            this.jadFileName = string;
        }

        public boolean isPreprocessingEnable() {
            return this.preprocessingEnable;
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
                iMidletSuiteProject.setDevice(this.device, iProgressMonitor);
                iMidletSuiteProject.setJadFileName(this.jadFileName);
                this.addNatures(iProgressMonitor);
                this.setJavaProjectOptions(iProgressMonitor);
                this.setProjectMetadata();
                this.createApplicationDescriptorInProject(iProgressMonitor);
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
            catch (IOException iOException) {
                throw new InvocationTargetException(iOException);
            }
        }

        public void setPreprocessingEnable(boolean bl) {
            this.preprocessingEnable = bl;
        }

        private boolean addNatureIfNecessary(ArrayList<String> arrayList, String string) {
            boolean bl = false;
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                bl = true;
            }
            return bl;
        }

        private void addNatures(IProgressMonitor iProgressMonitor) throws CoreException {
            IProjectDescription iProjectDescription = this.project.getDescription();
            ArrayList<String> arrayList = new ArrayList<String>((Collection)Arrays.asList(iProjectDescription.getNatureIds()));
            boolean bl = this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.nature");
            bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.jdt.core.javanature");
            if (this.isPreprocessingEnable()) {
                bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.preprocessingNature");
            }
            if (bl) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
                this.project.setDescription(iProjectDescription, (IProgressMonitor)subProgressMonitor);
            }
        }

        private void createApplicationDescriptorInProject(IProgressMonitor iProgressMonitor) throws CoreException, IOException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
            if (!iFile.exists()) {
                InputStream inputStream = this.getJADFileSource(iMidletSuiteProject);
                iFile.create(inputStream, true, iProgressMonitor);
            }
        }

        private String getConfigurationVersion() {
            ILibrary iLibrary = this.device.getConfigurationLibrary();
            API aPI = null;
            if (iLibrary != null) {
                aPI = iLibrary.getConfiguration();
            }
            return aPI == null ? "1.0" : aPI.toString();
        }

        private ColonDelimitedProperties getDefaultApplicationDescriptorProperties(IMidletSuiteProject iMidletSuiteProject) {
            String string;
            ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", iMidletSuiteProject.getJarFilename());
            colonDelimitedProperties.setProperty("MIDlet-Name", String.valueOf(this.project.getName()) + " MIDlet Suite");
            colonDelimitedProperties.setProperty("MIDlet-Vendor", "MIDlet Suite Vendor");
            colonDelimitedProperties.setProperty("MIDlet-Version", "1.0.0");
            String string2 = this.getConfigurationVersion();
            if (string2 != null) {
                colonDelimitedProperties.setProperty("MicroEdition-Configuration", string2);
            }
            if ((string = this.getProfileVersion()) != null) {
                colonDelimitedProperties.setProperty("MicroEdition-Profile", string);
            }
            return colonDelimitedProperties;
        }

        private InputStream getJADFileSource(IMidletSuiteProject iMidletSuiteProject) throws IOException, CoreException {
            Object object;
            InputStream inputStream = null;
            String string = iMidletSuiteProject.getJadFileName();
            IFolder iFolder = this.project.getFolder("bin");
            if (iFolder.exists() && (object = iFolder.getFile(string)).exists()) {
                inputStream = object.getContents();
            }
            if (inputStream == null) {
                object = new ByteArrayOutputStream();
                ColonDelimitedProperties colonDelimitedProperties = this.getDefaultApplicationDescriptorProperties(iMidletSuiteProject);
                colonDelimitedProperties.store((OutputStream)object, "");
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
            return inputStream;
        }

        private String getProfileVersion() {
            ILibrary iLibrary = this.device.getProfileLibrary();
            API aPI = iLibrary == null ? null : iLibrary.getProfile();
            return aPI == null ? null : aPI.toString();
        }

        private void setJavaProjectOptions(IProgressMonitor iProgressMonitor) {
            Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
            boolean bl = preferences.getBoolean("force_java11");
            if (bl) {
                int n = 0;
                while (n < JAVA11_OPTIONS.length) {
                    String string = JAVA11_OPTIONS[n++];
                    String string2 = JAVA11_OPTIONS[n++];
                    this.javaProject.setOption(string, string2);
                }
            }
        }

        private void setProjectMetadata() throws CoreException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            iMidletSuiteProject.saveMetaData();
        }
    }
}

