/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preverification.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.IResourceFilter;

public class SourceResourcesFilter
implements IResourceFilter {
    private static final String[] IGNORED_FILE_SUFFIXES = new String[]{"java", "jad"};
    private static final String[] IGNORED_PROJECT_FILES = new String[]{".classpath", ".project", ".mtj"};
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private IJavaProject javaProject;
    private Set<String> ignoredFileSuffixes;
    private Set<String> ignoredProjectFolders;
    private Set<String> ignoredProjectFiles;
    private Set<IPath> classpathLibs;

    public SourceResourcesFilter(IJavaProject iJavaProject) throws JavaModelException {
        this.javaProject = iJavaProject;
        this.initIgnoredProjectFiles();
        this.initIgnoredFileSuffixes();
        this.initIgnoredProjectFolders();
        this.initIgnoredClasspathLibs(iJavaProject);
    }

    public boolean shouldTraverseContainer(IContainer iContainer) {
        return !this.isIgnoredProjectFolder(iContainer);
    }

    public boolean shouldBeIncluded(IFile iFile) {
        boolean bl;
        boolean bl2 = bl = this.parentIsProject((IResource)iFile) && this.ignoredProjectFiles.contains(iFile.getName());
        return !bl && !this.isIgnoredProjectFolder(iFile.getParent()) && !this.classpathLibs.contains(iFile.getFullPath()) && !this.ignoredFileSuffixes.contains(iFile.getFileExtension());
    }

    private void initIgnoredClasspathLibs(IJavaProject iJavaProject) throws JavaModelException {
        this.classpathLibs = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            this.addClasspathEntryIfLib(iClasspathEntry);
            ++n;
        }
    }

    private void initIgnoredProjectFolders() {
        this.ignoredProjectFolders = new HashSet<String>();
        this.ignoredProjectFolders.add(SETTINGS_FOLDER_NAME);
        this.ignoredProjectFolders.add(MTJCorePlugin.getDeploymentDirectoryName());
        this.ignoredProjectFolders.add(MTJCorePlugin.getVerifiedOutputDirectoryName());
    }

    private void initIgnoredFileSuffixes() {
        this.ignoredFileSuffixes = new HashSet<String>();
        int n = 0;
        while (n < IGNORED_FILE_SUFFIXES.length) {
            this.ignoredFileSuffixes.add(IGNORED_FILE_SUFFIXES[n]);
            ++n;
        }
    }

    private void initIgnoredProjectFiles() {
        this.ignoredProjectFiles = new HashSet<String>();
        int n = 0;
        while (n < IGNORED_PROJECT_FILES.length) {
            this.ignoredProjectFiles.add(IGNORED_PROJECT_FILES[n]);
            ++n;
        }
    }

    private boolean isIgnoredProjectFolder(IContainer iContainer) {
        return this.parentIsProject((IResource)iContainer) && this.ignoredProjectFolders.contains(iContainer.getName());
    }

    private boolean parentIsProject(IResource iResource) {
        return iResource.getParent().getType() == 4;
    }

    private void addClasspathEntryIfLib(IClasspathEntry iClasspathEntry) throws JavaModelException {
        switch (iClasspathEntry.getEntryKind()) {
            case 1: {
                this.classpathLibs.add(iClasspathEntry.getPath());
                break;
            }
            case 5: {
                IPath iPath = iClasspathEntry.getPath();
                if (iPath.segment(0).equals("org.elipse.mtj.JavaMEContainer")) break;
                IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)this.javaProject);
                if (iClasspathContainer != null) {
                    IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
                    int n = 0;
                    while (n < iClasspathEntryArray.length) {
                        this.addClasspathEntryIfLib(iClasspathEntryArray[n]);
                        ++n;
                    }
                    break;
                }
                MTJCorePlugin.log(4, "Unable to resolve classpath container entry " + iPath);
                break;
            }
            case 4: {
                IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                this.addClasspathEntryIfLib(iClasspathEntry2);
                break;
            }
        }
    }
}

