/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IJADDescriptorsProvider;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JADAttributesRegistry {
    private static final String JAD_ATTRIBUTE_EXTENSION = "jadattributes";
    private static JADAttributesConfigElement[] allJADAttrElements;
    private static Map<String, JADAttributesConfigElement[]> genericPageJADAttrMap;
    private static IJADDescriptorsProvider[] JADDescriptorproviders;

    static {
        genericPageJADAttrMap = new HashMap<String, JADAttributesConfigElement[]>();
    }

    public static IJADDescriptorsProvider[] getAllJADDescriptorProviders() {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = JADAttributesRegistry.getAllJADAttributeElements();
        if (JADDescriptorproviders == null) {
            JADDescriptorproviders = new IJADDescriptorsProvider[jADAttributesConfigElementArray.length];
            try {
                int n = 0;
                while (n < jADAttributesConfigElementArray.length) {
                    JADAttributesRegistry.JADDescriptorproviders[n] = jADAttributesConfigElementArray[n].getJadDescriptorsProvider();
                    ++n;
                }
            }
            catch (CoreException coreException) {
                MTJLogger.log(2, "Unable to read the JAD descriptor", coreException);
            }
        }
        return JADDescriptorproviders;
    }

    public static DescriptorPropertyDescription[] getJADAttrDescriptorsByPage(String string) {
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray;
        JADAttributesConfigElement[] jADAttributesConfigElementArray = JADAttributesRegistry.getRelatedAttrElements(string);
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray2 = descriptorPropertyDescriptionArray = JADAttributesRegistry.getDescriptorsFromElements(jADAttributesConfigElementArray);
        int n = descriptorPropertyDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptorPropertyDescription descriptorPropertyDescription = descriptorPropertyDescriptionArray2[n2];
            if (string.contains(".")) {
                String[] stringArray = string.split("\\.");
                descriptorPropertyDescription.setPageId(stringArray[0]);
                descriptorPropertyDescription.setSectionId(stringArray[1]);
            } else {
                descriptorPropertyDescription.setPageId(string);
            }
            ++n2;
        }
        return descriptorPropertyDescriptionArray;
    }

    private static JADAttributesConfigElement[] filterElements(JADAttributesConfigElement[] jADAttributesConfigElementArray, IMIDPDevice iMIDPDevice, String string, boolean bl) {
        ArrayList<JADAttributesConfigElement> arrayList = new ArrayList<JADAttributesConfigElement>();
        JADAttributesConfigElement[] jADAttributesConfigElementArray2 = jADAttributesConfigElementArray;
        int n = jADAttributesConfigElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            JADAttributesConfigElement jADAttributesConfigElement = jADAttributesConfigElementArray2[n2];
            boolean bl2 = true;
            if (iMIDPDevice != null) {
                bl2 &= jADAttributesConfigElement.isVendorSpec() && JADAttributesRegistry.isDeviceMatchVendor(iMIDPDevice, jADAttributesConfigElement);
            }
            if (string != null) {
                bl2 &= jADAttributesConfigElement.getAttributesShowPage().equalsIgnoreCase(string);
            }
            if (bl) {
                bl2 &= !jADAttributesConfigElement.isVendorSpec();
            }
            if (bl2) {
                arrayList.add(jADAttributesConfigElement);
            }
            ++n2;
        }
        return arrayList.toArray(new JADAttributesConfigElement[0]);
    }

    private static JADAttributesConfigElement[] filterElementsByPageAndVendorSpec(JADAttributesConfigElement[] jADAttributesConfigElementArray, String string, boolean bl) {
        return JADAttributesRegistry.filterElements(jADAttributesConfigElementArray, null, string, bl);
    }

    private static JADAttributesConfigElement[] getAllJADAttributeElements() {
        if (allJADAttrElements == null) {
            allJADAttrElements = JADAttributesRegistry.readAllJADAttributes();
        }
        return allJADAttrElements;
    }

    private static DescriptorPropertyDescription[] getDescriptorsFromElements(JADAttributesConfigElement[] jADAttributesConfigElementArray) {
        ArrayList<DescriptorPropertyDescription> arrayList = new ArrayList<DescriptorPropertyDescription>();
        JADAttributesConfigElement[] jADAttributesConfigElementArray2 = jADAttributesConfigElementArray;
        int n = jADAttributesConfigElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            JADAttributesConfigElement jADAttributesConfigElement = jADAttributesConfigElementArray2[n2];
            try {
                IJADDescriptorsProvider iJADDescriptorsProvider = jADAttributesConfigElement.getJadDescriptorsProvider();
                DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = iJADDescriptorsProvider.getDescriptorPropertyDescriptions();
                arrayList.addAll(Arrays.asList(descriptorPropertyDescriptionArray));
            }
            catch (Exception exception) {
                MTJLogger.log(2, "Errors happened while determining device/vendor specifc JAD attributes", exception);
            }
            ++n2;
        }
        return arrayList.toArray(new DescriptorPropertyDescription[arrayList.size()]);
    }

    private static JADAttributesConfigElement[] getGenericElements(String string) {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = JADAttributesRegistry.getAllJADAttributeElements();
        return JADAttributesRegistry.filterElementsByPageAndVendorSpec(jADAttributesConfigElementArray, string, true);
    }

    private static JADAttributesConfigElement[] getRelatedAttrElements(String string) {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = null;
        if (!genericPageJADAttrMap.containsKey(string)) {
            genericPageJADAttrMap.put(string, JADAttributesRegistry.getGenericElements(string));
        }
        jADAttributesConfigElementArray = genericPageJADAttrMap.get(string);
        return jADAttributesConfigElementArray;
    }

    private static boolean isDeviceMatchVendor(IMIDPDevice iMIDPDevice, JADAttributesConfigElement jADAttributesConfigElement) {
        return true;
    }

    private static JADAttributesConfigElement[] readAllJADAttributes() {
        String string = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, JAD_ATTRIBUTE_EXTENSION);
        JADAttributesConfigElement[] jADAttributesConfigElementArray = new JADAttributesConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            jADAttributesConfigElementArray[n] = new JADAttributesConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return jADAttributesConfigElementArray;
    }

    static class JADAttributesConfigElement {
        private static final String JAD_ATTR_SHOW_PAGE = "pageID";
        private static final String JAD_DESCRIPTOR_PROVIDER_CLASS = "class";
        private static final String JAD_DESCRIPTOR_PROVIDER_ELEMENT = "jadDescriptorsProvider";
        private static final String VENDOR_SPEC_ATTR = "vendorSpec";
        private IConfigurationElement element;
        private IJADDescriptorsProvider jadDescriptorsProvider;

        public JADAttributesConfigElement(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public String getAttributesShowPage() {
            return this.element.getAttribute(JAD_ATTR_SHOW_PAGE);
        }

        public IJADDescriptorsProvider getJadDescriptorsProvider() throws CoreException {
            IConfigurationElement[] iConfigurationElementArray;
            if (this.jadDescriptorsProvider == null && (iConfigurationElementArray = this.element.getChildren(JAD_DESCRIPTOR_PROVIDER_ELEMENT)) != null && iConfigurationElementArray.length > 0) {
                this.jadDescriptorsProvider = (IJADDescriptorsProvider)iConfigurationElementArray[0].createExecutableExtension(JAD_DESCRIPTOR_PROVIDER_CLASS);
            }
            return this.jadDescriptorsProvider;
        }

        public boolean isVendorSpec() {
            String string = this.element.getAttribute(VENDOR_SPEC_ATTR);
            return string == null ? false : "true".equalsIgnoreCase(string);
        }
    }
}

