/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntimeListUtils {
    public static final String MATCH_ATT_CLASS = "class";
    public static final String MATCH_EXTENSIONPOINT_ID = "org.eclipse.mtj.core.devicematcher";
    public static final String MATCH_ELEMENT_MATCHER = "matcher";
    public static final String MATCH_ATT_PRIORITY = "priority";

    public static boolean mtjRuntimeListContentsEquals(MTJRuntimeList mTJRuntimeList, MTJRuntimeList mTJRuntimeList2) {
        if (mTJRuntimeList.size() != mTJRuntimeList2.size()) {
            return false;
        }
        for (MTJRuntime mTJRuntime : mTJRuntimeList) {
            int n = mTJRuntimeList2.indexOf(mTJRuntime);
            if (n < 0) {
                return false;
            }
            MTJRuntime mTJRuntime2 = (MTJRuntime)mTJRuntimeList2.get(n);
            if (!MTJRuntimeListUtils.deviceEquals(mTJRuntime, mTJRuntime2)) {
                return false;
            }
            if (!MTJRuntimeListUtils.workspaceSymbolsetsEquals(mTJRuntime.getWorkspaceScopeSymbolSets(), mTJRuntime2.getWorkspaceScopeSymbolSets())) {
                return false;
            }
            if (MTJRuntimeListUtils.symbolSetEquals(mTJRuntime, mTJRuntime2)) continue;
            return false;
        }
        return true;
    }

    public static boolean mtjRuntimeListEquals(MTJRuntimeList mTJRuntimeList, MTJRuntimeList mTJRuntimeList2) {
        if (!MTJRuntimeListUtils.mtjRuntimeListContentsEquals(mTJRuntimeList, mTJRuntimeList2)) {
            return false;
        }
        return mTJRuntimeList.getActiveMTJRuntime().equals(mTJRuntimeList2.getActiveMTJRuntime());
    }

    private static boolean deviceEquals(MTJRuntime mTJRuntime, MTJRuntime mTJRuntime2) {
        return mTJRuntime.getDevice().equals(mTJRuntime2.getDevice());
    }

    public static boolean isMTJRuntimeListDirty(IMTJProject iMTJProject) {
        MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
        boolean bl = true;
        IMetaData iMetaData = MTJCore.createMetaData(iMTJProject.getProject(), ProjectType.MIDLET_SUITE);
        MTJRuntimeList mTJRuntimeList2 = iMetaData.getRuntimeList();
        bl = !MTJRuntimeListUtils.mtjRuntimeListEquals(mTJRuntimeList, mTJRuntimeList2);
        return bl;
    }

    public static boolean isOnlyActiveMTJRuntimeDirty(IMTJProject iMTJProject) {
        MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
        MTJRuntimeList mTJRuntimeList2 = new MetaData(iMTJProject.getProject()).getRuntimeList();
        boolean bl = MTJRuntimeListUtils.mtjRuntimeListContentsEquals(mTJRuntimeList, mTJRuntimeList2);
        return bl;
    }

    private static boolean symbolSetEquals(MTJRuntime mTJRuntime, MTJRuntime mTJRuntime2) {
        ISymbolSet iSymbolSet;
        ISymbolSet iSymbolSet2 = mTJRuntime.getSymbolSet();
        if (!iSymbolSet2.equals(iSymbolSet = mTJRuntime2.getSymbolSet())) {
            return false;
        }
        ArrayList<ISymbol> arrayList = new ArrayList<ISymbol>(iSymbolSet2.getSymbols());
        ArrayList<ISymbol> arrayList2 = new ArrayList<ISymbol>(iSymbolSet.getSymbols());
        for (ISymbol iSymbol : arrayList) {
            if (arrayList2.contains(iSymbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean workspaceSymbolsetsEquals(List<ISymbolSet> list, List<ISymbolSet> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null) {
            return false;
        }
        if (list != null && list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (ISymbolSet iSymbolSet : list) {
            if (list2.contains(iSymbolSet)) continue;
            return false;
        }
        return true;
    }

    public static String[] match(String string, String string2, String string3) {
        List<IConfigurationElement> list = MTJRuntimeListUtils.getMatcherExtensions();
        if (list == null) {
            return null;
        }
        MTJRuntimeListUtils.sortElementsByPriority(list);
        return MTJRuntimeListUtils.executeMatchers(list, string, string2, string3);
    }

    public static IDevice match(String string, String string2) {
        List<IConfigurationElement> list = MTJRuntimeListUtils.getMatcherExtensions();
        if (list == null) {
            return null;
        }
        MTJRuntimeListUtils.sortElementsByPriority(list);
        return MTJRuntimeListUtils.executeMatchers(list, string, string2);
    }

    private static String[] executeMatchers(List<IConfigurationElement> list, String string, String string2, String string3) {
        String[] stringArray = null;
        for (IConfigurationElement iConfigurationElement : list) {
            try {
                IDeviceMatcher iDeviceMatcher = (IDeviceMatcher)iConfigurationElement.createExecutableExtension(MATCH_ATT_CLASS);
                stringArray = iDeviceMatcher.match(string, string2, string3);
                if (stringArray == null) continue;
                break;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return stringArray;
    }

    private static IDevice executeMatchers(List<IConfigurationElement> list, String string, String string2) {
        IDevice iDevice = null;
        for (IConfigurationElement iConfigurationElement : list) {
            try {
                IDeviceMatcher iDeviceMatcher = (IDeviceMatcher)iConfigurationElement.createExecutableExtension(MATCH_ATT_CLASS);
                iDevice = iDeviceMatcher.match(string, string2);
                if (iDevice == null) continue;
                break;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return iDevice;
    }

    private static List<IConfigurationElement> getMatcherExtensions() {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(MATCH_EXTENSIONPOINT_ID);
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals(MATCH_ELEMENT_MATCHER)) {
                    arrayList.add(iConfigurationElement);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static void sortElementsByPriority(List<IConfigurationElement> list) {
        Collections.sort(list, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement iConfigurationElement, IConfigurationElement iConfigurationElement2) {
                int n;
                int n2 = Integer.parseInt(iConfigurationElement.getAttribute(MTJRuntimeListUtils.MATCH_ATT_PRIORITY));
                if (n2 == (n = Integer.parseInt(iConfigurationElement2.getAttribute(MTJRuntimeListUtils.MATCH_ATT_PRIORITY)))) {
                    return 0;
                }
                if (n2 > n2) {
                    return 1;
                }
                return -1;
            }
        });
    }
}

