/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.hooks;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.mtj.internal.core.hooks.Debug;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.util.ManifestElement;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;
import org.osgi.framework.BundleException;

public class MTJClassLoadingHook
implements ClassLoadingHook {
    private static Type IFile_Type = Type.getType((String)"Lorg/eclipse/core/resources/IFile;");
    private static final String SOURCE_FILE_CLASS = "org.eclipse.jdt.internal.core.builder.SourceFile";
    private static String SOURCE_MAPPER_CLASS = "org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess";
    private static Type SourceFile_Type = Type.getType((String)"Lorg/eclipse/jdt/internal/core/builder/SourceFile;");
    private static Type SourceMapperAccess_Type = Type.getType((String)"Lorg/eclipse/mtj/internal/core/hook/sourceMapper/SourceMapperAccess;");
    private static ManifestElement[] sourceMapperManifestElements;

    private static ManifestElement[] getSourceMapperManifestElements() {
        block3: {
            if (sourceMapperManifestElements == null) {
                try {
                    sourceMapperManifestElements = ManifestElement.parseHeader((String)"DynamicImport-Package", (String)"org.eclipse.mtj.internal.core.hook.sourceMapper");
                }
                catch (BundleException bundleException) {
                    if (!Debug.DEBUG_GENERAL) break block3;
                    bundleException.printStackTrace();
                }
            }
        }
        return sourceMapperManifestElements;
    }

    public boolean addClassPathEntry(ArrayList arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        return false;
    }

    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        block7: {
            if ("org.eclipse.jdt.core".equals(baseData.getSymbolicName())) {
                ManifestElement[] manifestElementArray = MTJClassLoadingHook.getSourceMapperManifestElements();
                Class<?> clazz = classLoaderDelegate.getClass();
                Method method = null;
                try {
                    method = clazz.getMethod("addDynamicImportPackage", manifestElementArray.getClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null) {
                    if (Debug.DEBUG_GENERAL) {
                        System.out.println("Adding dynamic import into JDT Core bundle");
                    }
                    try {
                        method.invoke((Object)classLoaderDelegate, new Object[]{manifestElementArray});
                    }
                    catch (Exception exception) {
                        if (!Debug.DEBUG_GENERAL) break block7;
                        exception.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public String findLibrary(BaseData baseData, String string) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }

    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        byte[] byArray2 = null;
        if (SOURCE_FILE_CLASS.equals(string) || SOURCE_MAPPER_CLASS.equals(string)) {
            byArray2 = this.rewriteSourceFileClass(string, byArray);
        }
        return byArray2;
    }

    private byte[] rewriteSourceFileClass(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (Debug.DEBUG_GENERAL) {
            System.out.println(String.valueOf(string) + " located.  Rewriting class bytes.");
        }
        ClassReader classReader = new ClassReader(byArray);
        ClassWriter classWriter = new ClassWriter(1);
        ClassAdapter classAdapter = null;
        classAdapter = SOURCE_FILE_CLASS.equals(string) ? new SourceFileClassAdapter((ClassVisitor)classWriter) : new SourceMapperAccessClassAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)classAdapter, 8);
        byArray2 = classWriter.toByteArray();
        if (Debug.DEBUG_GENERAL) {
            StringWriter stringWriter = new StringWriter();
            ClassReader classReader2 = new ClassReader(byArray2);
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(stringWriter));
            classReader2.accept((ClassVisitor)traceClassVisitor, 2);
            System.out.println(stringWriter);
        }
        return byArray2;
    }

    class GetContentsMethodVisitor
    extends MethodAdapter {
        boolean foundReturn;

        public GetContentsMethodVisitor(MethodVisitor methodVisitor) {
            super(methodVisitor);
            this.foundReturn = false;
        }

        public void visitFieldInsn(int n, String string, String string2, String string3) {
            if (n == 180 && string2.equals("resource") && !this.foundReturn) {
                this.insertMappedResourceCode();
            } else {
                super.visitFieldInsn(n, string, string2, string3);
            }
        }

        public void visitInsn(int n) {
            if (!this.foundReturn && n == 176) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("Found ARETURN in method.");
                }
                this.foundReturn = true;
            }
            super.visitInsn(n);
        }

        private void insertDebugMessageCode(String string) {
            if (Debug.DEBUG_GENERAL) {
                super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
                super.visitLdcInsn((Object)string);
                super.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
            }
        }

        private void insertMappedResourceCode() {
            if (Debug.DEBUG_GENERAL) {
                System.out.println("Inserting mapped resource lookup code into method.");
            }
            Label label = new Label();
            this.insertDebugMessageCode("Rewritten SourceFile");
            super.visitInsn(87);
            super.visitVarInsn(25, 0);
            super.visitFieldInsn(180, SourceFile_Type.getInternalName(), "resource", IFile_Type.getDescriptor());
            super.visitMethodInsn(184, SourceMapperAccess_Type.getInternalName(), "getMappedSourceFile", Type.getMethodDescriptor((Type)IFile_Type, (Type[])new Type[]{IFile_Type}));
            super.visitInsn(89);
            super.visitJumpInsn(199, label);
            this.insertDebugMessageCode("Mapped resource was null");
            super.visitInsn(87);
            this.insertDebugMessageCode("Using raw resource");
            super.visitVarInsn(25, 0);
            super.visitFieldInsn(180, SourceFile_Type.getInternalName(), "resource", IFile_Type.getDescriptor());
            this.visitLabel(label);
            this.insertDebugMessageCode("Finished generated code");
        }
    }

    class IsHookInstalledMethodVisitor
    extends MethodAdapter {
        public IsHookInstalledMethodVisitor(MethodVisitor methodVisitor) {
            super(methodVisitor);
        }

        public void visitInsn(int n) {
            if (n == 3) {
                n = 4;
            }
            super.visitInsn(n);
        }
    }

    class SourceFileClassAdapter
    extends ClassAdapter {
        public SourceFileClassAdapter(ClassVisitor classVisitor) {
            super(classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            Object object = super.visitMethod(n, string, string2, string3, stringArray);
            if (string.equals("getContents")) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("SourceFile#getContents spotted.  Rewriting method.");
                }
                object = new GetContentsMethodVisitor((MethodVisitor)object);
            }
            return object;
        }
    }

    class SourceMapperAccessClassAdapter
    extends ClassAdapter {
        public SourceMapperAccessClassAdapter(ClassVisitor classVisitor) {
            super(classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            Object object = super.visitMethod(n, string, string2, string3, stringArray);
            if (string.equals("isHookCodeInstalled")) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("SourceMapperAccess#isHookInstalled spotted.  Rewriting method.");
                }
                object = new IsHookInstalledMethodVisitor((MethodVisitor)object);
            }
            return object;
        }
    }
}

