/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.core.util.IJavaProjectVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JMUnitTestsVisitor
implements IJavaProjectVisitor {
    private static final String[] JMUNIT_TESTS = new String[]{"jmunit.framework.cldc11.TestCase", "jmunit.framework.cldc11.TestSuite"};
    private List<IResource> excludeds = new ArrayList<IResource>();
    private IJavaProject javaProject;

    public JMUnitTestsVisitor(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
    }

    public void visitCompilatioUnit(ICompilationUnit iCompilationUnit) {
        IType iType = iCompilationUnit.findPrimaryType();
        try {
            IType[] iTypeArray;
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray2 = iTypeArray = iTypeHierarchy.getAllClasses();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType2 = iTypeArray2[n2];
                String string = iType2.getFullyQualifiedName('.');
                String[] stringArray = JMUNIT_TESTS;
                int n3 = JMUNIT_TESTS.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource iResource;
                    String string2 = stringArray[n4];
                    if (string.equals(string2) && (iResource = iCompilationUnit.getCorrespondingResource()) != null) {
                        this.excludeds.add(iResource);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (Throwable)javaModelException);
        }
    }

    public IPath[] getJMunitTests() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IResource[] iResourceArray = Utils.getSourceFolders((IJavaProject)this.javaProject);
        block0: for (IResource iResource : this.excludeds) {
            IPath iPath = iResource.getProjectRelativePath();
            IResource[] iResourceArray2 = iResourceArray;
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource2 = iResourceArray2[n2];
                IPath iPath2 = iResource2.getProjectRelativePath();
                if (iPath2.isPrefixOf(iPath)) {
                    arrayList.add(iPath.removeFirstSegments(iPath2.segmentCount()));
                    continue block0;
                }
                ++n2;
            }
        }
        return arrayList.toArray(new IPath[0]);
    }

    public void visitPackageFragment(IPackageFragment iPackageFragment) {
    }

    public void visitPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
    }
}

