/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SyntaxColorTab {
    private Button fBoldButton;
    private TableViewer fElementViewer;
    private Button fItalicButton;
    private SourceViewer fPreviewViewer;
    private ChangeAwareSourceViewerConfiguration fSourceViewerConfiguration;
    protected IColorManager fColorManager;
    private ColorSelector colorSelector;

    public SyntaxColorTab(IColorManager iColorManager) {
        this.fColorManager = iColorManager;
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createElementTable(composite2);
        this.createPreviewer(composite2);
        return composite2;
    }

    public void dispose() {
        this.fSourceViewerConfiguration.dispose();
    }

    public void performDefaults() {
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        int n = this.fElementViewer.getTable().getItemCount();
        int n2 = 0;
        while (n2 < n) {
            ColorElement colorElement = (ColorElement)this.fElementViewer.getElementAt(n2);
            RGB rGB = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)colorElement.getColorKey());
            colorElement.setColorValue(rGB);
            colorElement.setBold(iPreferenceStore.getDefaultBoolean(String.valueOf(colorElement.getColorKey()) + "_bold"));
            colorElement.setItalic(iPreferenceStore.getDefaultBoolean(String.valueOf(colorElement.getColorKey()) + "_italic"));
            ++n2;
        }
        ColorElement colorElement = this.getColorElement(this.fElementViewer);
        this.fBoldButton.setSelection(colorElement.isBold());
        this.fItalicButton.setSelection(colorElement.isItalic());
        this.colorSelector.setColorValue(colorElement.fColorValue);
    }

    public void performOk() {
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        int n = this.fElementViewer.getTable().getItemCount();
        int n2 = 0;
        while (n2 < n) {
            ColorElement colorElement = (ColorElement)this.fElementViewer.getElementAt(n2);
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)colorElement.getColorKey(), (RGB)colorElement.getColorValue());
            iPreferenceStore.setValue(String.valueOf(colorElement.getColorKey()) + "_bold", colorElement.isBold());
            iPreferenceStore.setValue(String.valueOf(colorElement.getColorKey()) + "_italic", colorElement.isItalic());
            ++n2;
        }
    }

    private void createElementTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 16384);
        label.setText(MTJUIMessages.SyntaxColorTab_elements_label);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fElementViewer = new TableViewer(composite2, 2564);
        this.fElementViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fElementViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fElementViewer.getControl().setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(1808));
        label = new Label(composite3, 16384);
        label.setText(MTJUIMessages.SyntaxColorTab_color_label);
        this.colorSelector = new ColorSelector(composite3);
        Button button = this.colorSelector.getButton();
        button.setLayoutData((Object)new GridData(1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorElement colorElement = SyntaxColorTab.this.getColorElement(SyntaxColorTab.this.fElementViewer);
                colorElement.setColorValue(SyntaxColorTab.this.colorSelector.getColorValue());
            }
        });
        this.fBoldButton = new Button(composite3, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fBoldButton.setLayoutData((Object)gridData);
        this.fBoldButton.setText(MTJUIMessages.SyntaxColorTab_bold_label);
        this.fBoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorElement colorElement = SyntaxColorTab.this.getColorElement(SyntaxColorTab.this.fElementViewer);
                colorElement.setBold(SyntaxColorTab.this.fBoldButton.getSelection());
            }
        });
        this.fItalicButton = new Button(composite3, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fItalicButton.setLayoutData((Object)gridData);
        this.fItalicButton.setText(MTJUIMessages.SyntaxColorTab_italic_label);
        this.fItalicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorElement colorElement = SyntaxColorTab.this.getColorElement(SyntaxColorTab.this.fElementViewer);
                colorElement.setItalic(SyntaxColorTab.this.fItalicButton.getSelection());
            }
        });
        this.fElementViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ColorElement colorElement = SyntaxColorTab.this.getColorElement(SyntaxColorTab.this.fElementViewer);
                SyntaxColorTab.this.colorSelector.setColorValue(colorElement.getColorValue());
                SyntaxColorTab.this.fBoldButton.setSelection(colorElement.isBold());
                SyntaxColorTab.this.fItalicButton.setSelection(colorElement.isItalic());
            }
        });
        this.fElementViewer.setInput((Object)this.getColorData());
        this.fElementViewer.setComparator(new ViewerComparator());
        this.fElementViewer.setSelection((ISelection)new StructuredSelection(this.fElementViewer.getElementAt(0)));
    }

    private void createPreviewer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setText(MTJUIMessages.SyntaxColorTab_preview_label);
        label.setLayoutData((Object)new GridData(768));
        this.fPreviewViewer = new SourceViewer(composite2, null, 2816);
        this.fSourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (this.fSourceViewerConfiguration != null) {
            this.fPreviewViewer.configure((SourceViewerConfiguration)this.fSourceViewerConfiguration);
        }
        this.fPreviewViewer.setEditable(false);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.fPreviewViewer.setDocument(this.getDocument());
        Control control = this.fPreviewViewer.getControl();
        control.setLayoutData((Object)new GridData(1808));
    }

    private ColorElement[] getColorData() {
        String[][] stringArray = this.getColorStrings();
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        ColorElement[] colorElementArray = new ColorElement[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n][0];
            String string2 = stringArray[n][1];
            RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string2);
            boolean bl = iPreferenceStore.getBoolean(String.valueOf(string2) + "_bold");
            boolean bl2 = iPreferenceStore.getBoolean(String.valueOf(string2) + "_italic");
            colorElementArray[n] = new ColorElement(string, string2, rGB, bl, bl2);
            ++n;
        }
        return colorElementArray;
    }

    private ColorElement getColorElement(TableViewer tableViewer) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        return (ColorElement)iStructuredSelection.getFirstElement();
    }

    protected abstract String[][] getColorStrings();

    protected abstract IDocument getDocument();

    protected abstract ChangeAwareSourceViewerConfiguration getSourceViewerConfiguration();

    class ColorElement {
        private boolean fBold;
        private String fColorKey;
        private RGB fColorValue;
        private String fDisplayName;
        private boolean fItalic;

        public ColorElement(String string, String string2, RGB rGB, boolean bl, boolean bl2) {
            this.fDisplayName = string;
            this.fColorKey = string2;
            this.fColorValue = rGB;
            this.fBold = bl;
            this.fItalic = bl2;
        }

        public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SyntaxColorTab.this.fSourceViewerConfiguration != null) {
                SyntaxColorTab.this.fSourceViewerConfiguration.adaptToPreferenceChange(propertyChangeEvent);
                SyntaxColorTab.this.fPreviewViewer.invalidateTextPresentation();
            }
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public RGB getColorValue() {
            return this.fColorValue;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public boolean isBold() {
            return this.fBold;
        }

        public boolean isItalic() {
            return this.fItalic;
        }

        public void setBold(boolean bl) {
            if (bl == this.fBold) {
                return;
            }
            Boolean bl2 = this.fBold;
            this.fBold = bl;
            Boolean bl3 = bl;
            String string = String.valueOf(this.fColorKey) + "_bold";
            this.firePropertyChange(new PropertyChangeEvent((Object)this, string, (Object)bl2, (Object)bl3));
        }

        public void setColorValue(RGB rGB) {
            if (this.fColorValue.equals((Object)rGB)) {
                return;
            }
            RGB rGB2 = this.fColorValue;
            this.fColorValue = rGB;
            this.firePropertyChange(new PropertyChangeEvent((Object)this, this.fColorKey, (Object)rGB2, (Object)rGB));
        }

        public void setItalic(boolean bl) {
            if (bl == this.fItalic) {
                return;
            }
            Boolean bl2 = this.fItalic;
            this.fItalic = bl;
            Boolean bl3 = bl;
            String string = String.valueOf(this.fColorKey) + "_italic";
            this.firePropertyChange(new PropertyChangeEvent((Object)this, string, (Object)bl2, (Object)bl3));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

