/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.export.AntennaBuildExport;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.statemachine.AbstractState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateAntTaskState
extends AbstractState {
    private StateMachine stateMachine;
    private Document document;
    private String dependencies;
    private IMidletSuiteProject suiteProject;

    public AbstractCreateAntTaskState(StateMachine stateMachine, IMidletSuiteProject iMidletSuiteProject, Document document) {
        super(null);
        if (stateMachine == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_stateMachineNotNull);
        }
        this.stateMachine = stateMachine;
        if (iMidletSuiteProject == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_projectCanNotBeNull);
        }
        this.suiteProject = iMidletSuiteProject;
        if (document == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_documentNotNull);
        }
        this.document = document;
        this.dependencies = "";
    }

    protected abstract void onEnter(MTJRuntime var1) throws AntennaExportException;

    @Override
    protected void onEnter() {
        MTJRuntimeList mTJRuntimeList = this.getMidletSuiteProject().getRuntimeList();
        for (MTJRuntime mTJRuntime : mTJRuntimeList) {
            try {
                this.onEnter(mTJRuntime);
            }
            catch (AntennaExportException antennaExportException) {
                MTJLogger.log(4, antennaExportException);
            }
        }
        this.stateMachine.postEvent(new AntennaBuildExport.CreateAntTaskDoneEvent());
    }

    @Override
    protected void onExit() {
    }

    public void setDependencies(String string) {
        if (string != null) {
            this.dependencies = string;
        }
    }

    protected IMidletSuiteProject getMidletSuiteProject() {
        return this.suiteProject;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    protected StateMachine getStateMachine() {
        return this.stateMachine;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Set<IProject> getRequiredProjects(IProject iProject) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        try {
            IProject[] iProjectArray = iProject.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject2 = iProjectArray[n2];
                hashSet.addAll(this.getRequiredProjects(iProject2));
                hashSet.add(iProject2);
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        return hashSet;
    }

    protected String getFormatedName(String string) {
        return string.replace(" ", "_");
    }

    protected String getDependencies(MTJRuntime mTJRuntime) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray = this.getDependencies().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.length() > 0) {
                stringBuffer.append(NLS.bind((String)"{0}-{1}", (Object[])new String[]{string, this.getFormatedName(mTJRuntime.getName())}));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

