/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.project.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.preverification.builder.PreverificationBuilder;
import org.eclipse.mtj.core.internal.preverifier.EmbeddedPreverifier;
import org.eclipse.mtj.core.internal.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.IMidletSuiteProjectListener;
import org.eclipse.mtj.core.model.project.Messages;
import org.eclipse.mtj.core.model.project.MetaData;
import org.eclipse.mtj.core.model.sign.ISignatureProperties;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.preverifier.results.PreverificationError;

public class MidletSuiteProject
implements IMidletSuiteProject {
    public static final String CLASSES_DIRECTORY = "classes";
    public static final String LIBS_DIRECTORY = "libs";
    private static final QualifiedName DEPLOYMENT_UP_TO_DATE_PROP = new QualifiedName("org.eclipse.mtj.core", "deployed_up_to_date");
    private static final QualifiedName SYMBOL_SETS_PROP = new QualifiedName("org.eclipse.mtj.core", "symbol_sets");
    private IJavaProject javaProject;
    private MetaData metaData;
    private String tempKeyPassword;
    private String tempKeystorePassword;
    List<IMidletSuiteProjectListener> listenerList = new ArrayList<IMidletSuiteProjectListener>();

    public static boolean containsJavaMEClasspathContainer(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray;
        boolean bl = false;
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
            if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().segment(0).equals("org.elipse.mtj.JavaMEContainer")) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public static String getDefaultJadFileName(IProject iProject) {
        String string = iProject.getName();
        return String.valueOf(string.replace(' ', '_')) + ".jad";
    }

    public MidletSuiteProject(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
        this.initializeMetadata();
        if (this.getMetaData().getDevice() == null) {
            try {
                if (this.getProject().findMarkers("org.eclipse.mtj.core.device.missing", false, 0).length == 0) {
                    IMarker iMarker = this.getProject().createMarker("org.eclipse.mtj.core.device.missing");
                    iMarker.setAttribute("message", (Object)Messages.MidletSuiteProject_device_not_available);
                    iMarker.setAttribute("severity", 2);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private void addClasspathContainerIfMissing(IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = MidletSuiteProject.containsJavaMEClasspathContainer(this.getJavaProject());
        boolean bl2 = this.isPreprocessedProject();
        if (!bl && !bl2) {
            IClasspathEntry iClasspathEntry;
            Path path = new Path("org.elipse.mtj.JavaMEContainer/" + this.metaData.getDevice());
            IClasspathEntry iClasspathEntry2 = JavaCore.newContainerEntry((IPath)path);
            IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
            LinkedHashSet<IClasspathEntry> linkedHashSet = new LinkedHashSet<IClasspathEntry>(iClasspathEntryArray.length);
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray;
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 4) {
                    iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                }
                linkedHashSet.add(iClasspathEntry);
                ++n2;
            }
            IClasspathEntry iClasspathEntry3 = iClasspathEntry = this.getDevice().getClasspath().asClasspathEntries();
            int n3 = ((IClasspathEntry[])iClasspathEntry3).length;
            n = 0;
            while (n < n3) {
                IClasspathEntry iClasspathEntry4 = iClasspathEntry3[n];
                if (linkedHashSet.contains(iClasspathEntry4)) {
                    linkedHashSet.remove(iClasspathEntry4);
                }
                ++n;
            }
            linkedHashSet.add(iClasspathEntry2);
            IClasspathEntry[] iClasspathEntryArray3 = linkedHashSet.toArray(new IClasspathEntry[linkedHashSet.size()]);
            this.javaProject.setRawClasspath(iClasspathEntryArray3, iProgressMonitor);
        }
    }

    public void addMidletSuiteProjectListener(IMidletSuiteProjectListener iMidletSuiteProjectListener) {
        this.listenerList.add(iMidletSuiteProjectListener);
    }

    private void changeClasspathContainer(IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException {
        this.addClasspathContainerIfMissing(iProgressMonitor);
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            Path path;
            IPath iPath;
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 5 && (iPath = iClasspathEntry.getPath()).segment(0).equals("org.elipse.mtj.JavaMEContainer") && !iClasspathEntry.equals(path = new Path("org.elipse.mtj.JavaMEContainer/" + iDevice))) {
                iClasspathEntryArray[n] = JavaCore.newContainerEntry((IPath)path);
                this.javaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
                this.getProject().build(6, iProgressMonitor);
                break;
            }
            ++n;
        }
    }

    public void createPackage(IProgressMonitor iProgressMonitor, boolean bl, boolean bl2) throws CoreException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(2);
        hashMap.put("_do_package", Boolean.TRUE);
        hashMap.put("_do_obfuscation", bl);
        hashMap.put("_update_version", Boolean.TRUE);
        PreverificationBuilder.cleanProject(this.getProject(), true, iProgressMonitor);
        this.getProject().build(6, "org.eclipse.mtj.core.preverifier", hashMap, iProgressMonitor);
        if (bl2) {
            this.createPackageForInactiveConfigs(hashMap, iProgressMonitor);
        }
    }

    private void createPackageForInactiveConfigs(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        Configurations configurations = this.getConfigurations();
        Configuration configuration = configurations.getActiveConfiguration();
        IDevice iDevice = configuration.getDevice();
        for (Configuration configuration2 : configurations) {
            if (configuration2 == configuration) continue;
            configurations.switchActiveConfiguration(configuration2);
            IDevice iDevice2 = configuration2.getDevice();
            if (iDevice != iDevice2) {
                this.changeClasspathContainer(iDevice2, iProgressMonitor);
                iDevice = iDevice2;
            }
            this.getProject().build(6, iProgressMonitor);
            PreverificationBuilder.cleanProject(this.getProject(), true, iProgressMonitor);
            this.getProject().build(6, "org.eclipse.mtj.core.preverifier", map, iProgressMonitor);
        }
        this.restoreProjectSettings(configurations, configuration, iDevice, iProgressMonitor);
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        ApplicationDescriptor applicationDescriptor = null;
        IFile iFile = this.getApplicationDescriptorFile();
        iFile.exists();
        try {
            File file = iFile.getLocation().toFile();
            applicationDescriptor = new ApplicationDescriptor(file);
        }
        catch (IOException iOException) {
            MTJCorePlugin.log(4, "getApplicationDescriptor", iOException);
        }
        return applicationDescriptor;
    }

    public IFile getApplicationDescriptorFile() {
        IFile iFile = null;
        IProject iProject = this.javaProject.getProject();
        iFile = iProject.getFile("Application Descriptor");
        return iFile;
    }

    public File[] getClasspath(IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath = this.getVerifiedClassesOutputFolder(iProgressMonitor).getLocation();
        IPath iPath2 = this.getVerifiedLibrariesOutputFolder(iProgressMonitor).getLocation();
        ClasspathCollectionVisitor classpathCollectionVisitor = new ClasspathCollectionVisitor(iPath, iPath2);
        classpathCollectionVisitor.getRunner().run(this.javaProject, classpathCollectionVisitor, iProgressMonitor);
        int n = 0;
        Set<IPath> set = classpathCollectionVisitor.getCpEntries();
        File[] fileArray = new File[set.size()];
        for (IPath iPath3 : set) {
            fileArray[n++] = iPath3.toFile();
        }
        return fileArray;
    }

    public Configurations getConfigurations() {
        return this.metaData.getConfigurations();
    }

    public IDevice getDevice() {
        return this.metaData.getDevice();
    }

    public String getJadFileName() {
        return this.metaData.getJadFileName();
    }

    public String getJarFilename() {
        String string = null;
        String string2 = this.getApplicationDescriptor().getMidletJarURL();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            string = n != -1 ? string2.substring(n + 1) : string2;
        }
        if (string == null) {
            string = String.valueOf(this.getProjectNameWithoutSpaces()) + ".jar";
        }
        return string;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    private IPreverifier getPreverifier() throws CoreException, PreverifierNotFoundException {
        IPreverifier iPreverifier = null;
        if (this.isEmbeddedPreverifierEnabled()) {
            iPreverifier = new EmbeddedPreverifier();
        } else {
            IDevice iDevice = this.getDevice();
            if (iDevice == null) {
                throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_device);
            }
            IPreverifier iPreverifier2 = iPreverifier = iDevice.getPreverifier() != null ? iDevice.getPreverifier() : DeviceRegistry.singleton.getDefaultPreferifier();
            if (iPreverifier == null) {
                throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_default);
            }
        }
        return iPreverifier;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    private String getProjectNameWithoutSpaces() {
        String string = this.javaProject.getProject().getName();
        return string.replace(' ', '_');
    }

    public ISignatureProperties getSignatureProperties() throws CoreException {
        return this.metaData.getSignatureProperties();
    }

    public String getTempKeyPassword() {
        return this.tempKeyPassword;
    }

    public String getTempKeystorePassword() {
        return this.tempKeystorePassword;
    }

    public IFolder getVerifiedClassesOutputFolder(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.getVerifiedOutputFolder(iProgressMonitor).getFolder(CLASSES_DIRECTORY);
    }

    public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.getVerifiedOutputFolder(iProgressMonitor).getFolder(LIBS_DIRECTORY);
    }

    public IFolder getVerifiedOutputFolder(IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = this.getProject().getFolder(".mtj.tmp");
        return iFolder.getFolder("verified");
    }

    private void initializeMetadata() {
        try {
            if (this.isPreprocessedProject()) {
                Object object;
                ICommand[] iCommandArray;
                Object object2 = null;
                ICommand[] iCommandArray2 = iCommandArray = this.getProject().getDescription().getBuildSpec();
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = iCommandArray2[n2];
                    if (object.getBuilderName().equals("org.eclipse.mtj.core.preverifier")) {
                        object2 = object;
                        break;
                    }
                    ++n2;
                }
                if (object2 != null) {
                    object = (String)object2.getArguments().get("preverifyTargetProject");
                    IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject((String)object);
                    if (iProject != null) {
                        this.metaData = new MetaData(iProject);
                    }
                }
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log(4, coreException);
        }
        if (this.metaData == null) {
            this.metaData = new MetaData(this);
        }
    }

    public boolean isDeployedJarUpToDate() throws CoreException {
        String string = this.getProject().getPersistentProperty(DEPLOYMENT_UP_TO_DATE_PROP);
        return string == null ? false : string.equals("true");
    }

    private boolean isEmbeddedPreverifierEnabled() {
        return false;
    }

    public boolean isPreprocessedProject() throws CoreException {
        IProject iProject = this.getProject();
        return iProject.exists() && iProject.isOpen() && iProject.hasNature("org.eclipse.mtj.core.preprocessedNature");
    }

    public PreverificationError[] preverify(IResource[] iResourceArray, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException, PreverifierNotFoundException {
        return this.getPreverifier().preverify(this, iResourceArray, iFolder, iProgressMonitor);
    }

    public PreverificationError[] preverifyJarFile(File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException, PreverifierNotFoundException {
        return this.getPreverifier().preverifyJarFile(this, file, iFolder, iProgressMonitor);
    }

    public void removeMidletSuiteProjectListener(IMidletSuiteProjectListener iMidletSuiteProjectListener) {
        this.listenerList.remove(iMidletSuiteProjectListener);
    }

    private void restoreProjectSettings(Configurations configurations, Configuration configuration, IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException {
        configurations.switchActiveConfiguration(configuration);
        if (iDevice != configuration.getDevice()) {
            this.changeClasspathContainer(configuration.getDevice(), iProgressMonitor);
        }
        this.getProject().build(6, iProgressMonitor);
    }

    public void saveMetaData() throws CoreException {
        if (!this.isPreprocessedProject()) {
            this.metaData.saveMetaData();
        }
    }

    public void setDeployedJarFileUpToDate(boolean bl) throws CoreException {
        String string = bl ? "true" : "false";
        this.getProject().setPersistentProperty(DEPLOYMENT_UP_TO_DATE_PROP, string);
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.deployedJarFileUpToDateFlagChanged();
        }
    }

    public void setDevice(IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.metaData.getDevice() == null || !this.metaData.getDevice().equals(iDevice)) {
            this.getProject().deleteMarkers("org.eclipse.mtj.core.device.missing", false, 0);
            this.metaData.setDevice(iDevice);
            this.changeClasspathContainer(iDevice, iProgressMonitor);
        }
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.deviceChanded();
        }
    }

    public void setEnabledSymbolDefinitionSet(SymbolDefinitionSet symbolDefinitionSet) throws CoreException, PersistenceException {
        String string = null;
        if (symbolDefinitionSet != null) {
            string = symbolDefinitionSet.getName();
        }
        this.getProject().setPersistentProperty(SYMBOL_SETS_PROP, string);
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.enabledSymbolDefinitionSetChanged();
        }
    }

    public void setJadFileName(String string) {
        this.metaData.setJadFileName(string);
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.jadFileNameChanged();
        }
    }

    public void setSignatureProperties(ISignatureProperties iSignatureProperties) {
        this.metaData.setSignatureProperties(iSignatureProperties);
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.signaturePropertiesChanged();
        }
    }

    public void setTempKeyPassword(String string) {
        this.tempKeyPassword = string;
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.tempKeyPasswordChanged();
        }
    }

    public void setTempKeystorePassword(String string) {
        this.tempKeystorePassword = string;
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.tempKeystorePasswordChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClasspathCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private IPath classesPath;
        private Set<IPath> cpEntries;
        private IPath libsPath;

        private ClasspathCollectionVisitor(IPath iPath, IPath iPath2) {
            this.classesPath = iPath;
            this.libsPath = iPath2;
            this.cpEntries = new LinkedHashSet<IPath>();
        }

        public Set<IPath> getCpEntries() {
            return this.cpEntries;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            File file = Utils.getResolvedClasspathEntryFile(iClasspathEntry);
            if (file.isFile()) {
                IPath iPath = this.libsPath.append(iClasspathEntry.getPath().lastSegment());
                this.cpEntries.add(iPath);
            }
        }

        @Override
        public void visitSourceEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            this.cpEntries.add(this.classesPath);
        }
    }
}

