/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.model.IModel;
import org.eclipse.mtj.internal.core.text.DocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.DocumentTextNode;
import org.eclipse.mtj.internal.core.text.DocumentXMLNode;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.MTJTextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentElementNode
extends DocumentXMLNode
implements IDocumentElementNode {
    public static final String ATTRIBUTE_VALUE_ENCODING = "UTF-8";
    public static final String ATTRIBUTE_VALUE_FALSE = "false";
    public static final String ATTRIBUTE_VALUE_TRUE = "true";
    private static final long serialVersionUID = 1L;
    private TreeMap<String, IDocumentAttributeNode> fAttributes;
    private ArrayList<IDocumentElementNode> fChildren = new ArrayList();
    private transient int fIndent = 0;
    private transient boolean fIsErrorNode = false;
    private transient int fLength = -1;
    private transient int fOffset = -1;
    private transient IDocumentElementNode fParent = null;
    private transient IDocumentElementNode fPreviousSibling = null;
    private String fTag = null;
    private IDocumentTextNode fTextNode = null;

    public DocumentElementNode() {
        this.fAttributes = new TreeMap();
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode) {
        this.addChildNode(iDocumentElementNode, this.fChildren.size());
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode, int n) {
        this.fChildren.add(n, iDocumentElementNode);
        iDocumentElementNode.setParentNode(this);
        this.linkNodeWithSiblings(iDocumentElementNode);
    }

    @Override
    public void addTextNode(IDocumentTextNode iDocumentTextNode) {
        this.fTextNode = iDocumentTextNode;
    }

    @Override
    public boolean canTerminateStartTag() {
        return !this.hasXMLChildren() && !this.hasXMLContent() && this.isLeafNode();
    }

    @Override
    public IDocumentElementNode getChildAt(int n) {
        if (n < this.fChildren.size()) {
            return this.fChildren.get(n);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.fChildren.size();
    }

    @Override
    public IDocumentElementNode[] getChildNodes() {
        return this.fChildren.toArray(new IDocumentElementNode[this.fChildren.size()]);
    }

    @Override
    public ArrayList<IDocumentElementNode> getChildNodesList() {
        return this.fChildren;
    }

    @Override
    public IDocumentAttributeNode getDocumentAttribute(String string) {
        return this.fAttributes.get(string);
    }

    @Override
    public String getIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fIndent) {
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getLineIndent() {
        return this.fIndent;
    }

    @Override
    public IDocumentAttributeNode[] getNodeAttributes() {
        ArrayList<IDocumentAttributeNode> arrayList = new ArrayList<IDocumentAttributeNode>();
        Iterator<IDocumentAttributeNode> iterator = this.fAttributes.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new IDocumentAttributeNode[arrayList.size()]);
    }

    @Override
    public int getNodeAttributesCount() {
        IDocumentAttributeNode[] iDocumentAttributeNodeArray;
        int n = 0;
        IDocumentAttributeNode[] iDocumentAttributeNodeArray2 = iDocumentAttributeNodeArray = this.getNodeAttributes();
        int n2 = iDocumentAttributeNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IDocumentAttributeNode iDocumentAttributeNode = iDocumentAttributeNodeArray2[n3];
            if (this.isDefined(iDocumentAttributeNode)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    @Override
    public TreeMap<String, IDocumentAttributeNode> getNodeAttributesMap() {
        return this.fAttributes;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public IDocumentElementNode getParentNode() {
        return this.fParent;
    }

    @Override
    public IDocumentElementNode getPreviousSibling() {
        return this.fPreviousSibling;
    }

    @Override
    public IDocumentTextNode getTextNode() {
        return this.fTextNode;
    }

    @Override
    public String getXMLAttributeValue(String string) {
        IDocumentAttributeNode iDocumentAttributeNode = this.fAttributes.get(string);
        if (iDocumentAttributeNode == null) {
            return null;
        }
        return iDocumentAttributeNode.getAttributeValue();
    }

    @Override
    public String getXMLContent() {
        IDocumentTextNode iDocumentTextNode = this.getTextNode();
        if (iDocumentTextNode == null) {
            return null;
        }
        return iDocumentTextNode.getText();
    }

    @Override
    public String getXMLTagName() {
        return this.fTag;
    }

    @Override
    public int getXMLType() {
        return 0;
    }

    @Override
    public boolean hasXMLAttributes() {
        return this.getNodeAttributesCount() != 0;
    }

    @Override
    public boolean hasXMLChildren() {
        return this.getChildCount() != 0;
    }

    @Override
    public boolean hasXMLContent() {
        return this.isDefined(this.fTextNode);
    }

    @Override
    public int indexOf(IDocumentElementNode iDocumentElementNode) {
        return this.fChildren.indexOf(iDocumentElementNode);
    }

    @Override
    public boolean isContentCollapsed() {
        return false;
    }

    @Override
    public boolean isErrorNode() {
        return this.fIsErrorNode;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void reconnect(IDocumentElementNode iDocumentElementNode, IModel iModel) {
        this.reconnectDocument();
        this.reconnectParent(iDocumentElementNode);
        this.reconnectPreviousSibling();
        this.reconnectText();
        this.reconnectAttributes();
        this.reconnectChildren(iModel);
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode iDocumentElementNode) {
        int n = this.fChildren.indexOf(iDocumentElementNode);
        if (n != -1) {
            this.fChildren.remove(iDocumentElementNode);
            if (n < this.fChildren.size()) {
                IDocumentElementNode iDocumentElementNode2 = n == 0 ? null : this.fChildren.get(n - 1);
                this.fChildren.get(n).setPreviousSibling(iDocumentElementNode2);
            }
            return iDocumentElementNode;
        }
        return null;
    }

    @Override
    public IDocumentElementNode removeChildNode(int n) {
        if (n < 0 || n >= this.fChildren.size()) {
            return null;
        }
        IDocumentElementNode iDocumentElementNode = this.fChildren.get(n);
        this.fChildren.remove(iDocumentElementNode);
        if (n < this.fChildren.size()) {
            IDocumentElementNode iDocumentElementNode2 = null;
            if (n != 0) {
                iDocumentElementNode2 = this.fChildren.get(n - 1);
            }
            IDocumentElementNode iDocumentElementNode3 = this.fChildren.get(n);
            iDocumentElementNode3.setPreviousSibling(iDocumentElementNode2);
        }
        return iDocumentElementNode;
    }

    @Override
    public void removeDocumentAttribute(IDocumentAttributeNode iDocumentAttributeNode) {
        this.fAttributes.remove(iDocumentAttributeNode.getAttributeName());
    }

    @Override
    public void removeTextNode() {
        this.fTextNode = null;
    }

    @Override
    public void setIsErrorNode(boolean bl) {
        this.fIsErrorNode = bl;
    }

    @Override
    public void setLength(int n) {
        this.fLength = n;
    }

    @Override
    public void setLineIndent(int n) {
        this.fIndent = n;
    }

    @Override
    public void setOffset(int n) {
        this.fOffset = n;
    }

    @Override
    public void setParentNode(IDocumentElementNode iDocumentElementNode) {
        this.fParent = iDocumentElementNode;
    }

    @Override
    public void setPreviousSibling(IDocumentElementNode iDocumentElementNode) {
        this.fPreviousSibling = iDocumentElementNode;
    }

    @Override
    public void setXMLAttribute(IDocumentAttributeNode iDocumentAttributeNode) {
        this.fAttributes.put(iDocumentAttributeNode.getAttributeName(), iDocumentAttributeNode);
    }

    @Override
    public boolean setXMLAttribute(String string, String string2) {
        String string3;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = this.getXMLAttributeValue(string)) != null && string3.equals(string2)) {
            return false;
        }
        IDocumentAttributeNode iDocumentAttributeNode = this.getNodeAttributesMap().get(string);
        try {
            if (iDocumentAttributeNode == null) {
                iDocumentAttributeNode = this.createDocumentAttributeNode();
                iDocumentAttributeNode.setAttributeName(string);
                iDocumentAttributeNode.setEnclosingElement(this);
                this.setXMLAttribute(iDocumentAttributeNode);
            }
            iDocumentAttributeNode.setAttributeValue(string2);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setXMLContent(String string) {
        IDocumentTextNode iDocumentTextNode;
        if (string == null) {
            string = "";
        }
        if ((iDocumentTextNode = this.getTextNode()) == null) {
            iDocumentTextNode = this.createDocumentTextNode();
            iDocumentTextNode.setEnclosingElement(this);
            this.addTextNode(iDocumentTextNode);
        }
        iDocumentTextNode.setText(string);
        return true;
    }

    @Override
    public void setXMLTagName(String string) {
        this.fTag = string;
    }

    @Override
    public void swap(IDocumentElementNode iDocumentElementNode, IDocumentElementNode iDocumentElementNode2) {
        int n = this.fChildren.indexOf(iDocumentElementNode);
        int n2 = this.fChildren.indexOf(iDocumentElementNode2);
        this.fChildren.set(n, iDocumentElementNode2);
        this.fChildren.set(n2, iDocumentElementNode);
        iDocumentElementNode.setPreviousSibling(n2 == 0 ? null : this.fChildren.get(n2 - 1));
        iDocumentElementNode2.setPreviousSibling(n == 0 ? null : this.fChildren.get(n - 1));
        if (n < this.fChildren.size() - 1) {
            this.fChildren.get(n + 1).setPreviousSibling(iDocumentElementNode2);
        }
        if (n2 < this.fChildren.size() - 1) {
            this.fChildren.get(n2 + 1).setPreviousSibling(iDocumentElementNode);
        }
    }

    @Override
    public String write() {
        return this.write(false);
    }

    @Override
    public String write(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.hasXMLChildren();
        boolean bl3 = this.hasXMLContent();
        boolean bl4 = this.canTerminateStartTag();
        if (this.isRoot()) {
            stringBuffer.append(this.writeXMLDecl());
        }
        if (bl) {
            stringBuffer.append(this.getIndent());
        }
        stringBuffer.append(this.writeShallow(bl4));
        if (bl2) {
            IDocumentElementNode[] iDocumentElementNodeArray;
            IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = this.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
                iDocumentElementNode.setLineIndent(this.getLineIndent() + 3);
                stringBuffer.append(String.valueOf(this.getLineDelimiter()) + iDocumentElementNode.write(true));
                ++n2;
            }
        }
        if (bl3) {
            stringBuffer.append(this.writeXMLContent());
        }
        if (!bl4) {
            stringBuffer.append(this.getTerminateIndent());
            stringBuffer.append("</");
            stringBuffer.append(this.getXMLTagName());
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    @Override
    public String writeShallow(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getXMLTagName());
        stringBuffer.append(this.writeAttributes());
        if (bl) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private void linkNodeWithSiblings(IDocumentElementNode iDocumentElementNode) {
        IDocumentElementNode iDocumentElementNode2 = iDocumentElementNode.getParentNode();
        if (iDocumentElementNode2 == null) {
            return;
        }
        int n = iDocumentElementNode2.indexOf(iDocumentElementNode);
        int n2 = iDocumentElementNode2.getChildCount();
        if (n <= 0) {
            iDocumentElementNode.setPreviousSibling(null);
        } else if (n >= 1 && n2 >= 2) {
            IDocumentElementNode iDocumentElementNode3 = iDocumentElementNode2.getChildAt(n - 1);
            iDocumentElementNode.setPreviousSibling(iDocumentElementNode3);
        }
        int n3 = n2 - 2;
        if (n >= 0 && n <= n3 && n2 >= 2) {
            IDocumentElementNode iDocumentElementNode4 = iDocumentElementNode2.getChildAt(n + 1);
            iDocumentElementNode4.setPreviousSibling(iDocumentElementNode);
        }
    }

    private void reconnectAttributes() {
        for (String string : this.fAttributes.keySet()) {
            IDocumentAttributeNode iDocumentAttributeNode = this.fAttributes.get(string);
            iDocumentAttributeNode.reconnect(this);
        }
    }

    private void reconnectChildren(IModel iModel) {
        int n = 0;
        while (n < this.fChildren.size()) {
            IDocumentElementNode iDocumentElementNode = this.fChildren.get(n);
            iDocumentElementNode.reconnect(this, iModel);
            ++n;
        }
    }

    private void reconnectDocument() {
        this.fIndent = 0;
        this.fIsErrorNode = false;
        this.fLength = -1;
        this.fOffset = -1;
    }

    private void reconnectParent(IDocumentElementNode iDocumentElementNode) {
        this.fParent = iDocumentElementNode;
    }

    private void reconnectPreviousSibling() {
        this.linkNodeWithSiblings(this);
    }

    private void reconnectText() {
        if (this.fTextNode != null) {
            this.fTextNode.reconnect(this);
        }
    }

    protected IDocumentAttributeNode createDocumentAttributeNode() {
        return new DocumentAttributeNode();
    }

    protected IDocumentTextNode createDocumentTextNode() {
        return new DocumentTextNode();
    }

    protected String getAttributeIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent() + "      ";
    }

    protected String getContentIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent() + "   ";
    }

    protected String getFileEncoding() {
        return ATTRIBUTE_VALUE_ENCODING;
    }

    protected String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    protected String getTerminateIndent() {
        return String.valueOf(this.getLineDelimiter()) + this.getIndent();
    }

    protected boolean isDefined(IDocumentAttributeNode iDocumentAttributeNode) {
        if (iDocumentAttributeNode == null) {
            return false;
        }
        return iDocumentAttributeNode.getAttributeValue().trim().length() > 0;
    }

    protected boolean isDefined(IDocumentTextNode iDocumentTextNode) {
        if (iDocumentTextNode == null) {
            return false;
        }
        return MTJTextHelper.isDefinedAfterTrim(iDocumentTextNode.getText());
    }

    protected String writeAttributes() {
        IDocumentAttributeNode[] iDocumentAttributeNodeArray;
        StringBuffer stringBuffer = new StringBuffer();
        IDocumentAttributeNode[] iDocumentAttributeNodeArray2 = iDocumentAttributeNodeArray = this.getNodeAttributes();
        int n = iDocumentAttributeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode iDocumentAttributeNode = iDocumentAttributeNodeArray2[n2];
            if (this.isDefined(iDocumentAttributeNode)) {
                stringBuffer.append(String.valueOf(this.getAttributeIndent()) + iDocumentAttributeNode.write());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected String writeXMLContent() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDefined(this.fTextNode)) {
            stringBuffer.append(this.getContentIndent());
            stringBuffer.append(this.fTextNode.write());
        }
        return stringBuffer.toString();
    }

    protected String writeXMLDecl() {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(this.getFileEncoding());
        stringBuffer.append("\"");
        stringBuffer.append("?>");
        stringBuffer.append(this.getLineDelimiter());
        return stringBuffer.toString();
    }
}

