/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.configurations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.internal.tools.AntennaBuildExporter;
import org.eclipse.mtj.core.model.configuration.AddConfigEvent;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.configuration.ConfigurationsUtils;
import org.eclipse.mtj.core.model.configuration.IConfigurationChangeListener;
import org.eclipse.mtj.core.model.configuration.IConfigurationsChangeListener;
import org.eclipse.mtj.core.model.configuration.RemoveConfigEvent;
import org.eclipse.mtj.core.model.configuration.SwitchActiveConfigEvent;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MetaData;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.configurations.ConfigAddAndEditWizard;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ConfigManageComponent
implements IConfigurationsChangeListener {
    private static final String CONFIG_MANAGE_SETTINGS = "ConfigManageComponentSettings";
    private CheckboxTableViewer configViewer;
    private Configurations configurations;
    private IMidletSuiteProject midletSuiteProject;
    private boolean includeGroup = true;
    private boolean configsChanged;
    private ICheckStateListener checkStateListener;
    private IConfigurationsChangeListener configurationsChangeListener;
    private IConfigurationChangeListener configurationChangeListener;
    private String description;
    private Button editButton;
    private Button removeButton;

    public ConfigManageComponent() {
        this(null);
    }

    public ConfigManageComponent(IMidletSuiteProject iMidletSuiteProject) {
        this.midletSuiteProject = iMidletSuiteProject;
        this.configurations = iMidletSuiteProject != null ? iMidletSuiteProject.getConfigurations() : new Configurations();
        this.configurations.addConfigsChangeListener((IConfigurationsChangeListener)this);
    }

    public void activeConfigSwitched(SwitchActiveConfigEvent switchActiveConfigEvent) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.setAllChecked(false);
        this.configViewer.setChecked((Object)this.configurations.getActiveConfiguration(), true);
        this.configViewer.refresh();
    }

    private void addConfiguration(SelectionEvent selectionEvent) {
        this.addConfigurationsChangeListener();
        ConfigAddAndEditWizard configAddAndEditWizard = new ConfigAddAndEditWizard(this.configurations, null);
        Shell shell = selectionEvent.widget.getDisplay().getActiveShell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)configAddAndEditWizard);
        if (wizardDialog.open() == 0) {
            this.configViewer.refresh();
            this.changeActiveConfigIfNecessary();
            this.configsChanged = true;
        }
        this.removeConfigurationsChangeListener();
    }

    private void addConfigurationChangeListener(Configuration configuration) {
        if (this.configurationChangeListener != null && configuration != null) {
            configuration.addConfigChangeListener(this.configurationChangeListener);
        }
    }

    private void addConfigurationsChangeListener() {
        if (this.configurationsChangeListener != null) {
            this.configurations.addConfigsChangeListener(this.configurationsChangeListener);
        }
    }

    private boolean allBuildFilesExist() {
        IProject iProject = this.midletSuiteProject.getProject();
        IFile iFile = iProject.getFile("build.xml");
        IFile iFile2 = iProject.getFile("mtj-build.xml");
        return iFile.exists() && iFile2.exists();
    }

    private void askIfReexportAntennaBuildFiles() {
        if (this.midletSuiteProject == null) {
            return;
        }
        if (!this.allBuildFilesExist()) {
            return;
        }
        if (ConfigurationsUtils.isOnlyActiveConfigDirty((IMidletSuiteProject)this.midletSuiteProject)) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                boolean bl = MessageDialog.openQuestion(null, (String)MTJUIMessages.Configuration_QuestionMessage_ReexportAntennaBuildFiles_Title, (String)MTJUIMessages.Configuration_QuestionMessage_ReexportAntennaBuildFiles_Message);
                if (bl) {
                    AntennaBuildExporter antennaBuildExporter = new AntennaBuildExporter(ConfigManageComponent.this.midletSuiteProject);
                    try {
                        antennaBuildExporter.doExport((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {
                        MessageDialog.openError(null, (String)MTJUIMessages.Configuration_ErrorMessage_Title, (String)MTJUIMessages.Configuration_ErrorMessage_ReexportAntennaBuildFilesFailed);
                    }
                }
            }
        });
    }

    private boolean canPerformRemoveConfigs(TableItem[] tableItemArray, SelectionEvent selectionEvent) {
        if (this.midletSuiteProject != null && tableItemArray.length >= this.configurations.size()) {
            Shell shell = selectionEvent.widget.getDisplay().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)MTJUIMessages.Configuration_ErrorMessage_Title, (String)MTJUIMessages.Configuration_ErrorMessage_MustHaveAtLeastOneConfig);
            return false;
        }
        return true;
    }

    private void changeActiveConfigIfNecessary() {
        if (!this.configurations.isEmpty() && this.configurations.getActiveConfiguration() == null) {
            Configuration configuration = (Configuration)this.configurations.get(0);
            this.configurations.switchActiveConfiguration(configuration);
            this.configViewer.setChecked((Object)configuration, true);
            this.fireCheckStateChanged();
        }
    }

    public void configurationAdded(AddConfigEvent addConfigEvent) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.refresh();
    }

    public void configurationRemoved(RemoveConfigEvent removeConfigEvent) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.refresh();
    }

    private void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1040));
        Button button = new Button(composite2, 8);
        button.setText(MTJUIMessages.Configuration_Add);
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigManageComponent.this.addConfiguration(selectionEvent);
            }
        });
        this.editButton = new Button(composite2, 8);
        this.editButton.setText(MTJUIMessages.Configuration_Edit);
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigManageComponent.this.editConfiguration();
            }
        });
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText(MTJUIMessages.Configuration_Remove);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigManageComponent.this.removeConfiguration(selectionEvent);
            }
        });
    }

    private void createConfigTableViewer(Composite composite) {
        GridData gridData = new GridData();
        int n = 68130;
        Table table = new Table(composite, n);
        gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 300;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.configViewer = new CheckboxTableViewer(table);
        this.configViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.configViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.configViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ConfigManageComponent.this.handleCheckStateChange(checkStateChangedEvent);
                if (ConfigManageComponent.this.checkStateListener != null) {
                    ConfigManageComponent.this.checkStateListener.checkStateChanged(checkStateChangedEvent);
                }
            }
        });
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ConfigManageComponent.this.validateControls();
            }
        });
        this.configViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ConfigManageComponent.this.editConfiguration();
            }
        });
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(CONFIG_MANAGE_SETTINGS);
        TableColumnInfo[] tableColumnInfoArray = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.Configuration_Active, 20.0f, null), new TableColumnInfo(MTJUIMessages.Configuration_Configuration, 80.0f, null)};
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 300, tableColumnInfoArray, 1);
        tableViewerConfiguration.configure((TableViewer)this.configViewer);
        this.configViewer.setInput((Object)this.configurations);
        if (this.configurations != null && this.configurations.size() > 0) {
            this.configViewer.setChecked((Object)this.configurations.getActiveConfiguration(), true);
        }
    }

    public void createContents(Composite composite) {
        Composite composite2;
        if (this.includeGroup) {
            Group group = new Group(composite, 0);
            group.setText(MTJUIMessages.Configuration_Configurations);
            composite2 = group;
        } else {
            composite2 = new Composite(composite, 0);
        }
        this.setCompositeLayout(composite, composite2);
        this.createDescription(composite2);
        this.createConfigTableViewer(composite2);
        this.createButtons(composite2);
        this.validateControls();
    }

    private void createDescription(Composite composite) {
        if (this.description == null || this.description.trim().length() == 0) {
            return;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(this.description);
    }

    public void dispose() {
        this.configurations.removeConfigsChangeListener((IConfigurationsChangeListener)this);
    }

    private void editConfiguration() {
        TableItem[] tableItemArray = this.configViewer.getTable().getSelection();
        if (tableItemArray.length < 1) {
            return;
        }
        Configuration configuration = (Configuration)tableItemArray[0].getData();
        this.addConfigurationChangeListener(configuration);
        ConfigAddAndEditWizard configAddAndEditWizard = new ConfigAddAndEditWizard(this.configurations, configuration);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)configAddAndEditWizard);
        wizardDialog.create();
        configAddAndEditWizard.setMidletSuiteProject(this.midletSuiteProject);
        if (wizardDialog.open() == 0) {
            this.configViewer.refresh();
            this.configsChanged = true;
        }
        this.removeConfigurationChangeListener(configuration);
    }

    private void fireCheckStateChanged() {
        if (this.checkStateListener == null) {
            return;
        }
        Object[] objectArray = this.configViewer.getCheckedElements();
        if (objectArray.length <= 0) {
            return;
        }
        final Configuration configuration = (Configuration)objectArray[0];
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ConfigManageComponent.this.checkStateListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)ConfigManageComponent.this.configViewer, (Object)configuration, true));
            }
        });
    }

    public Configuration getActiveConfiguration() {
        if (this.configurations == null) {
            return null;
        }
        return this.configurations.getActiveConfiguration();
    }

    public Configurations getConfigurations() {
        return this.configurations;
    }

    private void handleCheckStateChange(CheckStateChangedEvent checkStateChangedEvent) {
        this.addConfigurationsChangeListener();
        Configuration configuration = (Configuration)checkStateChangedEvent.getElement();
        if (!checkStateChangedEvent.getChecked()) {
            this.configViewer.setChecked((Object)configuration, true);
            return;
        }
        this.configurations.switchActiveConfiguration(configuration);
        this.configViewer.setAllChecked(false);
        this.configViewer.setChecked((Object)configuration, true);
        this.configsChanged = true;
        this.removeConfigurationsChangeListener();
    }

    public void performCancel() {
        this.restoreConfigurations();
    }

    public void performFinish() {
        this.askIfReexportAntennaBuildFiles();
    }

    private void removeConfiguration(SelectionEvent selectionEvent) {
        this.addConfigurationsChangeListener();
        Table table = this.configViewer.getTable();
        TableItem[] tableItemArray = table.getSelection();
        if (!this.canPerformRemoveConfigs(tableItemArray, selectionEvent)) {
            return;
        }
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        TableItem[] tableItemArray2 = tableItemArray;
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            Configuration configuration = (Configuration)tableItem.getData();
            arrayList.add(configuration);
            ++n2;
        }
        this.configurations.removeAll(arrayList);
        this.changeActiveConfigIfNecessary();
        this.configViewer.refresh();
        this.configsChanged = true;
        this.removeConfigurationsChangeListener();
    }

    private void removeConfigurationChangeListener(Configuration configuration) {
        if (configuration != null) {
            configuration.removeConfigChangeListener(this.configurationChangeListener);
        }
    }

    private void removeConfigurationsChangeListener() {
        this.configurations.removeConfigsChangeListener(this.configurationsChangeListener);
    }

    private void restoreConfigurations() {
        if (this.midletSuiteProject == null) {
            return;
        }
        if (!this.configsChanged) {
            return;
        }
        Configurations configurations = new MetaData(this.midletSuiteProject.getProject()).getConfigurations();
        this.configurations.clear();
        this.configurations.addAll((Collection)configurations);
        this.configurations.switchActiveConfiguration(configurations.getActiveConfiguration());
    }

    public void setCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListener = iCheckStateListener;
    }

    private void setCompositeLayout(Composite composite, Composite composite2) {
        int n = 1;
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            n = ((GridLayout)layout).numColumns;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
    }

    public void setConfigurationChangeListener(IConfigurationChangeListener iConfigurationChangeListener) {
        this.configurationChangeListener = iConfigurationChangeListener;
    }

    public void setConfigurationsChangeListener(IConfigurationsChangeListener iConfigurationsChangeListener) {
        this.configurationsChangeListener = iConfigurationsChangeListener;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setIncludeGroup(boolean bl) {
        this.includeGroup = bl;
    }

    private void validateControls() {
        boolean bl = this.configViewer.getTable().getSelection().length == 1;
        this.editButton.setEnabled(bl);
        boolean bl2 = this.configViewer.getTable().getSelection().length > 0;
        this.removeButton.setEnabled(bl2);
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Collection collection = (Collection)object;
            return collection.toArray(new Configuration[collection.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COL_CHECKBOX = 0;
        private static final int COL_CONFIG_NAME = 1;

        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Configuration configuration = (Configuration)object;
            switch (n) {
                case 0: {
                    return "";
                }
                case 1: {
                    return configuration.getName();
                }
            }
            return "";
        }
    }
}

