/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.launching.JavaLaunchShortcut;
import org.eclipse.mtj.ui.internal.launching.MidletLaunchConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletLaunchShortcut
extends JavaLaunchShortcut {
    @Override
    protected ILaunchConfiguration createConfiguration(IType iType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getConfigurationType();
            String string = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iType.getElementName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, Utils.getQualifiedClassName((IType)iType));
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, iType.getJavaProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"debug", (String)"perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"createConfiguration", (Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    @Override
    protected IType[] findTypes(Object[] objectArray, IRunnableContext iRunnableContext) throws InterruptedException, CoreException {
        try {
            return MidletLaunchConfigUtils.findMidlets(iRunnableContext, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (CoreException)invocationTargetException.getTargetException();
        }
    }

    @Override
    protected List<ILaunchConfiguration> getCandidateConfigs(IType iType, ILaunchConfigurationType iLaunchConfigurationType) {
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray;
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                boolean bl = iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
                String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                String string2 = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
                if (!bl && string.equals(iType.getJavaProject().getElementName()) && string2.equals(iType.getFullyQualifiedName())) {
                    list.add(iLaunchConfiguration);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"getCandidateConfigs", (Throwable)coreException);
        }
        return list;
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }

    @Override
    protected String getEditorEmptyMessage() {
        return MTJUIMessages.MidletLaunching_EditorContainsNoMidlet;
    }

    @Override
    protected String getSelectionEmptyMessage() {
        return MTJUIMessages.MidletLaunching_SelectionContainsNoMidlet;
    }

    @Override
    protected String getTypeSelectionTitle() {
        return MTJUIMessages.MidletLaunching_SelectionDialogTitle;
    }
}

