/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preprocess.contentAssistant;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PreprocessCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension4 {
    PreprocessContext ppContext;
    Image image;
    IPreprocessContentAssistModel model;
    private String fDisplayString;

    public PreprocessCompletionProposal(IPreprocessContentAssistModel iPreprocessContentAssistModel, PreprocessContext preprocessContext, Image image) {
        this.model = iPreprocessContentAssistModel;
        this.ppContext = preprocessContext;
        this.image = image;
    }

    public void apply(IDocument iDocument) {
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        int n3 = this.getReplacementOffset();
        int n4 = n2 - n3;
        String string = this.getReplacementString();
        try {
            iTextViewer.getDocument().replace(n3, n4, string);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.getJavaDoc();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = this.model.getName();
            if (this.model.getDescription() != null) {
                Object[] objectArray = new String[]{this.model.getName(), this.model.getDescription()};
                this.fDisplayString = PreprocessContentAssistMessages.getFormattedString(PreprocessContentAssistMessages.PreprocessProposal_displayString, objectArray);
            }
        }
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.image;
    }

    protected String getJavaDoc() {
        return this.model.getJavaDoc();
    }

    public int getReplacementOffset() {
        return this.ppContext.getCompletionOffset();
    }

    public String getReplacementString() {
        return this.model.getName();
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.getReplacementOffset() + this.getReplacementString().length(), 0);
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        boolean bl = false;
        try {
            String string = iDocument.get(this.getReplacementOffset(), n - this.getReplacementOffset());
            if (this.getReplacementString().toLowerCase().startsWith(string.toLowerCase())) {
                bl = true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return bl;
    }
}

