/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.statusHandlers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.core.signing.SignaturePasswords;
import org.eclipse.mtj.ui.internal.dialog.SigningPasswordsDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SignaturePasswordHandler
implements IStatusHandler {
    public Object handleStatus(IStatus iStatus, Object object) {
        Display display = Display.getCurrent();
        DialogRunner dialogRunner = new DialogRunner((IProject)object);
        display.syncExec((Runnable)dialogRunner);
        return dialogRunner.getPasswords();
    }

    private static class DialogRunner
    implements Runnable {
        IProject project;
        SignaturePasswords passwords;

        public DialogRunner(IProject iProject) {
            this.project = iProject;
        }

        public void run() {
            SigningPasswordsDialog signingPasswordsDialog;
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            if (shell == null) {
                shell = new Shell(display, 0);
            }
            if ((signingPasswordsDialog = new SigningPasswordsDialog(shell, this.project)).open() != 0) {
                this.passwords = null;
            } else {
                this.passwords = new SignaturePasswords();
                this.passwords.setKeystorePassword(signingPasswordsDialog.getKeystorePassword());
                this.passwords.setKeyPassword(signingPasswordsDialog.getKeyPassword());
            }
        }

        public SignaturePasswords getPasswords() {
            return this.passwords;
        }
    }
}

