/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mtj.jmunit.JMUnitPlugin;

public class JMUnitStatus
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public static IStatus createError(String string) {
        return new JMUnitStatus(4, string);
    }

    public static IStatus createInfo(String string) {
        return new JMUnitStatus(1, string);
    }

    public static IStatus createWarning(String string) {
        return new JMUnitStatus(2, string);
    }

    public JMUnitStatus() {
        this(0, null);
    }

    public JMUnitStatus(int n, String string) {
        this.fStatusMessage = string;
        this.fSeverity = n;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        return this.fSeverity;
    }

    public Throwable getException() {
        return null;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public String getPlugin() {
        return JMUnitPlugin.getPluginId();
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean matches(int n) {
        return (this.fSeverity & n) != 0;
    }

    public void setError(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 4;
    }

    public void setInfo(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public void setWarning(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 2;
    }
}

