/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.PreferenceAccessor;
import org.eclipse.mtj.core.internal.tools.AntennaExportException;
import org.eclipse.mtj.core.internal.tools.Messages;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolUtils;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntennaBuildExporter {
    public static final String ATTR_MESSAGE = "message";
    public static final String ELEM_ECHO = "echo";
    public static final String MTJ_BUILD_XML_FILE_NAME = "mtj-build.xml";
    public static final String BUILD_XML_FILE_NAME = "build.xml";
    public static final String ATTR_PRCFILE = "prcfile";
    public static final String ELEM_WTKMAKEPRC = "wtkmakeprc";
    public static final String ELEM_WTKRUN = "wtkrun";
    public static final String ELEM_MKDIR = "mkdir";
    public static final String ELEM_WTKPREVERIFY = "wtkpreverify";
    public static final String ELEM_WTKOBFUSCATE = "wtkobfuscate";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_JARFILE = "jarfile";
    public static final String ATTR_JADFILE = "jadfile";
    public static final String ELEM_WTKPACKAGE = "wtkpackage";
    public static final String ATTR_TOFILE = "tofile";
    public static final String ELEM_COPY = "copy";
    public static final String ATTR_DIR = "dir";
    public static final String ELEM_FILESET = "fileset";
    public static final String ELEM_ANTCALL = "antcall";
    public static final String TASK_MTJ_BUILD = "-mtj-build";
    public static final String ATTR_REFID = "refid";
    public static final String ELEM_CLASSPATH = "classpath";
    public static final String ATTR_BOOTCLASSPATH = "bootclasspath";
    public static final String ELEM_WTKBUILD = "wtkbuild";
    public static final String ATTR_VERBOSE = "verbose";
    public static final String ELEM_WTKPREPROCESS = "wtkpreprocess";
    public static final String ATTR_SRCDIR = "srcdir";
    public static final String ATTR_DESTDIR = "destdir";
    public static final String ATTR_NAME = "name";
    public static final String TASK_MTJ_INITIALIZE = "-mtj-initialize";
    public static final String ATTR_DEPENDS = "depends";
    public static final String ELEM_TARGET = "target";
    public static final String ATTR_LOCATION = "location";
    public static final String ELEM_PATH = "path";
    public static final String ATTR_ID = "id";
    private static final String NO_EXPORT = "_no_export";
    private static final String PATH_BUILD_CLASSES_NO_EXPORT = "${path.build.classes}/_no_export";
    private static final String PATH_BUILD_CLASSES = "${path.build.classes}";
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\@\\{(.+?)\\}");
    private IMidletSuiteProject midletSuite;
    private IJavaProject javaProject;
    private IPath basedirPath;
    private String projectName;
    private Properties buildProperties;
    private Document mtjBuildXmlDocument;

    public AntennaBuildExporter(IMidletSuiteProject iMidletSuiteProject) {
        this.midletSuite = iMidletSuiteProject;
        this.javaProject = iMidletSuiteProject.getJavaProject();
        this.basedirPath = this.javaProject.getProject().getLocation();
        this.projectName = iMidletSuiteProject.getProject().getName();
    }

    private void addObfuscationProperties(Properties properties) {
        File file = MTJCorePlugin.getProguardJarFile();
        boolean bl = file != null && file.exists();
        properties.setProperty("flag.should.obfuscate", Boolean.toString(bl));
        if (bl) {
            File file2 = file.getParentFile().getParentFile();
            properties.setProperty("wtk.proguard.home", file2.toString());
        }
    }

    private void addVersionProperties(Properties properties) {
        int n;
        ApplicationDescriptor applicationDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = applicationDescriptor.getManifestProperties();
        String string = colonDelimitedProperties.getProperty("MicroEdition-Configuration");
        if (string != null) {
            n = string.indexOf(45);
            string = n == -1 ? string : string.substring(n + 1);
            properties.setProperty("wtk.cldc.version", string);
        }
        if ((string = colonDelimitedProperties.getProperty("MicroEdition-Profile")) != null) {
            n = string.indexOf(45);
            string = n == -1 ? string : string.substring(n + 1);
            properties.setProperty("wtk.midp.version", string);
        }
    }

    private void addWtkObfuscateArgument(Element element, String string) {
        Element element2 = this.newChildElement(element, "argument");
        element2.setAttribute("value", string);
    }

    private Properties createInitialProperties() {
        Properties properties = new Properties();
        properties.setProperty("midlet.name", this.replaceSpace(this.javaProject.getProject().getName()));
        properties.setProperty("jad.name", this.replaceSpace(this.midletSuite.getJadFileName()));
        properties.setProperty("descriptor.name", this.midletSuite.getApplicationDescriptorFile().getName());
        properties.setProperty("path.build", "${basedir}/build");
        properties.setProperty("path.build.classes", "${basedir}/build/classes");
        properties.setProperty("path.preprocess.output", "${basedir}/preprocessOutput");
        this.setClassesFolderForConfigs(properties);
        this.setPreprocessOutputFolderForConfigs(properties);
        this.setDeployFolderForConfigs(properties);
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        properties.setProperty("wtk.home", preferences.getString("wtk_root"));
        properties.setProperty("path.antenna.jar", preferences.getString("antenna_jar"));
        boolean bl = PreferenceAccessor.instance.getAutoversionPackage(this.midletSuite.getProject());
        properties.setProperty("flag.autoversion", Boolean.toString(bl));
        properties.setProperty("flag.preverify", "true");
        properties.setProperty("src.encoding", "UTF-8");
        this.setBootclasspathForConfigs(properties);
        properties.setProperty("run.device.name", "DefaultColorPhone");
        properties.setProperty("run.trace.options", "");
        this.addObfuscationProperties(properties);
        this.addVersionProperties(properties);
        return properties;
    }

    public void doExport(IProgressMonitor iProgressMonitor) throws CoreException, AntennaExportException {
        this.validateEnvironment(iProgressMonitor);
        try {
            this.buildProperties = this.createInitialProperties();
            this.mtjBuildXmlDocument = this.readMTJBuildTemplate();
            BuildClasspathEntryVisitor buildClasspathEntryVisitor = this.traverseClasspath(iProgressMonitor);
            this.updateMTJBuildXml(buildClasspathEntryVisitor.getProjectInfoMap());
            this.exportBuildXml(iProgressMonitor);
            this.writeBuildProperties(iProgressMonitor);
            this.writeMTJBuildXml(iProgressMonitor);
            this.exportSymbolFileForConfigs(iProgressMonitor);
            this.javaProject.getProject().refreshLocal(1, iProgressMonitor);
        }
        catch (Exception exception) {
            if (exception instanceof CoreException) {
                throw (CoreException)((Object)exception);
            }
            MTJCorePlugin.throwCoreException(4, -999, exception);
        }
    }

    private void exportBuildXml(IProgressMonitor iProgressMonitor) throws ParserConfigurationException, SAXException, TransformerException, IOException, CoreException {
        File file = this.getMidletSuiteFile(BUILD_XML_FILE_NAME, iProgressMonitor);
        if (!file.exists()) {
            Properties properties = new Properties();
            properties.setProperty("mtj.version", MTJCorePlugin.getPluginVersion());
            properties.setProperty("date", new Date().toString());
            properties.setProperty("project.name", this.projectName);
            InputStream inputStream = this.getClass().getResourceAsStream("buildtemplate.xml");
            if (inputStream != null) {
                StringBuffer stringBuffer = this.readBuildXmlTemplate(inputStream);
                this.replaceTemplateValues(stringBuffer, properties);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.close();
            }
        }
    }

    private void exportSymbolFileForConfigs(IProgressMonitor iProgressMonitor) throws IOException {
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(configuration.getName());
            File file = this.getMidletSuiteFile(String.valueOf(string) + ".symbols", iProgressMonitor);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "8859_1"));
            for (Object object : configuration.getSymbolSetForPreprocessing()) {
                bufferedWriter.write(String.valueOf(((Symbol)object).getName()) + "=" + ((Symbol)object).getSafeValue());
                bufferedWriter.newLine();
            }
            try {
                Object object;
                object = configuration.getWorkspaceScopeSymbolSets();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SymbolDefinitionSet symbolDefinitionSet = (SymbolDefinitionSet)iterator.next();
                    Set<Map.Entry<String, String>> set = symbolDefinitionSet.getDefinedSymbols().entrySet();
                    for (Map.Entry<String, String> entry : set) {
                        bufferedWriter.write(String.valueOf(entry.getKey()) + "=" + SymbolUtils.getSafeSymbolValue(entry.getValue()));
                        bufferedWriter.newLine();
                    }
                }
            }
            catch (Exception exception) {
                MTJCorePlugin.log(4, exception);
            }
            bufferedWriter.flush();
            fileOutputStream.close();
        }
    }

    private Element findElement(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private String getCompileDestDirForConfig(String string, String string2) {
        return string.replaceFirst("}", "." + string2 + "}");
    }

    private File getMidletSuiteFile(String string, IProgressMonitor iProgressMonitor) {
        IFile iFile = this.midletSuite.getProject().getFile(string);
        return iFile.getLocation().toFile();
    }

    private String getProguardOptions() {
        IProject iProject = this.midletSuite.getProject();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String string = preferenceAccessor.getSpecifiedProguardOptions(iProject);
        boolean bl = preferenceAccessor.isUseSpecifiedProguardOptions(iProject);
        return bl ? string : preferenceAccessor.getDefaultProguardOptions();
    }

    private String getRelativePath(IPath iPath, IPath iPath2) {
        boolean bl;
        String string = null;
        int n = iPath2.matchingFirstSegments(iPath);
        String string2 = iPath.getDevice();
        String string3 = iPath2.getDevice();
        boolean bl2 = bl = string2 == null && string3 == null;
        if (bl || string2.equals(string3)) {
            String[] stringArray;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.basedirPath.segmentCount() - n;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("/..");
                ++n3;
            }
            iPath2 = iPath2.removeFirstSegments(n);
            String[] stringArray2 = stringArray = iPath2.segments();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string4 = stringArray2[n5];
                stringBuffer.append("/").append(string4);
                ++n5;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private File getWTKRoot() {
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        return new File(preferences.getString("wtk_root"));
    }

    private void insertBuildTasks(Map<IJavaProject, ProjectInfo> map) {
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        Element element2 = this.findElement(element, "insert_build_task_for_configs");
        NodeList nodeList = this.mtjBuildXmlDocument.getElementsByTagName("target");
        Element element3 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element4 = (Element)nodeList.item(n);
            if (TASK_MTJ_BUILD.equals(element4.getAttribute(ATTR_NAME))) {
                element3 = element4;
                break;
            }
            ++n;
        }
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            Object object;
            String string = this.replaceSpace(configuration.getName());
            Element element5 = this.mtjBuildXmlDocument.createElement("target");
            element5.setAttribute(ATTR_DEPENDS, TASK_MTJ_INITIALIZE);
            element5.setAttribute(ATTR_NAME, "-mtj-build-" + string);
            Element element6 = XMLUtils.createChild(element5, ELEM_ECHO);
            element6.setAttribute(ATTR_MESSAGE, NLS.bind((String)Messages.Message_BuildConfiguration, (Object)string));
            Iterator<Map.Entry<IJavaProject, ProjectInfo>> iterator = map.entrySet().iterator();
            String string2 = "${path.preprocess.output." + string + "}";
            while (iterator.hasNext()) {
                Element element7;
                Object object2;
                object = iterator.next();
                ProjectInfo projectInfo = object.getValue();
                String string3 = "";
                if (projectInfo.javaProject == this.javaProject) {
                    Element element82;
                    for (Element element82 : projectInfo.getWtkBuildElements()) {
                        object2 = element82.getAttribute(ATTR_SRCDIR);
                        element7 = XMLUtils.createChild(element5, ELEM_WTKPREPROCESS);
                        element7.setAttribute(ATTR_SRCDIR, (String)object2);
                        element7.setAttribute(ATTR_VERBOSE, "true");
                        element7.setAttribute(ATTR_DESTDIR, string2);
                        element7.setAttribute("printsymbols", "true");
                        element7.setAttribute("savesymbols", String.valueOf(string2) + "/usedSymbols.txt");
                        element7.setAttribute("debuglevel", "info");
                        Element element9 = XMLUtils.createChild(element7, "symbols_file");
                        element9.setAttribute(ATTR_NAME, "${project.root." + this.replaceSpace(this.midletSuite.getProject().getName()) + "}/" + string + ".symbols");
                        string3 = element82.getAttribute(ATTR_DESTDIR);
                    }
                    element82 = XMLUtils.createChild(element5, ELEM_WTKBUILD);
                    element82.setAttribute(ATTR_BOOTCLASSPATH, "${bootclasspath." + string + "}");
                    element82.setAttribute(ATTR_SRCDIR, string2);
                    element82.setAttribute(ATTR_DESTDIR, this.getCompileDestDirForConfig(string3, string));
                    element82.setAttribute("encoding", "${src.encoding}");
                    element82.setAttribute("source", "1.3");
                    element82.setAttribute("sourcepath", "");
                    Element element10 = XMLUtils.createChild(element82, ELEM_CLASSPATH);
                    element10.setAttribute(ATTR_REFID, String.valueOf(projectInfo.getClasspathElementId()) + "." + string);
                    continue;
                }
                for (Element element82 : projectInfo.getWtkBuildElements()) {
                    object2 = (Element)element82.cloneNode(true);
                    string3 = object2.getAttribute(ATTR_DESTDIR);
                    object2.setAttribute(ATTR_DESTDIR, this.getCompileDestDirForConfig(string3, string));
                    element7 = XMLUtils.getFirstElementWithTagName((Element)object2, ELEM_CLASSPATH);
                    element7.setAttribute(ATTR_REFID, String.valueOf(projectInfo.getClasspathElementId()) + "." + string);
                    element5.insertBefore((Node)object2, element6.getNextSibling());
                }
            }
            element2.getParentNode().insertBefore(element5, element2);
            if (element3 == null) continue;
            object = this.newChildElement(element3, ELEM_ANTCALL);
            object.setAttribute("target", element5.getAttribute(ATTR_NAME));
        }
        element2.getParentNode().removeChild(element2);
    }

    private void insertCommentBefore(Element element, String string) {
        Document document = element.getOwnerDocument();
        Comment comment = document.createComment(string);
        document.insertBefore(comment, element);
    }

    private void insertPackageTasks(Map<IJavaProject, ProjectInfo> map) {
        Object object;
        Object object2;
        Object object422;
        Map.Entry<IJavaProject, ProjectInfo> entry22;
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        Element element2 = this.findElement(element, ELEM_WTKPACKAGE);
        for (Map.Entry<IJavaProject, ProjectInfo> entry22 : map.entrySet()) {
            object422 = (ProjectInfo)entry22.getValue();
            if (!((ProjectInfo)object422).isExported()) continue;
            Object object5 = this.newChildElement(element2, ELEM_CLASSPATH);
            object5.setAttribute(ATTR_REFID, ((ProjectInfo)object422).getClasspathElementId());
            for (Element object32 : ((ProjectInfo)object422).getPackageFilesetElements()) {
                element2.appendChild(object32);
            }
        }
        entry22 = (Element)element2.getParentNode();
        for (Object object422 : this.midletSuite.getConfigurations()) {
            String string;
            Object object3;
            Object object4;
            Element element3;
            Iterator<Element> iterator = this.replaceSpace(((Configuration)object422).getName());
            String string2 = "-mtj-build-" + iterator;
            object2 = (Element)entry22.cloneNode(true);
            object2.setAttribute(ATTR_DEPENDS, string2);
            object2.setAttribute(ATTR_NAME, "-mtj-internal-package-" + iterator);
            object = object2.getElementsByTagName(ELEM_FILESET);
            int n = 0;
            while (n < object.getLength()) {
                element3 = (Element)object.item(n);
                if (PATH_BUILD_CLASSES.equals(element3.getAttribute(ATTR_DIR))) {
                    element3.setAttribute(ATTR_DIR, "${path.build.classes." + iterator + "}");
                    break;
                }
                ++n;
            }
            NodeList nodeList = object2.getElementsByTagName(ELEM_CLASSPATH);
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                object4 = (Element)nodeList.item(n2);
                object3 = object4.getAttribute(ATTR_REFID);
                string = String.valueOf(object3) + "." + iterator;
                object4.setAttribute(ATTR_REFID, string);
                ++n2;
            }
            element3 = XMLUtils.getFirstElementWithTagName((Element)object2, ELEM_COPY);
            object4 = "${path.build.output." + iterator + "}/${jad.name}";
            element3.setAttribute(ATTR_TOFILE, (String)object4);
            object3 = XMLUtils.getFirstElementWithTagName((Element)object2, ELEM_WTKPACKAGE);
            string = "${path.build.output." + iterator + "}/${midlet.name}.jad";
            String string3 = "${path.build.output." + iterator + "}/${midlet.name}.jar";
            object3.setAttribute(ATTR_JADFILE, string);
            object3.setAttribute(ATTR_JARFILE, string3);
            Element element4 = XMLUtils.getFirstElementWithTagName((Element)object2, ELEM_ANTCALL);
            element4.setAttribute("target", "-mtj-obfuscate-" + iterator);
            entry22.getParentNode().insertBefore((Node)object2, entry22.getNextSibling());
        }
        object422 = (Element)entry22.cloneNode(false);
        for (Object object5 : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(((Configuration)object5).getName());
            object2 = "-mtj-internal-package-" + string;
            object = this.newChildElement((Element)object422, ELEM_ANTCALL);
            object.setAttribute("target", (String)object2);
        }
        entry22.getParentNode().replaceChild((Node)object422, (Node)((Object)entry22));
    }

    private void insertPathElements(Map<IJavaProject, ProjectInfo> map) {
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        Element element2 = this.findElement(element, ELEM_PATH);
        for (Map.Entry<IJavaProject, ProjectInfo> entry : map.entrySet()) {
            ProjectInfo projectInfo = entry.getValue();
            String string = projectInfo.getClasspathElementId();
            for (Configuration configuration : this.midletSuite.getConfigurations()) {
                String string2 = this.replaceSpace(configuration.getName());
                Element element3 = projectInfo.getClasspathElement();
                Element element4 = (Element)element3.cloneNode(true);
                element4.setAttribute(ATTR_ID, String.valueOf(string) + "." + string2);
                String string3 = "${path.build.classes." + string2 + "}";
                NodeList nodeList = element4.getElementsByTagName(ELEM_PATH);
                int n = 0;
                while (n < nodeList.getLength()) {
                    Element element5 = (Element)nodeList.item(n);
                    if (PATH_BUILD_CLASSES.equals(element5.getAttribute(ATTR_LOCATION))) {
                        element5.setAttribute(ATTR_LOCATION, string3);
                    } else if (PATH_BUILD_CLASSES_NO_EXPORT.equals(element5.getAttribute(ATTR_LOCATION))) {
                        element5.setAttribute(ATTR_LOCATION, String.valueOf(string3) + "/_no_export");
                    }
                    ++n;
                }
                element2.getParentNode().insertBefore(element4, element2);
            }
        }
        element2.getParentNode().removeChild(element2);
    }

    private void insertWtkobfuscateTasks() {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        Element element2 = this.findElement(element, ELEM_WTKOBFUSCATE);
        this.updateWtkObfuscateElement(element2);
        Element element3 = (Element)element2.getParentNode();
        for (Object object42 : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(((Configuration)object42).getName());
            object3 = (Element)element3.cloneNode(true);
            object3.setAttribute(ATTR_NAME, "-mtj-obfuscate-" + (String)string);
            object2 = XMLUtils.getFirstElementWithTagName((Element)object3, ELEM_WTKOBFUSCATE);
            object = "${path.build.output." + (String)string + "}/${midlet.name}.jad";
            String string2 = "${path.build.output." + (String)string + "}/${midlet.name}.jar";
            object2.setAttribute(ATTR_JADFILE, (String)object);
            object2.setAttribute(ATTR_JARFILE, string2);
            Element element4 = XMLUtils.getFirstElementWithTagName((Element)object3, ELEM_WTKPREVERIFY);
            element4.setAttribute(ATTR_JADFILE, (String)object);
            element4.setAttribute(ATTR_JARFILE, string2);
            element3.getParentNode().insertBefore((Node)object3, element3.getNextSibling());
        }
        object42 = (Element)element3.cloneNode(false);
        for (Object object5 : this.midletSuite.getConfigurations()) {
            object3 = this.replaceSpace(((Configuration)object5).getName());
            object2 = "-mtj-obfuscate-" + (String)object3;
            object = this.newChildElement((Element)object42, ELEM_ANTCALL);
            object.setAttribute("target", (String)object2);
        }
        element3.getParentNode().replaceChild((Node)object42, element3);
    }

    private Element newChildElement(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        return element2;
    }

    private StringBuffer readBuildXmlTemplate(InputStream inputStream) throws UnsupportedEncodingException, IOException {
        int n;
        char[] cArray = new char[1024];
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        inputStream.close();
        return stringBuffer;
    }

    private Document readMTJBuildTemplate() throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        InputStream inputStream = this.getClass().getResourceAsStream(MTJ_BUILD_XML_FILE_NAME);
        if (inputStream == null) {
            throw new IOException("build.xml template not found");
        }
        document = XMLUtils.readDocument(inputStream);
        Element element = document.getDocumentElement();
        element.setAttribute(ATTR_NAME, "mtj-" + this.projectName);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tAutomatically generated by MTJ on ").append(new Date()).append("\n\tDO NOT ALTER THIS FILE.  IT WILL BE OVERWRITTEN\n\n").append("\tChanges may be made to build.xml and user-build.properties\n");
        this.insertCommentBefore(element, stringBuffer.toString());
        return document;
    }

    private String replaceSpace(String string) {
        if (string == null) {
            return "";
        }
        return string.replace(' ', '_');
    }

    private void replaceTemplateValues(StringBuffer stringBuffer, Properties properties) {
        int n = 0;
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(stringBuffer);
        while (matcher.find(n)) {
            String string = matcher.group(1);
            String string2 = properties.getProperty(string, string);
            stringBuffer.replace(matcher.start(), matcher.end(), string2);
            n = matcher.start() + string2.length();
        }
    }

    private void setBootclasspathForConfigs(Properties properties) {
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            properties.setProperty("bootclasspath." + this.replaceSpace(configuration.getName()), configuration.getDevice().getClasspath().toString());
        }
    }

    private void setClassesFolderForConfigs(Properties properties) {
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(configuration.getName());
            properties.setProperty("path.build.classes." + string, "${basedir}/build/classes/" + string);
        }
    }

    private void setDeployFolderForConfigs(Properties properties) {
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(configuration.getName());
            properties.setProperty("path.build.output." + string, "${basedir}/" + MTJCorePlugin.getDeploymentDirectoryName() + "/" + string);
        }
    }

    private void setPreprocessOutputFolderForConfigs(Properties properties) {
        for (Configuration configuration : this.midletSuite.getConfigurations()) {
            String string = this.replaceSpace(configuration.getName());
            properties.setProperty("path.preprocess.output." + string, "${basedir}/preprocessOutput/" + string);
        }
    }

    private BuildClasspathEntryVisitor traverseClasspath(IProgressMonitor iProgressMonitor) throws CoreException {
        BuildClasspathEntryVisitor buildClasspathEntryVisitor = new BuildClasspathEntryVisitor(this.javaProject);
        buildClasspathEntryVisitor.getRunner(true).run(this.javaProject, buildClasspathEntryVisitor, iProgressMonitor);
        return buildClasspathEntryVisitor;
    }

    private void updateBuildProperties(Map<IJavaProject, ProjectInfo> map) {
        for (Map.Entry<IJavaProject, ProjectInfo> entry : map.entrySet()) {
            ProjectInfo projectInfo = entry.getValue();
            String string = projectInfo.getAntProjectPropertyValue();
            string = string.length() == 0 ? "${basedir}" : "${basedir}" + string;
            this.buildProperties.setProperty(projectInfo.getAntProjectPropertyName(), string);
        }
    }

    private void updateMTJBuildXml(Map<IJavaProject, ProjectInfo> map) {
        this.updateMtjInitializeTarget();
        this.updateWtkmakeprcTarget();
        this.insertBuildTasks(map);
        this.insertPackageTasks(map);
        this.insertPathElements(map);
        this.updateBuildProperties(map);
        this.insertWtkobfuscateTasks();
        this.updateWtkrunTarget();
    }

    private void updateMtjInitializeTarget() {
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("target");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (TASK_MTJ_INITIALIZE.equals(element2.getAttribute(ATTR_NAME))) {
                for (Configuration configuration : this.midletSuite.getConfigurations()) {
                    String string = this.replaceSpace(configuration.getName());
                    Element element3 = this.newChildElement(element2, ELEM_MKDIR);
                    element3.setAttribute(ATTR_DIR, "${path.build.classes." + string + "}/_no_export");
                }
                break;
            }
            ++n;
        }
    }

    private void updateWtkmakeprcTarget() {
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("target");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if ("-mtj-makeprc".equals(element2.getAttribute(ATTR_NAME))) {
                for (Configuration configuration : this.midletSuite.getConfigurations()) {
                    String string = this.replaceSpace(configuration.getName());
                    String string2 = "${path.build.output." + string + "}/${midlet.name}.jad";
                    String string3 = "${path.build.output." + string + "}/${midlet.name}.prc";
                    Element element3 = XMLUtils.createChild(element2, ELEM_WTKMAKEPRC);
                    element3.setAttribute(ATTR_JADFILE, string2);
                    element3.setAttribute(ATTR_PRCFILE, string3);
                }
                break;
            }
            ++n;
        }
    }

    private void updateWtkObfuscateElement(Element element) {
        String[] stringArray;
        String[] stringArray2 = stringArray = PreferenceAccessor.instance.getProguardKeepExpressions(this.midletSuite.getProject());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            StringBuffer stringBuffer = new StringBuffer("'-keep ");
            stringBuffer.append(string).append("'");
            this.addWtkObfuscateArgument(element, stringBuffer.toString());
            ++n2;
        }
        this.addWtkObfuscateArgument(element, this.getProguardOptions());
    }

    private void updateWtkrunTarget() {
        Element element = this.mtjBuildXmlDocument.getDocumentElement();
        Element element2 = this.findElement(element, ELEM_WTKRUN);
        String string = this.replaceSpace(this.midletSuite.getConfigurations().getActiveConfiguration().getName());
        String string2 = "${path.build.output." + string + "}/${midlet.name}.jad";
        element2.setAttribute(ATTR_JADFILE, string2);
    }

    private void validateAntenna(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        boolean bl = false;
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        String string = preferences.getString("antenna_jar");
        File file = new File(string);
        if (file.exists()) {
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("antenna.properties");
                bl = zipEntry != null;
                zipFile.close();
            }
            catch (IOException iOException) {
                MTJCorePlugin.log(2, "Error testing Antenna settings", iOException);
            }
        }
        if (!bl) {
            throw new AntennaExportException("Antenna library not found or not valid.\nCheck the preference settings.");
        }
    }

    private void validateEnvironment(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        this.validateAntenna(iProgressMonitor);
        this.validateWTK(iProgressMonitor);
    }

    private void validateWTK(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        File file = this.getWTKRoot();
        if (file == null || !file.exists()) {
            throw new AntennaExportException("Sun WTK not found.\nCheck the platform definition settings.");
        }
    }

    private void writeBuildProperties(IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        File file = this.getMidletSuiteFile("mtj-build.properties", iProgressMonitor);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.buildProperties.store(fileOutputStream, " MTJ Build Properties - DO NOT ALTER THIS FILE - Make changes in user-build.properties");
        fileOutputStream.close();
    }

    private void writeMTJBuildXml(IProgressMonitor iProgressMonitor) throws TransformerException, IOException, CoreException {
        File file = this.getMidletSuiteFile(MTJ_BUILD_XML_FILE_NAME, iProgressMonitor);
        XMLUtils.writeDocument(file, this.mtjBuildXmlDocument);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildClasspathEntryVisitor
    extends FilteringClasspathEntryVisitor {
        private Map<IJavaProject, ProjectInfo> projectInfoMap = new LinkedHashMap<IJavaProject, ProjectInfo>();

        public BuildClasspathEntryVisitor(IJavaProject iJavaProject) {
            this.createProjectInfo(iJavaProject, true);
        }

        private void addIncludesAndExcludes(IClasspathEntry iClasspathEntry, Element element) {
            Element element2;
            IPath iPath;
            int n = 0;
            while (n < iClasspathEntry.getExclusionPatterns().length) {
                iPath = iClasspathEntry.getExclusionPatterns()[n];
                element2 = AntennaBuildExporter.this.newChildElement(element, "exclude");
                element2.setAttribute(AntennaBuildExporter.ATTR_NAME, iPath.toString());
                ++n;
            }
            n = 0;
            while (n < iClasspathEntry.getInclusionPatterns().length) {
                iPath = iClasspathEntry.getInclusionPatterns()[n];
                element2 = AntennaBuildExporter.this.newChildElement(element, "include");
                element2.setAttribute(AntennaBuildExporter.ATTR_NAME, iPath.toString());
                ++n;
            }
        }

        private void createProjectInfo(IJavaProject iJavaProject, boolean bl) {
            ProjectInfo projectInfo = new ProjectInfo(iJavaProject, bl);
            this.projectInfoMap.put(iJavaProject, projectInfo);
        }

        private IPath getLibraryLocation(IClasspathEntry iClasspathEntry) throws CoreException {
            IPath iPath = null;
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                iPath = iResource.getLocation();
            } else if (object instanceof File) {
                iPath = iClasspathEntry.getPath();
            }
            return iPath;
        }

        private ProjectInfo getProjectInfo(IJavaProject iJavaProject) {
            return this.projectInfoMap.get(iJavaProject);
        }

        public Map<IJavaProject, ProjectInfo> getProjectInfoMap() {
            return this.projectInfoMap;
        }

        private String getProjectRelativeValue(IJavaProject iJavaProject, ProjectInfo projectInfo, IPath iPath) throws CoreException {
            StringBuffer stringBuffer = new StringBuffer();
            IPath iPath2 = iJavaProject.getProject().getLocation();
            String string = AntennaBuildExporter.this.getRelativePath(iPath2, iPath);
            if (string == null) {
                stringBuffer.append(iPath.toString());
            } else {
                stringBuffer.append("${").append(projectInfo.getAntProjectPropertyName()).append("}").append(string);
            }
            return stringBuffer.toString();
        }

        private IPath getSourceLocation(IClasspathEntry iClasspathEntry) throws CoreException {
            IPath iPath = null;
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                iPath = iResource.getLocation();
            }
            return iPath;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            ProjectInfo projectInfo = this.getProjectInfo(iJavaProject);
            Element element = projectInfo.getClasspathElement();
            IPath iPath = this.getLibraryLocation(iClasspathEntry);
            if (iPath != null) {
                File file = iPath.toFile();
                Element element2 = AntennaBuildExporter.this.newChildElement(element, AntennaBuildExporter.ELEM_PATH);
                String string = this.getProjectRelativeValue(iJavaProject, projectInfo, iPath);
                element2.setAttribute(AntennaBuildExporter.ATTR_LOCATION, string);
                this.addIncludesAndExcludes(iClasspathEntry, element2);
                if (this.isLibraryExported(iClasspathEntry)) {
                    if (file.isDirectory()) {
                        Element element3 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement(AntennaBuildExporter.ELEM_FILESET);
                        projectInfo.addPackageFilesetElement(element3);
                        element3.setAttribute(AntennaBuildExporter.ATTR_DIR, string);
                    } else {
                        Element element4 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement("zipfileset");
                        projectInfo.addPackageFilesetElement(element4);
                        element4.setAttribute("src", string);
                        this.addIncludesAndExcludes(iClasspathEntry, element4);
                    }
                }
            }
        }

        @Override
        public boolean visitProject(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IJavaProject iJavaProject2, IProgressMonitor iProgressMonitor) throws CoreException {
            boolean bl = iClasspathEntry.isExported();
            this.createProjectInfo(iJavaProject2, bl);
            return super.visitProject(iClasspathEntry, iJavaProject, iJavaProject2, iProgressMonitor);
        }

        @Override
        public void visitSourceEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            IPath iPath = this.getSourceLocation(iClasspathEntry);
            if (iPath != null) {
                ProjectInfo projectInfo = this.getProjectInfo(iJavaProject);
                String string = projectInfo.isExported() ? AntennaBuildExporter.ELEM_WTKBUILD : "javac";
                Element element = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement(string);
                projectInfo.addWtkBuildElement(iClasspathEntry, element);
                element.setAttribute(AntennaBuildExporter.ATTR_DESTDIR, projectInfo.getBuildDestination());
                element.setAttribute("sourcepath", "");
                element.setAttribute("encoding", "${src.encoding}");
                element.setAttribute("source", "1.3");
                String string2 = this.getProjectRelativeValue(iJavaProject, projectInfo, iPath);
                element.setAttribute(AntennaBuildExporter.ATTR_SRCDIR, string2);
                this.addIncludesAndExcludes(iClasspathEntry, element);
                Element element2 = AntennaBuildExporter.this.newChildElement(element, AntennaBuildExporter.ELEM_CLASSPATH);
                element2.setAttribute(AntennaBuildExporter.ATTR_REFID, projectInfo.getClasspathElementId());
                Element element3 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement(AntennaBuildExporter.ELEM_FILESET);
                element3.setAttribute(AntennaBuildExporter.ATTR_DIR, string2);
                Element element4 = AntennaBuildExporter.this.newChildElement(element3, "exclude");
                element4.setAttribute(AntennaBuildExporter.ATTR_NAME, "**/*.java");
                Element element5 = AntennaBuildExporter.this.newChildElement(element3, "exclude");
                element5.setAttribute(AntennaBuildExporter.ATTR_NAME, "build/");
                this.addIncludesAndExcludes(iClasspathEntry, element3);
                projectInfo.addPackageFilesetElement(element3);
            } else {
                MTJCorePlugin.log(2, "Skipping unresolvable classpath entry " + iClasspathEntry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectInfo {
        private String safeProjectName;
        private IJavaProject javaProject;
        private boolean exported;
        private Element classpathElement;
        private Map<IClasspathEntry, Element> wtkBuildElements;
        private List<Element> packageFilesetElements;

        ProjectInfo(IJavaProject iJavaProject, boolean bl) {
            this.javaProject = iJavaProject;
            this.exported = bl;
            this.wtkBuildElements = new HashMap<IClasspathEntry, Element>();
            this.packageFilesetElements = new ArrayList<Element>();
            this.safeProjectName = iJavaProject.getElementName();
            this.safeProjectName = this.safeProjectName.replace(' ', '_');
        }

        public void addPackageFilesetElement(Element element) {
            this.packageFilesetElements.add(element);
        }

        public void addWtkBuildElement(IClasspathEntry iClasspathEntry, Element element) {
            if (!this.wtkBuildElements.containsKey(iClasspathEntry)) {
                this.wtkBuildElements.put(iClasspathEntry, element);
            }
        }

        public String getAntProjectPropertyName() {
            return "project.root." + this.safeProjectName;
        }

        public String getAntProjectPropertyValue() {
            String string = null;
            IPath iPath = this.javaProject.getProject().getLocation();
            string = AntennaBuildExporter.this.getRelativePath(AntennaBuildExporter.this.basedirPath, iPath);
            if (string == null) {
                string = iPath.toString();
            }
            return string;
        }

        public String getBuildDestination() {
            return this.exported ? AntennaBuildExporter.PATH_BUILD_CLASSES : AntennaBuildExporter.PATH_BUILD_CLASSES_NO_EXPORT;
        }

        public Element getClasspathElement() {
            if (this.classpathElement == null) {
                this.classpathElement = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement(AntennaBuildExporter.ELEM_PATH);
                this.classpathElement.setAttribute(AntennaBuildExporter.ATTR_ID, this.getClasspathElementId());
                Element element = AntennaBuildExporter.this.newChildElement(this.classpathElement, AntennaBuildExporter.ELEM_PATH);
                element.setAttribute(AntennaBuildExporter.ATTR_LOCATION, AntennaBuildExporter.PATH_BUILD_CLASSES);
                element = AntennaBuildExporter.this.newChildElement(this.classpathElement, AntennaBuildExporter.ELEM_PATH);
                element.setAttribute(AntennaBuildExporter.ATTR_LOCATION, AntennaBuildExporter.PATH_BUILD_CLASSES_NO_EXPORT);
            }
            return this.classpathElement;
        }

        public String getClasspathElementId() {
            return "classpath." + this.safeProjectName;
        }

        public List<Element> getPackageFilesetElements() {
            return this.packageFilesetElements;
        }

        public Collection<Element> getWtkBuildElements() {
            return this.wtkBuildElements.values();
        }

        public boolean isExported() {
            return this.exported;
        }
    }
}

