/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.device.preprocess;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSetRegistry;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceSymbolDefinitionSetFactory {
    private static final String J2MEPOLISH_CAPABILITY_SEPARATOR = ",";
    public static final String J2MEPOLISH_FILENAME_XML_DEVICES = "devices.xml";
    public static final String J2MEPOLISH_FILENAME_XML_GROUPS = "groups.xml";

    private static void copyCapabilities(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        for (String string : hashMap2.keySet()) {
            DeviceSymbolDefinitionSetFactory.copyCapability(hashMap, string, hashMap2.get(string));
        }
    }

    private static void copyCapability(HashMap<String, String> hashMap, String string, String string2) {
        String string3 = hashMap.get(string);
        if (string3 == null || string3.equals("")) {
            hashMap.put(string, string2);
        } else {
            String string4 = DeviceSymbolDefinitionSetFactory.mergeCapabilities(string3, string2);
            hashMap.put(string, string4);
        }
    }

    public static SymbolDefinitionSet createSymbolDefinitionSet(String string, HashMap<String, String> hashMap) {
        SymbolDefinitionSet symbolDefinitionSet = new SymbolDefinitionSet(string);
        symbolDefinitionSet.define(string);
        for (String string2 : hashMap.keySet()) {
            try {
                String string3 = hashMap.get(string2);
                symbolDefinitionSet.define(string2, string3);
            }
            catch (RuntimeException runtimeException) {
                MTJCorePlugin.log(4, runtimeException);
            }
        }
        return symbolDefinitionSet;
    }

    private static HashMap<String, String> getGroupCapabilities(HashMap<String, Element> hashMap, String string) {
        Element element;
        Object object;
        Element element2 = hashMap.get(string);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        NodeList nodeList = element2.getElementsByTagName("parent");
        if (nodeList != null && nodeList.getLength() > 0 && (object = (element = (Element)nodeList.item(0)).getTextContent()) != null && !element.getTextContent().equals("")) {
            HashMap<String, String> hashMap3 = DeviceSymbolDefinitionSetFactory.getGroupCapabilities(hashMap, element.getTextContent());
            DeviceSymbolDefinitionSetFactory.copyCapabilities(hashMap2, hashMap3);
        }
        nodeList = element2.getElementsByTagName("capability");
        int n = 0;
        while (n < nodeList.getLength()) {
            object = (Element)nodeList.item(n);
            hashMap2.put(object.getAttribute("name"), object.getAttribute("value"));
            ++n;
        }
        return hashMap2;
    }

    public static SymbolDefinitionSet[] importFromJ2MEPolishFormat(IProgressMonitor iProgressMonitor, InputStream inputStream, InputStream inputStream2) throws PersistenceException, ParserConfigurationException, SAXException, IOException {
        Vector vector = new Vector();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Document document2 = documentBuilder.parse(inputStream2);
        HashMap<String, Element> hashMap = DeviceSymbolDefinitionSetFactory.prepareGroups(document2);
        NodeList nodeList = document.getElementsByTagName("device");
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Importing...", nodeList.getLength());
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Object object2;
            Object object3;
            Element element;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            Element element2 = (Element)nodeList.item(n);
            String string = ((Element)element2.getElementsByTagName("identifier").item(0)).getTextContent();
            Element element3 = (Element)element2.getElementsByTagName("features").item(0);
            if (element3 != null) {
                String string2 = element3.getTextContent();
                hashMap2.put("features", string2);
            }
            if ((element = (Element)element2.getElementsByTagName("groups").item(0)) != null) {
                object3 = new StringTokenizer(element.getTextContent(), J2MEPOLISH_CAPABILITY_SEPARATOR);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken().trim();
                    HashMap<String, String> hashMap3 = DeviceSymbolDefinitionSetFactory.getGroupCapabilities(hashMap, (String)object2);
                    DeviceSymbolDefinitionSetFactory.copyCapabilities(hashMap2, hashMap3);
                }
                hashMap2.put("groups", element.getTextContent().toLowerCase());
            }
            object3 = element2.getElementsByTagName("capability");
            int n2 = 0;
            while (n2 < object3.getLength()) {
                object = (Element)object3.item(n2);
                DeviceSymbolDefinitionSetFactory.copyCapability(hashMap2, object.getAttribute("name"), object.getAttribute("value"));
                ++n2;
            }
            hashMap2.put(string, "true");
            object2 = new StringTokenizer(string, J2MEPOLISH_CAPABILITY_SEPARATOR);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
                object = ((String)object).replace('/', '_');
                object = ((String)object).replace('(', '_');
                object = ((String)object).replace(')', '_');
                SymbolDefinitionSet symbolDefinitionSet = DeviceSymbolDefinitionSetFactory.createSymbolDefinitionSet((String)object, hashMap2);
                SymbolDefinitionSetRegistry.singleton.addDefinitionSet(symbolDefinitionSet);
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            ++n;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
        if (vector.size() != 0) {
            Object[] objectArray = new SymbolDefinitionSet[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private static String mergeCapabilities(String string, String string2) {
        String string3;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        stringTokenizer = new StringTokenizer(string2, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (vector.indexOf(string3) != -1) continue;
            vector.add(string3);
        }
        string3 = "";
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                string3 = string3.concat(J2MEPOLISH_CAPABILITY_SEPARATOR);
            }
            string3 = string3.concat((String)vector.elementAt(n));
            ++n;
        }
        return string3;
    }

    private static HashMap<String, Element> prepareGroups(Document document) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        NodeList nodeList = document.getElementsByTagName("group");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = ((Element)element.getElementsByTagName("name").item(0)).getTextContent();
            hashMap.put(string, element);
            ++n;
        }
        return hashMap;
    }
}

