/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mtj.internal.ui.editor.SystemFileStorage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class SystemFileEditorInput
implements IStorageEditorInput,
IPersistableElement {
    private static final String FACTORY_ID = String.valueOf(MTJUIPlugin.getPluginId()) + ".systemFileEditorInputFactory";
    private SystemFileStorage storage;

    public SystemFileEditorInput(File file) {
        this.storage = new SystemFileStorage(file);
    }

    public boolean equals(Object object) {
        return object instanceof SystemFileEditorInput && this.getStorage().equals(((SystemFileEditorInput)object).getStorage());
    }

    public boolean exists() {
        return this.storage.getFile().exists();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(File.class)) {
            return this.storage.getFile();
        }
        return null;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getFile().getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public String getToolTipText() {
        return this.storage.getFile().getAbsolutePath();
    }

    public int hashCode() {
        return this.getStorage().hashCode();
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString("path", this.storage.getFile().getAbsolutePath());
    }
}

