/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.ui.internal.forms.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IFormPart;

public class L10nLocaleDetails
extends L10nAbstractDetails {
    private L10nLocale locale = null;
    private FormEntry localeCountryCodeEntry = null;
    private FormEntry localeLanguageCodeEntry = null;

    public L10nLocaleDetails(LocalesTreeSection localesTreeSection) {
        super(localesTreeSection, "l10n-context");
    }

    public void commit(boolean bl) {
        super.commit(bl);
        this.localeCountryCodeEntry.commit();
        this.localeLanguageCodeEntry.commit();
    }

    public void createFields(Composite composite) {
        this.createLanguageCodeWidget(composite);
        this.createSpace(composite);
        this.createCountryCodeWidget(composite);
    }

    public void hookListeners() {
        this.createLocaleCountryCodeEntryListeners();
        this.createLocaleLanguageCodeEntryListeners();
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        Object object = this.getFirstSelectedObject(iSelection);
        if (object != null && object instanceof L10nLocale) {
            this.setData((L10nLocale)object);
            this.updateFields();
        }
    }

    public void setData(L10nLocale l10nLocale) {
        this.locale = l10nLocale;
    }

    public void updateFields() {
        if (this.locale != null) {
            this.updateLocaleCountryCodeEntry(this.isEditableElement());
            this.updateLocaleLanguageCodeEntry(this.isEditableElement());
        }
    }

    private void createCountryCodeWidget(Composite composite) {
        this.localeCountryCodeEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocaleDetails_countrycode_label, MTJUIMessages.L10nLocaleDetails_choose_btn_label, false);
        this.localeCountryCodeEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createLanguageCodeWidget(Composite composite) {
        this.localeLanguageCodeEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocaleDetails_languagecode_label, MTJUIMessages.L10nLocaleDetails_choose_btn_label, false);
        this.localeLanguageCodeEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createLocaleCountryCodeEntryListeners() {
        this.localeCountryCodeEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry formEntry) {
                L10nLocaleDetails.this.handleContryCodeEntryBrowse();
            }

            public void textValueChanged(FormEntry formEntry) {
                if (L10nLocaleDetails.this.locale != null) {
                    L10nLocaleDetails.this.locale.setCountryCode(L10nLocaleDetails.this.localeCountryCodeEntry.getValue());
                    L10nLocaleDetails.this.locale.validate();
                }
            }
        });
    }

    private void createLocaleLanguageCodeEntryListeners() {
        this.localeLanguageCodeEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry formEntry) {
                L10nLocaleDetails.this.handleLanguageCodeEntryBrowse();
            }

            public void textValueChanged(FormEntry formEntry) {
                if (L10nLocaleDetails.this.locale != null) {
                    L10nLocaleDetails.this.locale.setLanguageCode(L10nLocaleDetails.this.localeLanguageCodeEntry.getValue());
                    L10nLocaleDetails.this.locale.validate();
                }
            }
        });
    }

    private void handleContryCodeEntryBrowse() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new LabelProvider());
        elementListSelectionDialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationCountryBrowseDialog_title);
        elementListSelectionDialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationCountryBrowseDialog_message);
        elementListSelectionDialog.setElements((Object[])Locale.getISOCountries());
        if (elementListSelectionDialog.open() == 0) {
            String string = (String)elementListSelectionDialog.getFirstResult();
            this.localeCountryCodeEntry.setValue(string);
        }
    }

    private void handleLanguageCodeEntryBrowse() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new LabelProvider());
        elementListSelectionDialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationLanguageBrowseDialog_title);
        elementListSelectionDialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationLanguageBrowseDialog_message);
        elementListSelectionDialog.setElements((Object[])Locale.getISOLanguages());
        if (elementListSelectionDialog.open() == 0) {
            String string = (String)elementListSelectionDialog.getFirstResult();
            this.localeLanguageCodeEntry.setValue(string);
        }
    }

    private void updateLocaleCountryCodeEntry(boolean bl) {
        this.localeCountryCodeEntry.setValue(this.locale.getCountryCode(), true);
        this.localeCountryCodeEntry.setEditable(bl);
    }

    private void updateLocaleLanguageCodeEntry(boolean bl) {
        this.localeLanguageCodeEntry.setValue(this.locale.getLanguageCode(), true);
        this.localeLanguageCodeEntry.setEditable(bl);
    }

    protected L10nObject getDataObject() {
        return this.locale;
    }

    protected String getDetailsDescription() {
        return MTJUIMessages.L10nLocaleDetails_detailsDescription;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nLocaleDetails_detailsTitle;
    }
}

